/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features;

import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.ModifiedFeature;
import fi.csc.microarray.databeans.features.Modifier;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import java.util.List;

public class RestrictModifier
implements Modifier {
    public static final int RESTRICT_TO_CELLS = 1000000;
    private RestrictModifierFeature output;

    @Override
    public Feature getOutput() {
        return this.output;
    }

    @Override
    public void setInputs(List<Feature> inputs) {
        this.output = new RestrictModifierFeature(inputs);
    }

    private static class RestrictModifierFeature
    extends ModifiedFeature {
        private Feature original;

        protected RestrictModifierFeature(List<Feature> inputs) {
            super(inputs);
            if (inputs.size() != 1) {
                throw new IllegalArgumentException("restrict modifier must have 1 parameter");
            }
            this.original = inputs.get(0);
        }

        @Override
        public Table asTable() throws MicroarrayException {
            Table table = this.original.asTable();
            if (table == null) {
                return null;
            }
            return new RestrictedTable(table);
        }
    }

    public static class RestrictedTable
    implements Table {
        private Table table;
        private int row = 0;
        private Integer restrictToRows = null;

        public RestrictedTable(Table table) {
            this.table = table;
            this.restrictToRows = (int)Math.ceil(1000000.0f / (float)this.getColumnCount());
        }

        @Override
        public String[] getColumnNames() {
            return this.table.getColumnNames();
        }

        @Override
        public int getColumnCount() {
            return this.table.getColumnCount();
        }

        @Override
        public float getFloatValue(String columnName) {
            return this.table.getFloatValue(columnName);
        }

        @Override
        public int getIntValue(String columnName) {
            return this.table.getIntValue(columnName);
        }

        @Override
        public String getStringValue(String columnName) {
            return this.table.getStringValue(columnName);
        }

        @Override
        public Object getValue(String columnName) {
            return this.table.getValue(columnName);
        }

        @Override
        public boolean hasColumn(String columnName) {
            return this.table.hasColumn(columnName);
        }

        @Override
        public boolean nextRow() {
            ++this.row;
            return this.row < this.restrictToRows && this.table.nextRow();
        }

        @Override
        public void close() {
            this.table.close();
        }

        public Integer getRestrictedRows() {
            return this.restrictToRows;
        }
    }
}

