/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features;

import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.features.QueryResult;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.ModuleManager;
import fi.csc.microarray.module.basic.BasicModule;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class FeatureTest {
    private DataManager manager;

    public FeatureTest() throws Exception {
        DirectoryLayout.uninitialise();
        DirectoryLayout.initialiseUnitTestLayout();
        this.manager = new DataManager();
        new ModuleManager("fi.csc.microarray.module.chipster.MicroarrayModule").plugAll(this.manager, null);
    }

    @Test
    public void testPhenodataFeatures() throws IOException, MicroarrayException {
        DataBean data = this.manager.createDataBean("filtered.tsv", new FileInputStream("src/test/resources/filtered_4_chips.tsv"));
        DataBean phenoData = this.manager.createDataBean("phenodata.tsv", new FileInputStream("src/test/resources/phenodata_4_chips.tsv"));
        phenoData.addTypeTag(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES);
        phenoData.addLink(DataBean.Link.ANNOTATION, data);
        Assert.assertTrue((boolean)phenoData.queryFeatures("/phenodata/").exists());
        Assert.assertTrue((boolean)phenoData.queryFeatures("/phenodata/is_complete").exists());
        Assert.assertEquals((Object)phenoData.queryFeatures("/phenodata/describe/microarray1.cel").asString(), (Object)"GSM11814.cel");
        Assert.assertEquals((Object)phenoData.queryFeatures("/phenodata/describe/not_in_phenodata").asString(), (Object)"not_in_phenodata");
        Assert.assertTrue((boolean)data.queryFeatures("/phenodata/linked/").exists());
        Assert.assertTrue((boolean)data.queryFeatures("/phenodata/linked/is_complete").exists());
    }

    @Test
    public void testModifiers() throws IOException, MicroarrayException {
        float f;
        DataBean affyMicroarray = this.manager.createDataBean("affy.cel", new FileInputStream("src/test/resources/affy_example.cel"));
        QueryResult feature = affyMicroarray.queryFeatures("log(/normalised-expression)");
        Assert.assertTrue((boolean)feature.exists());
        float last = 1.0f;
        Iterator<Float> iterator = feature.asFloats().iterator();
        while (iterator.hasNext()) {
            last = f = iterator.next().floatValue();
        }
        iterator = feature.asFloats().iterator();
        while (iterator.hasNext()) {
            last = f = iterator.next().floatValue();
        }
        Assert.assertEquals((float)last, (float)7.426265f, (float)0.01f);
        QueryResult doubleFeature = affyMicroarray.queryFeatures("log(log(/normalised-expression))");
        Assert.assertTrue((boolean)doubleFeature.exists());
    }

    @Test
    public void testTableColumnIterable() throws MicroarrayException, IOException {
        Iterable[] iterables;
        DataBean affyMicroarray = this.manager.createDataBean("affy.cel", new FileInputStream("src/test/resources/affy_example.cel"));
        QueryResult mean = affyMicroarray.queryFeatures("/column/MEAN");
        for (Iterable iterable : iterables = new Iterable[]{mean.asFloats(), mean.asStrings()}) {
            Iterator iterator = iterable.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
    }

    @Test
    public void testFeatures() throws MicroarrayException, IOException {
        DataBean affyMicroarray = this.manager.createDataBean("affy.cel", new FileInputStream("src/test/resources/affy_example.cel"));
        affyMicroarray.addTypeTag(MicroarrayModule.TypeTags.RAW_AFFYMETRIX_EXPRESSION_VALUES);
        affyMicroarray.addTypeTag(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES);
        for (String feature : new String[]{"/normalised-expression", "/column/MEAN"}) {
            Assert.assertNotNull((String)("error in " + feature), affyMicroarray.queryFeatures(feature).asFloats());
            for (float f : affyMicroarray.queryFeatures(feature).asFloats()) {
                Assert.assertTrue((String)("illegal value: " + f + " in " + feature), ((double)f > 0.0 ? 1 : 0) != 0);
            }
        }
        Assert.assertTrue((affyMicroarray.queryFeatures("/column/MEAN").asFloats().iterator().next().floatValue() == 190.0f ? 1 : 0) != 0);
        float last = 0.0f;
        Iterator<Float> iterator = affyMicroarray.queryFeatures("/column/MEAN").asFloats().iterator();
        while (iterator.hasNext()) {
            float f;
            last = f = iterator.next().floatValue();
        }
        Assert.assertTrue((last == 172.0f ? 1 : 0) != 0);
        Assert.assertTrue((boolean)MicroarrayModule.VisualisationMethods.ARRAY_LAYOUT.isApplicableTo(affyMicroarray));
        DataBean somData = this.manager.createDataBean("som.tsv", new FileInputStream("src/test/resources/som.tsv"));
        somData.addTypeTag(MicroarrayModule.TypeTags.SOM_CLUSTERED_EXPRESSION_VALUES);
        somData.addTypeTag(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES);
        Assert.assertTrue((boolean)MicroarrayModule.VisualisationMethods.SOM.isApplicableTo(somData));
        Table som = somData.queryFeatures("/clusters/som").asTable();
        Assert.assertNotNull((Object)som);
        Assert.assertEquals((long)som.getColumnCount(), (long)5L);
        DataBean hcTree = this.manager.createDataBean("hs.tre", new FileInputStream("src/test/resources/hc.tre"));
        DataBean hcHeatmap = this.manager.createDataBean("hc.tsv", new FileInputStream("src/test/resources/hc-normalized.tsv"));
        hcHeatmap.addTypeTag(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES);
        hcHeatmap.addTypeTag(MicroarrayModule.TypeTags.NORMALISED_EXPRESSION_VALUES);
        hcTree.addLink(DataBean.Link.DERIVATION, hcHeatmap);
        Assert.assertTrue((boolean)MicroarrayModule.VisualisationMethods.HIERARCHICAL.isApplicableTo(hcTree));
        Table heatmap = hcTree.queryFeatures("/clusters/hierarchical/heatmap").asTable();
        Assert.assertNotNull((Object)heatmap);
        heatmap.nextRow();
        Assert.assertNotNull((Object)heatmap.getValue(" "));
        String tree = hcTree.queryFeatures("/clusters/hierarchical/tree").asStrings().iterator().next();
        Assert.assertNotNull((Object)tree);
    }
}

