/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import fi.csc.microarray.comp.SessionReplayTest;
import fi.csc.microarray.comp.ToolTestResult;
import fi.csc.microarray.comp.ToolTestSummary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class ToolTestTextFile {
    public static final String TEXT_FILE_SEPARATOR = ";;;;";
    private static final String TEXT_RESULTS_FILE = "results.txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ToolTestSummary summary, File webDir) throws IOException {
        File resultsFile = new File(webDir, TEXT_RESULTS_FILE);
        FileWriter writer = new FileWriter(resultsFile);
        try {
            for (ToolTestResult result : summary.getToolTestResults()) {
                writer.write((Object)((Object)result.getTestResult()) + TEXT_FILE_SEPARATOR + result.getToolName() + TEXT_FILE_SEPARATOR + result.getToolId() + TEXT_FILE_SEPARATOR + result.getToolFullName() + TEXT_FILE_SEPARATOR + result.getTaskId() + TEXT_FILE_SEPARATOR + result.getTaskState() + TEXT_FILE_SEPARATOR + ToolTestTextFile.nullToEmpty(result.getTaskErrorMessage()).replaceAll("\n", " ") + TEXT_FILE_SEPARATOR + result.getTaskDuration() + TEXT_FILE_SEPARATOR + result.getSession() + TEXT_FILE_SEPARATOR + ToolTestTextFile.nullToEmpty(result.getTestErrorMessage()) + TEXT_FILE_SEPARATOR);
                writer.write("\n");
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ToolTestResult> parse(File inputDir) throws IOException {
        LinkedList<ToolTestResult> toolTestResults = new LinkedList<ToolTestResult>();
        File resultsFile = new File(inputDir, TEXT_RESULTS_FILE);
        if (!resultsFile.exists()) {
            throw new FileNotFoundException(resultsFile.getAbsolutePath());
        }
        BufferedReader reader = new BufferedReader(new FileReader(resultsFile));
        try {
            String line = reader.readLine();
            while (line != null) {
                if (!line.trim().isEmpty()) {
                    String[] parts = line.split(TEXT_FILE_SEPARATOR, -1);
                    SessionReplayTest.TestResult testResult = SessionReplayTest.TestResult.valueOf(parts[0]);
                    String toolName = parts[1];
                    String toolId = parts[2];
                    String toolFullName = parts[3];
                    String taskId = parts[4];
                    String taskState = parts[5];
                    String taskErrorMessage = parts[6];
                    long taskDuration = Long.parseLong(parts[7]);
                    File sessionFile = new File(parts[8]);
                    String testErrorMessage = parts[9];
                    ToolTestResult singleResult = new ToolTestResult(testResult, taskId, taskState, taskErrorMessage, taskDuration, toolId, toolName, toolFullName, sessionFile, testErrorMessage);
                    toolTestResults.add(singleResult);
                }
                line = reader.readLine();
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return toolTestResults;
    }

    private static String nullToEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

