/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import fi.csc.microarray.comp.python.PythonCompJob;
import fi.csc.microarray.comp.r.RCompJob;
import org.junit.Assert;
import org.junit.Test;

public class ParameterSecurityPolicyTest {
    @Test
    public void testText() throws Exception {
        String[] reject = new String[]{"\"stop()", "\"", "'", "\t", "\n", "$", "{}", "\u2600"};
        String[] accept = new String[]{"abc", "123", "hgu133ahsentrezg(hgu133a)", "jou()", "*", "+", ",", ".", "-", "_", " ", "\u00e5\u00d6\u00e4", "\u00e9", "", "s", "\u00e3"};
        for (String s : reject) {
            System.out.print("testing " + s);
            Assert.assertFalse((boolean)s.matches(RCompJob.RParameterSecurityPolicy.TEXT_VALUE_PATTERN));
            Assert.assertFalse((boolean)s.matches(PythonCompJob.PythonParameterSecurityPolicy.TEXT_VALUE_PATTERN));
            System.out.println(" -> rejected");
        }
        for (String s : accept) {
            System.out.print("testing " + s);
            Assert.assertTrue((boolean)s.matches(RCompJob.RParameterSecurityPolicy.TEXT_VALUE_PATTERN));
            Assert.assertTrue((boolean)s.matches(PythonCompJob.PythonParameterSecurityPolicy.TEXT_VALUE_PATTERN));
            System.out.println(" -> accepted");
        }
    }

    @Test
    public void testNumber() throws Exception {
        String[] reject = new String[]{"\"stop()", "\"", "'", "abc", "$", "{}", "\u2600"};
        String[] accept = new String[]{"0", "123", "-0", "-10000000000000000000000000000000", "1.7", "1324234.7009808"};
        for (String s : reject) {
            System.out.print("testing " + s);
            Assert.assertFalse((boolean)s.matches(RCompJob.RParameterSecurityPolicy.NUMERIC_VALUE_PATTERN));
            System.out.println(" -> rejected");
        }
        for (String s : accept) {
            System.out.print("testing " + s);
            Assert.assertTrue((boolean)s.matches(RCompJob.RParameterSecurityPolicy.NUMERIC_VALUE_PATTERN));
            System.out.println(" -> accepted");
        }
    }

    public static void main(String[] args) throws Exception {
        ParameterSecurityPolicyTest t = new ParameterSecurityPolicyTest();
        t.testText();
        t.testNumber();
        System.out.println("ParameterSecurityPolicyTest OK");
    }
}

