/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.SelectionText;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Selectable;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;

public class PeakSelectable
extends Selectable {
    private static final int MIN_VISIBLE_PEAK_SIZE = 5;
    public static final int PEAK_SYMBOL_HEIGHT = 16;
    private RectDrawable rectDrawable;
    private Region region;
    private SelectionText selectionText;

    public PeakSelectable(Region region, IndexKey indexKey, SelectionText selectionText) {
        super(indexKey);
        this.region = region;
        this.selectionText = selectionText;
    }

    @Override
    public List<Drawable> getDrawables() {
        LinkedList<Drawable> drawables = new LinkedList<Drawable>();
        if (this.isSelected()) {
            this.rectDrawable.color = this.rectDrawable.color.brighter();
        }
        drawables.add(this.rectDrawable);
        return drawables;
    }

    public Region getRegion() {
        return this.region;
    }

    public void render(GBrowserView view, Color color) {
        Rectangle rect = new Rectangle();
        rect.x = view.bpToTrack(this.region.start);
        rect.width = view.bpToTrack(this.region.end) - rect.x;
        if (rect.width < 5) {
            rect.width = 5;
        }
        rect.y = 0;
        rect.height = 16;
        this.rectDrawable = new RectDrawable(rect, color, color.darker());
    }

    @Override
    public String getText() {
        if (this.selectionText != null) {
            return this.selectionText.getText();
        }
        return null;
    }

    @Override
    public double getDistance(Point point) {
        return this.distance(this.rectDrawable.getBounds(), point);
    }
}

