/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.CnaRow;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

public class CnaFlagTrack
extends Track {
    private static final int MIN_VISIBLE_SIZE = 5;
    private static final int SYMBOL_HEIGHT = 10;
    private TreeMap<IndexKey, CnaRow> rows = new TreeMap();
    private Color gainColor = GBrowserConstants.COLOR_RED;
    private Color lossColor = GBrowserConstants.COLOR_BLUE;
    private int sampleIndex;

    public CnaFlagTrack(Color gainColor, int sampleIndex, Color lossColor) {
        this.sampleIndex = sampleIndex;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.rows != null) {
            Iterator<IndexKey> iter = this.rows.keySet().iterator();
            while (iter.hasNext()) {
                CnaRow row = this.rows.get(iter.next());
                if (!this.getView().requestIntersects(row.getRegion())) {
                    iter.remove();
                    continue;
                }
                int y = 0;
                CnaRow.Sample sample = row.getSamples().get(this.sampleIndex);
                Color color = Color.lightGray;
                if (sample.getFlag() == null) continue;
                if (sample.getFlag().floatValue() < 0.0f) {
                    color = this.gainColor;
                } else if (sample.getFlag().floatValue() > 0.0f) {
                    color = this.lossColor;
                }
                int alpha = 255 - (int)Math.min(1.0, (double)Math.abs(sample.getFlag().floatValue()) * 255.0);
                Color aColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
                this.createDrawable(row.getRegion().start, row.getRegion().end, y, 10, aColor, drawables);
            }
        }
        return drawables;
    }

    private void createDrawable(BpCoord startBp, BpCoord endBp, int y, int height, Color c, Collection<Drawable> drawables) {
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp);
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        if (rect.width < 5) {
            rect.width = 5;
        }
        rect.y = y;
        rect.height = height;
        drawables.add(new RectDrawable(rect, c, c));
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        for (Feature region : dataResult.getFeatures()) {
            this.rows.put((IndexKey)region.values.get((Object)DataType.ID), (CnaRow)region.values.get((Object)DataType.VALUE));
        }
    }

    @Override
    public void defineDataTypes() {
        this.addDataType(DataType.ID);
        this.addDataType(DataType.VALUE);
    }

    @Override
    public int getTrackHeight() {
        return 10;
    }
}

