/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.GeneTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.RepeatMaskerTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.RulerTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TranscriptTrack;
import java.awt.Color;

public class AnnotationTrackGroup
extends TrackGroup {
    protected TranscriptTrack transcript;
    protected Track geneOverview;
    protected Track gene;
    protected RepeatMaskerTrack repeatMasker;
    protected Track geneOverviewReversed;
    protected Track geneReversed;
    protected TranscriptTrack transcriptReversed;
    private boolean isUserData;
    private DataThread annotationDataSource;
    private DataThread repeatDataSource;
    private boolean repeat;

    public AnnotationTrackGroup(GBrowserView dataView, DataThread annotationDataSource, DataThread repeatDataSource, boolean isUserData) {
        super(dataView);
        this.isUserData = isUserData;
        this.annotationDataSource = annotationDataSource;
        this.repeatDataSource = repeatDataSource;
        this.initTracks();
        if (isUserData) {
            this.setName(annotationDataSource.getDataSource().getDataUrl().getName());
        } else {
            this.setName("Annotations");
        }
        this.setSettingsEnabled(true);
    }

    private void initTracks() {
        this.getStatusAnimation().clear();
        if (this.annotationDataSource != null) {
            this.transcript = new TranscriptTrack();
            this.transcript.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.transcript.setView(this.view);
            this.transcript.addDataThread(this.annotationDataSource);
            this.transcript.setStrand(Strand.FORWARD);
            this.gene = new GeneTrack(GBrowserConstants.COLOR_BLUE_BRIGHTER);
            this.gene.setViewLimits(GBrowserConstants.SWITCH_VIEWS_AT, 10000000L);
            this.gene.setView(this.view);
            this.gene.addDataThread(this.annotationDataSource);
            this.gene.setStrand(Strand.FORWARD);
            super.getStatusAnimation().addDataThread(this.annotationDataSource);
        }
        if (this.repeatDataSource != null) {
            this.repeatMasker = new RepeatMaskerTrack();
            this.repeatMasker.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.repeatMasker.setView(this.view);
            this.repeatMasker.addDataThread(this.repeatDataSource);
            super.getStatusAnimation().addDataThread(this.repeatDataSource);
        }
        if (this.annotationDataSource != null) {
            this.geneReversed = new GeneTrack(GBrowserConstants.COLOR_BLUE_BRIGHTER);
            this.geneReversed.setViewLimits(GBrowserConstants.SWITCH_VIEWS_AT, 10000000L);
            this.geneReversed.setView(this.view);
            this.geneReversed.addDataThread(this.annotationDataSource);
            this.geneReversed.setStrand(Strand.REVERSE);
            this.transcriptReversed = new TranscriptTrack();
            this.transcriptReversed.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.transcriptReversed.setView(this.view);
            this.transcriptReversed.addDataThread(this.annotationDataSource);
            this.transcriptReversed.setStrand(Strand.REVERSE);
        }
        this.addTracks();
    }

    @Override
    public void addTracks() {
        this.tracks.clear();
        if (!this.isMinimized() && this.transcript != null) {
            this.addTrack(this.transcript);
            this.addTrack(this.gene);
        }
        if (this.isUserData) {
            if (!this.isMinimized()) {
                SeparatorTrack separator = new SeparatorTrack(Color.gray, 1);
                separator.setView(this.view);
                this.addTrack(separator);
            }
        } else {
            if (this.isMinimized()) {
                SeparatorTrack separator = new SeparatorTrack(Color.white, 20);
                separator.setView(this.view);
                this.addTrack(separator);
            }
            RulerTrack ruler = new RulerTrack();
            ruler.setView(this.view);
            this.addTrack(ruler);
        }
        if (!this.isMinimized() && this.repeatMasker != null && this.repeat) {
            this.addTrack(this.repeatMasker);
        }
        if (!this.isMinimized() && this.transcript != null) {
            this.addTrack(this.geneReversed);
            this.addTrack(this.transcriptReversed);
        }
        if (this.isShowMore()) {
            if (this.gene != null && this.geneReversed != null) {
                this.gene.setLayoutMode(LayoutTool.LayoutMode.FULL);
                this.geneReversed.setLayoutMode(LayoutTool.LayoutMode.FULL);
            }
            if (this.transcript != null && this.transcriptReversed != null) {
                this.transcript.setLayoutMode(LayoutTool.LayoutMode.FULL);
                this.transcriptReversed.setLayoutMode(LayoutTool.LayoutMode.FULL);
            }
        } else {
            if (this.gene != null && this.geneReversed != null) {
                this.gene.setDefaultLayoutMode();
                this.geneReversed.setDefaultLayoutMode();
            }
            if (this.transcript != null && this.transcriptReversed != null) {
                this.transcript.setDefaultLayoutMode();
                this.transcriptReversed.setDefaultLayoutMode();
            }
        }
    }

    public void setRepeatVisible(boolean selected) {
        this.repeat = selected;
        this.addTracks();
    }
}

