/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BinarySearchIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.GtfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.Index;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Test;

public class BinarySearchIndexTest {
    @Test
    public void run() throws IOException, UnsortedDataException, GBrowserException, URISyntaxException {
        File testFile = BinarySearchIndexTest.getTestFile(0);
        BinarySearchIndexTest.runTests(testFile);
        testFile.delete();
        testFile = BinarySearchIndexTest.getTestFile(1);
        BinarySearchIndexTest.runTests(testFile);
        testFile.delete();
        testFile = BinarySearchIndexTest.getTestFile(20);
        BinarySearchIndexTest.runTests(testFile);
        testFile.delete();
    }

    private static void runTests(File file) throws IOException, GBrowserException, UnsortedDataException, FileNotFoundException, URISyntaxException, MalformedURLException {
        DataUrl dataUrl = new DataUrl(file);
        BinarySearchIndex index = new BinarySearchIndex(new RandomAccessLineDataSource(dataUrl), new GtfLineParser());
        Region region = new Region(1L, 1L, new Chromosome("chr1"));
        Collection<String> lines = ((Index)index).getFileLines(region).values();
        Assert.assertTrue((boolean)lines.isEmpty());
        region = new Region(2L, 1L, new Chromosome("chr1"));
        lines = ((Index)index).getFileLines(region).values();
        Assert.assertTrue((boolean)lines.isEmpty());
        region = new Region(0L, 1L, new Chromosome("chr1"));
        lines = ((Index)index).getFileLines(region).values();
        Assert.assertEquals((long)1L, (long)lines.size());
        Assert.assertEquals((Object)"chr1\tsource\tfeature\t0\t0\tQuality0000\tStrand0000\tFrame0000\tMetadata0000\t", (Object)lines.iterator().next());
        region = new Region(1L, 2L, new Chromosome("chr1"));
        lines = ((Index)index).getFileLines(region).values();
        Assert.assertEquals((long)1L, (long)lines.size());
        Assert.assertEquals((Object)"chr1\tsource\tfeature\t1\t1\tQuality0001\tStrand0001\tFrame0001\tMetadata0001\t", (Object)lines.iterator().next());
        region = new Region(1000L, 2000L, new Chromosome("chr1"));
        lines = ((Index)index).getFileLines(region).values();
        Assert.assertEquals((long)1000L, (long)lines.size());
        region = new Region(4000L, 6000L, new Chromosome("chr1"));
        lines = ((Index)index).getFileLines(region).values();
        Assert.assertEquals((long)2000L, (long)lines.size());
        region = new Region(9998L, 9999L, new Chromosome("chr1"));
        lines = ((Index)index).getFileLines(region).values();
        Assert.assertEquals((long)1L, (long)lines.size());
        Assert.assertEquals((Object)"chr1\tsource\tfeature\t9998\t9998\tQuality9998\tStrand9998\tFrame9998\tMetadata9998\t", (Object)lines.iterator().next());
        region = new Region(9999L, 10000L, new Chromosome("chr1"));
        lines = ((Index)index).getFileLines(region).values();
        Assert.assertEquals((long)1L, (long)lines.size());
        Assert.assertEquals((Object)"chr1\tsource\tfeature\t9999\t9999\tQuality9999\tStrand9999\tFrame9999\tMetadata9999\t", (Object)lines.iterator().next());
        region = new Region(10000L, 20000L, new Chromosome("chr1"));
        lines = ((Index)index).getFileLines(region).values();
        Assert.assertTrue((boolean)lines.isEmpty());
        BinarySearchIndexTest.testLineIdentifiers(index, 0L);
        BinarySearchIndexTest.testLineIdentifiers(index, 1000L);
        BinarySearchIndexTest.testLineIdentifiers(index, 9999L);
    }

    private static void testLineIdentifiers(Index index, long startPosition) throws IOException, GBrowserException {
        Region region = new Region(startPosition, startPosition + 100L, new Chromosome("chr1"));
        TreeMap<IndexKey, String> lineMap = index.getFileLines(region);
        IndexKey id1 = lineMap.firstKey();
        region = new Region(startPosition - 100L, startPosition + 1L, new Chromosome("chr1"));
        lineMap = index.getFileLines(region);
        IndexKey id2 = lineMap.lastKey();
        region = new Region(startPosition - 100L, startPosition + 100L, new Chromosome("chr1"));
        lineMap = index.getFileLines(region);
        IndexKey fromKey = new IndexKey(new BpCoord(startPosition, new Chromosome("chr1")), 0L);
        IndexKey toKey = new IndexKey(new BpCoord(startPosition, new Chromosome("chr1")), Long.MAX_VALUE);
        SortedMap<IndexKey, String> subMap = lineMap.subMap(fromKey, toKey);
        IndexKey id3 = subMap.firstKey();
        Assert.assertEquals((Object)id1, (Object)id2);
        Assert.assertEquals((Object)id2, (Object)id3);
    }

    public static File getTestFile(int headerLineCount) throws IOException {
        File testFile = File.createTempFile("RandomAccessBinarySearchTest-file", ".txt");
        BufferedWriter writer = new BufferedWriter(new FileWriter(testFile));
        for (int i = 0; i < headerLineCount; ++i) {
            writer.write("#header line " + i);
            writer.newLine();
        }
        String[] cols = new String[]{"Quality", "Strand", "Frame", "Metadata"};
        int TEST_FILE_ROWS = 10000;
        int startPosition = 0;
        for (int i = 0; i < TEST_FILE_ROWS; ++i) {
            String row = String.format("%04d", i);
            String line = "";
            if (i <= 4000 || i >= 6000) {
                startPosition = i;
            }
            line = line + "chr1\tsource\tfeature\t";
            line = line + startPosition + "\t";
            line = line + startPosition + "\t";
            for (String col : cols) {
                line = line + col + row + "\t";
            }
            writer.write(line);
            writer.newLine();
        }
        writer.flush();
        writer.close();
        return testFile;
    }
}

