/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Transcript;

public class Exon
implements Comparable<Exon> {
    private Region region;
    private Feature feature;
    private int exonNumber;
    private Transcript transcript;
    private String geneId;
    private String transcriptId;
    private String geneName;
    private String transcName;
    private String biotype;

    private Feature getFeature(String id) {
        for (Feature feature : Feature.values()) {
            if (feature.getId() == null || !feature.getId().equals(id)) continue;
            return feature;
        }
        return Feature.UNRECOGNIZED;
    }

    public Exon(Region region, String feature, int exonNumber) {
        this.region = region;
        this.feature = this.getFeature(feature);
        this.exonNumber = exonNumber;
    }

    public Exon(Region region, String feature, int exonNumber, String geneId, String transcId, String geneName, String transcName, String biotype) {
        this(region, feature, exonNumber);
        this.geneId = geneId;
        this.transcriptId = transcId;
        this.geneName = geneName;
        this.transcName = transcName;
        this.biotype = biotype;
    }

    @Override
    public int compareTo(Exon other) {
        int transcriptIdComparison = this.transcriptId.compareTo(other.transcriptId);
        int featureComparison = this.feature.compareTo(other.feature);
        int startComparison = this.region.start.compareTo(other.region.start);
        if (transcriptIdComparison != 0) {
            return transcriptIdComparison;
        }
        if (featureComparison != 0) {
            return featureComparison;
        }
        return startComparison;
    }

    public Object getExonNumber() {
        return this.exonNumber;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public int hashCode() {
        return this.transcriptId.hashCode() << 8 + this.exonNumber << 2 + this.feature.ordinal();
    }

    public boolean equals(Object o) {
        if (o instanceof Exon) {
            return this.compareTo((Exon)o) == 0;
        }
        return false;
    }

    public String toString() {
        return this.region.toString(true) + " \t" + (Object)((Object)this.feature) + " \t" + this.transcriptId + " \t" + this.transcName + " \t" + this.exonNumber;
    }

    public Region getRegion() {
        return this.region;
    }

    public Integer getIndex() {
        return this.exonNumber;
    }

    public void setTranscript(Transcript transc) {
        this.transcript = transc;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public String getTranscriptId() {
        return this.transcriptId;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public String getTranscName() {
        return this.transcName;
    }

    public String getBiotype() {
        return this.biotype;
    }

    public static enum Feature {
        UNRECOGNIZED(null),
        TRANSCRIPT("transcript"),
        EXON("exon"),
        CDS("CDS"),
        START_CODON("start_codon"),
        STOP_CODON("stop_codon");

        private String id;

        private Feature(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

