/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import java.awt.Color;
import java.awt.Graphics2D;

public class LineDrawable
extends Drawable {
    public int x2;
    public int y2;

    public LineDrawable(int x, int y, int x2, int y2, Color color) {
        super(x, y, color);
        this.x2 = x2;
        this.y2 = y2;
    }

    @Override
    public void draw(Graphics2D g, int x, int y) {
        super.draw(g, x, y);
        g.drawLine(this.x + x, this.y + y, this.x2 + x, this.y2 + y);
    }

    @Override
    public void upsideDown() {
        super.upsideDown();
        this.y2 = -this.y2;
    }

    public String toString() {
        return "LineDrawable (" + this.x + ", " + this.y + ") - (" + this.x2 + ", " + this.y2 + ")";
    }

    @Override
    public int getMaxY() {
        return Math.min(this.y, this.y2);
    }
}

