/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.IndexedFastaDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class IndexedFastaConversion
extends DataThread {
    private IndexedFastaDataSource dataSource;

    public IndexedFastaConversion(DataUrl data, DataUrl index, GBrowser browser) {
        super(browser, null);
        try {
            this.dataSource = new IndexedFastaDataSource(data, index);
            super.setDataSource(this.dataSource);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void clean() {
    }

    @Override
    protected void processDataRequest(DataRequest request) throws InterruptedException {
        if (request.start.bp < 1L) {
            request.start.bp = 1L;
        }
        LinkedList<Feature> responseList = new LinkedList<Feature>();
        String sequence = this.dataSource.query(request.start.chr, request.start.bp, request.end.bp);
        LinkedHashMap<DataType, Object> values = new LinkedHashMap<DataType, Object>();
        values.put(DataType.SEQUENCE, sequence);
        Feature regCont = new Feature(request, values);
        responseList.add(regCont);
        this.createDataResult(new DataResult(request.getStatus(), responseList));
    }

    public String toString() {
        return this.getClass().getName() + " - " + this.dataSource;
    }
}

