/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.selection.IntegratedSelectionManager;
import fi.csc.microarray.client.selection.SelectionEvent;
import fi.csc.microarray.client.visualisation.SelectionList;
import fi.csc.microarray.client.visualisation.TableAnnotationProvider;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.methods.Heatmap;
import fi.csc.microarray.client.visualisation.methods.SelectableChartPanel;
import fi.csc.microarray.client.visualisation.methods.hc.OrderSuperviser;
import fi.csc.microarray.cluster.ClusterBranchNode;
import fi.csc.microarray.cluster.ClusterLeafNode;
import fi.csc.microarray.cluster.ClusterNode;
import fi.csc.microarray.cluster.ClusterParser;
import fi.csc.microarray.cluster.TreeParseException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.QueryResult;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.ErrorReportAsException;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.log4j.Logger;
import org.jfree.chart.BioChartFactory;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.HCTreeNodeEntity;
import org.jfree.chart.entity.HeatMapBlockEntity;
import org.jfree.chart.event.ClusteringTreeChangeEvent;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.labels.HCToolTipGenerator;
import org.jfree.chart.labels.StandardHCToolTipGenerator;
import org.jfree.chart.plot.GradientColorPalette;
import org.jfree.chart.plot.HCPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.hc.DataRange;
import org.jfree.data.hc.DataRangeMismatchException;
import org.jfree.data.hc.HCDataset;
import org.jfree.data.hc.HCTreeNode;
import org.jfree.data.hc.HeatMap;

public class HierarchicalClustering
extends Visualisation
implements PropertyChangeListener,
SelectableChartPanel.SelectionChangeListener {
    protected SelectableChartPanel selectableChartPanel;
    private static final Logger logger = Logger.getLogger(HierarchicalClustering.class);
    protected static final String KEY_ZOOM = "zoom";
    protected static final String KEY_SCALE = "scale";
    protected static final String VALUE_TRUE = "true";
    protected static final String VALUE_FALSE = "false";
    OrderSuperviser orders;
    private SelectionList list;
    protected Set<Integer> selected = new HashSet<Integer>();
    protected DataBean selectionBean;
    private HCPlot hcPlot;
    private boolean reversed;
    protected JPanel zoomChangerPanel;
    protected JPanel spaceFiller;
    protected JScrollPane scroller;
    protected Dimension preferredSize;
    private JCheckBox zoomCheckBox;
    private JCheckBox scaleValuesBox;

    @Override
    public void initialise(VisualisationFrame frame) throws Exception {
        super.initialise(frame);
    }

    @Override
    public JPanel getParameterPanel() {
        JPanel paramPanel = new JPanel();
        paramPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
        paramPanel.setLayout(new BorderLayout());
        JPanel settings = this.createSettingsPanel();
        this.list = new SelectionList();
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab("Settings", settings);
        tabPane.addTab("Selected", this.list);
        paramPanel.add((Component)tabPane, "Center");
        return paramPanel;
    }

    public JPanel createSettingsPanel() {
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new GridBagLayout());
        settingsPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
        List<Visualisation.Variable> vars = this.getFrame().getVariables();
        boolean zoom = false;
        boolean scale = true;
        if (vars != null && vars.size() == 2) {
            zoom = vars.get(0).getExpression().equals(VALUE_TRUE);
            scale = vars.get(1).getExpression().equals(VALUE_TRUE);
        }
        this.zoomCheckBox = new JCheckBox("Fit to screen", zoom);
        this.scaleValuesBox = new JCheckBox("Scale gene expression values", scale);
        this.zoomCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HierarchicalClustering.this.setZoomMode(HierarchicalClustering.this.zoomCheckBox.isSelected());
            }
        });
        this.scaleValuesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<Visualisation.Variable> vars = new ArrayList<Visualisation.Variable>();
                vars.add(new Visualisation.Variable(HierarchicalClustering.KEY_ZOOM, HierarchicalClustering.this.zoomCheckBox.isSelected() ? HierarchicalClustering.VALUE_TRUE : HierarchicalClustering.VALUE_FALSE));
                vars.add(new Visualisation.Variable(HierarchicalClustering.KEY_SCALE, HierarchicalClustering.this.scaleValuesBox.isSelected() ? HierarchicalClustering.VALUE_TRUE : HierarchicalClustering.VALUE_FALSE));
                HierarchicalClustering.this.application.setVisualisationMethod(new VisualisationMethodChangedEvent(this, MicroarrayModule.VisualisationMethods.HIERARCHICAL, vars, HierarchicalClustering.this.getFrame().getDatas(), HierarchicalClustering.this.getFrame().getType(), HierarchicalClustering.this.getFrame()));
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.insets.set(10, 10, 0, 10);
        c.anchor = 18;
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        settingsPanel.add((Component)this.zoomCheckBox, c);
        ++c.gridy;
        settingsPanel.add((Component)this.scaleValuesBox, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        settingsPanel.add((Component)new JPanel(), c);
        return settingsPanel;
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws MicroarrayException {
        try {
            List<DataBean> selectionBeans = data.traverseLinks(new DataBean.Link[]{DataBean.Link.DERIVATION}, DataBean.Traversal.DIRECT);
            if (selectionBeans.size() > 1) {
                this.selectionBean = selectionBeans.get(1);
            }
            if (this.selectionBean == null) {
                throw new ErrorReportAsException("Source dataset not found", "Hierarchical clustering needs its source dataset.", " Select both HC and its source dataset by keeping \nCtrl key pressed and right click with mouse over one of them to create \nderivation link from the original dataset to \nclustered one.");
            }
            this.selectableChartPanel = this.getChartPanel(data, this.selectionBean, this.scaleValuesBox.isSelected());
            this.updateSelectionsFromApplication(false);
            this.application.addClientEventListener(this);
            this.zoomChangerPanel = new JPanel(new BorderLayout());
            this.spaceFiller = new JPanel();
            ((FlowLayout)this.spaceFiller.getLayout()).setAlignment(0);
            this.spaceFiller.setBackground(Color.white);
            this.scroller = new JScrollPane(this.spaceFiller);
            this.setZoomMode(this.zoomCheckBox.isSelected());
            return this.zoomChangerPanel;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ErrorReportAsException("Hierarchical clustering cannot be shown.", "The problem is probably caused by unsupported data, such as gene names that have illegal characters in them.", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SelectableChartPanel getChartPanel(DataBean treeDataBean, DataBean heatMapDataBean, boolean scaleValues) throws MicroarrayException, TreeParseException, DataRangeMismatchException {
        int dataCount;
        QueryResult heatMapFeature = treeDataBean.queryFeatures("/clusters/hierarchical/heatmap");
        LinkedList<String> columns = new LinkedList<String>();
        int rowCount = 0;
        try (Table heatMapDataIterator = heatMapFeature.asTable();){
            while (heatMapDataIterator.nextRow()) {
                ++rowCount;
            }
            for (String columnName : heatMapDataIterator.getColumnNames()) {
                if (columnName.startsWith("chip.")) {
                    columns.add(columnName);
                    continue;
                }
                logger.debug((Object)("Column skipped in HC: " + columnName));
            }
        }
        int columnCount = columns.size();
        String hcTree = treeDataBean.queryFeatures("/clusters/hierarchical/tree").asStrings().iterator().next();
        ClusterBranchNode tree = new ClusterParser(hcTree).getTree();
        boolean reversed = hcTree.contains("chip.");
        HeatMap heatMap = null;
        if (!reversed) {
            rowCount = tree.getLeafCount();
            heatMap = new HeatMap("Heatmap", rowCount, columnCount);
            dataCount = rowCount;
        } else {
            heatMap = new HeatMap("Heatmap", columnCount, rowCount);
            dataCount = columnCount;
        }
        int initialHeight = this.getTreeHeight(tree);
        ArrayList<String> treeToId = new ArrayList<String>();
        treeToId.addAll(Collections.nCopies(dataCount, null));
        HCTreeNode root = this.readTree(tree, 0, initialHeight, treeToId);
        OrderSuperviser orders = new OrderSuperviser();
        orders.setTreeToId(treeToId);
        TableAnnotationProvider annotationProvider = new TableAnnotationProvider(heatMapDataBean);
        ArrayList<Integer> treeToBean = new ArrayList<Integer>();
        Table heatMapData = treeDataBean.queryFeatures("/clusters/hierarchical/heatmap").asTable();
        Object object = null;
        try {
            treeToBean.addAll(Collections.nCopies(rowCount, -1));
            int row = -1;
            int originalRow = 0;
            while (heatMapData.nextRow()) {
                int i;
                if (!reversed) {
                    String key = this.translate(heatMapData.getStringValue(" "));
                    if (orders.idToTree(key) == -1) continue;
                    row = orders.idToTree(key);
                    treeToBean.set(row, originalRow);
                    ++originalRow;
                    logger.debug((Object)("Adding a new row to heatmap, name: " + heatMapData.getStringValue(" ") + "\tto row: " + row));
                } else {
                    ++row;
                }
                String geneName = heatMapData.getStringValue(" ");
                geneName = annotationProvider.getAnnotatedRowname(geneName);
                if (!reversed) {
                    heatMap.setRowName(row, geneName);
                } else {
                    heatMap.setColumnName(row, geneName);
                }
                ArrayList<Float> rowValues = new ArrayList<Float>();
                for (i = 0; i < columns.size(); ++i) {
                    rowValues.add(null);
                }
                i = -1;
                for (String string : columns) {
                    if (!reversed) {
                        ++i;
                    } else {
                        i = orders.idToTree(string);
                        logger.debug((Object)("Adding a new row to heatmap (reversed), name: " + string + "\tto row: " + i));
                    }
                    rowValues.set(i, Float.valueOf(heatMapData.getFloatValue(string)));
                }
                if (scaleValues) {
                    void var27_46;
                    DescriptiveStatistics stats = new DescriptiveStatistics();
                    for (Float value : rowValues) {
                        stats.addValue((double)value.floatValue());
                    }
                    boolean bl = false;
                    while (var27_46 < rowValues.size()) {
                        double rowMean = stats.getMean();
                        double rowStdev = stats.getStandardDeviation();
                        float scaledValue = (float)(((double)((Float)rowValues.get((int)var27_46)).floatValue() - rowMean) / rowStdev);
                        rowValues.set((int)var27_46, Float.valueOf(scaledValue));
                        ++var27_46;
                    }
                }
                for (int j = 0; j < rowValues.size(); ++j) {
                    if (!reversed) {
                        heatMap.update(row, j, (double)((Float)rowValues.get(j)).floatValue());
                        continue;
                    }
                    heatMap.update(j, row, (double)((Float)rowValues.get(j)).floatValue());
                }
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (heatMapData != null) {
                if (object != null) {
                    try {
                        heatMapData.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    heatMapData.close();
                }
            }
        }
        orders.setTreeToBean(treeToBean);
        int i = -1;
        for (String columnName : columns) {
            String sampleName = columnName.substring("chip.".length());
            String realName = treeDataBean.queryFeatures("/phenodata/linked/describe/" + sampleName).asString();
            if (!reversed) {
                ++i;
            } else {
                i = orders.idToTree(columnName);
                logger.debug((Object)("Adding a new row to heatmap (reversed), name: " + columnName + "\tto row: " + i));
            }
            if (!reversed) {
                heatMap.setColumnName(i, realName);
                continue;
            }
            heatMap.setRowName(i, realName);
        }
        HCDataset dataset = new HCDataset(heatMap, root, null);
        boolean tooltips = true;
        JFreeChart chart = BioChartFactory.createHCChart((String)"Hierarchical Clustering", (HCDataset)dataset, (boolean)tooltips, (boolean)false);
        HCPlot hcPlot = (HCPlot)chart.getPlot();
        orders.setPlot(hcPlot);
        if (tooltips) {
            hcPlot.setToolTipGenerator((HCToolTipGenerator)new MicroarrayHCToolTipGenerator());
        }
        double min = Heatmap.getMinValue(dataset.getHeatMap());
        double max = Heatmap.getMaxValue(dataset.getHeatMap());
        GradientColorPalette colors = new GradientColorPalette(new double[]{min, max}, new Color[]{Color.BLUE, Color.BLACK, Color.RED});
        hcPlot.setColoring(colors);
        chart.setTitle((TextTitle)null);
        SelectableChartPanel chartPanel = new SelectableChartPanel(chart, this, false);
        chartPanel.getChartPanel().addChartMouseListener((ChartMouseListener)((HCPlot)chart.getPlot()));
        int blockSize = 10;
        int width = (int)((double)(heatMap.getColumnsCount() * blockSize) + hcPlot.getRowTreeSize() + hcPlot.getRowNamesSize() + hcPlot.getLeftMarginSize() + hcPlot.getRightMarginSize());
        int height = (int)((double)(heatMap.getRowCount() * blockSize) + hcPlot.getColumnNamesSize() + hcPlot.getTopMarginSize() + hcPlot.getBottomMarginSize());
        this.preferredSize = new Dimension(width, height);
        this.reversed = reversed;
        this.hcPlot = hcPlot;
        this.orders = orders;
        hcPlot.addChangeListener(new PlotChangeListener(){

            public void plotChanged(PlotChangeEvent event) {
                if (event instanceof ClusteringTreeChangeEvent) {
                    HierarchicalClustering.this.orders.updateVisibleIndexes();
                    HierarchicalClustering.this.updateSelectionsFromApplication(false);
                }
            }
        });
        return chartPanel;
    }

    public void setZoomMode(boolean scaled) {
        if (scaled) {
            this.spaceFiller.removeAll();
            this.zoomChangerPanel.removeAll();
            this.zoomChangerPanel.add((Component)this.selectableChartPanel, "Center");
            this.selectableChartPanel.setPreferredSize(null);
        } else {
            this.zoomChangerPanel.removeAll();
            this.spaceFiller.removeAll();
            this.spaceFiller.add(this.selectableChartPanel);
            this.zoomChangerPanel.add((Component)this.scroller, "Center");
            this.selectableChartPanel.setPreferredSize(this.preferredSize);
        }
        this.zoomChangerPanel.validate();
        this.zoomChangerPanel.repaint();
    }

    private String translate(String gene) {
        while (gene.startsWith(" ") || gene.startsWith("(")) {
            gene = gene.substring(1);
        }
        while (gene.endsWith(" ") || gene.endsWith(")")) {
            gene = gene.substring(0, gene.length() - 1);
        }
        gene = gene.replace("(", "-").replace(")", "-").replace(" ", "_");
        while (gene.contains("--")) {
            gene = gene.replace("--", "-");
        }
        return gene;
    }

    private int getTreeHeight(ClusterNode tree) {
        int right;
        if (tree instanceof ClusterLeafNode) {
            return 0;
        }
        int left = this.getTreeHeight(((ClusterBranchNode)tree).getLeftBranch()) + 1;
        return left > (right = this.getTreeHeight(((ClusterBranchNode)tree).getRightBranch()) + 1) ? left : right;
    }

    private HCTreeNode readTree(ClusterNode tree, int index, int height, List<String> treeToId) throws DataRangeMismatchException {
        if (tree instanceof ClusterLeafNode) {
            String gene = ((ClusterLeafNode)tree).getGene();
            treeToId.set(index, gene);
            logger.debug((Object)("LeafNode: " + ((ClusterLeafNode)tree).getGene() + "in index: " + index));
            return new HCTreeNode(0.0, index);
        }
        HCTreeNode node = new HCTreeNode((double)height);
        HCTreeNode leftChild = this.readTree(((ClusterBranchNode)tree).getLeftBranch(), index, height - 1, treeToId);
        node.setLeftChild(leftChild);
        HCTreeNode rightChild = this.readTree(((ClusterBranchNode)tree).getRightBranch(), node.getDataRange().getRightBound() + 1, height - 1, treeToId);
        node.setRightChild(rightChild);
        return node;
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        DataBean parentBean = MicroarrayModule.getProperSource(bean);
        return bean.isContentTypeCompatitible("application/x-treeview") && parentBean != null && parentBean.hasTypeTag(MicroarrayModule.TypeTags.NORMALISED_EXPRESSION_VALUES);
    }

    @Override
    public void selectionChanged(Rectangle2D.Double selectionRect) {
        if (selectionRect == null) {
            this.selected.clear();
        } else {
            this.orders.updateVisibleIndexes();
            ChartRenderingInfo info = this.selectableChartPanel.getChartPanel().getChartRenderingInfo();
            EntityCollection entities = info.getEntityCollection();
            HashSet<Integer> newSelection = new HashSet<Integer>();
            for (Object obj : entities.getEntities()) {
                HCTreeNodeEntity entity;
                if (obj instanceof HCTreeNodeEntity && (entity = (HCTreeNodeEntity)obj).getArea().intersects(selectionRect)) {
                    return;
                }
                if (!(obj instanceof HeatMapBlockEntity)) continue;
                entity = (HeatMapBlockEntity)obj;
                Rectangle2D rect = entity.getArea().getBounds2D();
                if (rect.getHeight() == 0.0) {
                    rect = new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight() + 1.0);
                }
                if (rect.getWidth() == 0.0) {
                    rect = new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth() + 1.0, rect.getHeight());
                }
                if (!rect.intersects(selectionRect)) continue;
                if (!this.reversed) {
                    newSelection.addAll(this.orders.visibleToBean(entity.getRow()));
                    continue;
                }
                newSelection.add(entity.getColumn());
            }
            for (Integer row : newSelection) {
                if (this.selected.contains(row)) {
                    this.selected.remove(row);
                    continue;
                }
                this.selected.add(row);
            }
            this.showSelection(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof SelectionEvent && evt.getSource() != this && ((SelectionEvent)evt).getData() == this.selectionBean) {
            this.updateSelectionsFromApplication(false);
        }
    }

    protected void updateSelectionsFromApplication(boolean dispatchEvent) {
        IntegratedSelectionManager manager = this.application.getSelectionManager().getSelectionManager(this.selectionBean);
        this.orders.updateVisibleIndexes();
        this.selected.clear();
        for (int i : manager.getSelectionAsRows()) {
            this.selected.add(i);
        }
        this.showSelection(dispatchEvent);
    }

    protected void showSelection(boolean dispatchEvent) {
        HCPlot.Selection[] detailedSelection = !this.reversed ? this.calculateRowSelectionDetails() : this.calculateColumnSelectionDetails();
        this.hcPlot.showSelection(detailedSelection, !this.reversed);
        this.list.setSelectedRows(this.selected, this, dispatchEvent, this.selectionBean);
    }

    private HCPlot.Selection[] calculateRowSelectionDetails() {
        int[] closedRows = this.orders.getCountOfVisibleReferences();
        int[] selectedRows = new int[closedRows.length];
        HCPlot.Selection[] detailedSelection = new HCPlot.Selection[closedRows.length];
        for (int selectedRow : this.selected) {
            int n = this.orders.beanToVisible(selectedRow);
            selectedRows[n] = selectedRows[n] + 1;
        }
        for (int i = 0; i < selectedRows.length; ++i) {
            if (selectedRows[i] == 0) {
                detailedSelection[i] = HCPlot.Selection.NO;
                continue;
            }
            if (selectedRows[i] == closedRows[i]) {
                detailedSelection[i] = HCPlot.Selection.YES;
                continue;
            }
            if (selectedRows[i] >= closedRows[i]) continue;
            detailedSelection[i] = HCPlot.Selection.PARTIAL;
        }
        return detailedSelection;
    }

    private HCPlot.Selection[] calculateColumnSelectionDetails() {
        HCPlot.Selection[] detailedSelection = new HCPlot.Selection[this.hcPlot.getDataset().getHeatMap().getColumnsCount()];
        for (int i = 0; i < detailedSelection.length; ++i) {
            detailedSelection[i] = this.selected.contains(i) ? HCPlot.Selection.YES : HCPlot.Selection.NO;
        }
        return detailedSelection;
    }

    private class MicroarrayHCToolTipGenerator
    extends StandardHCToolTipGenerator {
        private MicroarrayHCToolTipGenerator() {
        }

        public String generateToolTip(HeatMap heatmap, DataRange rowRange, DataRange columnRange) {
            int maxColumn;
            int minColumn;
            int maxRow;
            int minRow;
            try {
                minRow = rowRange.getLeftBound();
                maxRow = rowRange.getRightBound();
                minColumn = columnRange.getLeftBound();
                maxColumn = columnRange.getRightBound();
            }
            catch (Exception e) {
                return "This block contains no data.";
            }
            if (minRow == maxRow && minColumn == maxColumn) {
                return "(" + heatmap.getRowName(minRow) + "," + heatmap.getColumnName(minColumn) + ") = " + heatmap.get(minRow, minColumn);
            }
            double averageValue = 0.0;
            int blockCount = 0;
            for (int rowCounter = minRow; rowCounter <= maxRow; ++rowCounter) {
                int columnCounter = minColumn;
                while (columnCounter <= maxColumn) {
                    averageValue += heatmap.get(rowCounter, columnCounter);
                    ++columnCounter;
                    ++blockCount;
                }
            }
            return "(" + heatmap.getRowName(minRow) + "," + heatmap.getColumnName(minColumn) + ") .. (" + heatmap.getRowName(maxRow) + "," + heatmap.getColumnName(maxColumn) + ") = " + (averageValue /= (double)blockCount) + " (contains " + (blockCount + 1) + " blocks)";
        }
    }
}

