/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.session;

import fi.csc.microarray.client.RemoteServiceAccessor;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.ToolModule;
import fi.csc.microarray.client.session.SessionManager;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.filebroker.DbSession;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.FileServer;
import fi.csc.microarray.filebroker.JMSFileBrokerClient;
import fi.csc.microarray.filebroker.MockJettyFileServer;
import fi.csc.microarray.messaging.DirectMessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.auth.SimpleAuthenticationRequestListener;
import fi.csc.microarray.module.ModuleManager;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import fi.csc.microarray.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class SessionTest {
    private String username = "username";
    private String password = "password";
    private SimpleAuthenticationRequestListener authenticationListener;

    @Test
    public void test() throws Exception {
        File workDir = Files.createTempDirectory("remote-session-unit-test-temp", new FileAttribute[0]).toFile();
        new File(workDir, "conf").mkdir();
        File logDir = new File(workDir, "logs");
        logDir.mkdir();
        new File(workDir, "security").mkdir();
        DirectoryLayout.setBaseDirOverride(workDir);
        File configFile = new File(workDir, "conf" + File.separator + "chipster-config.xml");
        IOUtils.copy((InputStream)new ByteArrayInputStream(this.getMockConfig().getBytes()), configFile);
        DirectMessagingEndpoint endpoint = new DirectMessagingEndpoint();
        new FileServer(null, endpoint, new MockJettyFileServer());
        MessagingTopic urlTopic = endpoint.createTopic(Topics.Name.FILEBROKER_TOPIC, MessagingTopic.AccessMode.WRITE);
        JMSFileBrokerClient fbc = new JMSFileBrokerClient(urlTopic);
        boolean diskSpace = fbc.requestDiskSpace(0L);
        Assert.assertTrue((boolean)diskSpace);
        for (File logFile : logDir.listFiles()) {
            ByteArrayOutputStream contents = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)new FileInputStream(logFile), contents);
            Assert.assertFalse((String)(logFile + " should not contain exception"), (boolean)contents.toString().contains("Exception"));
        }
    }

    private String getMockConfig() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<configuration content-version=\"3\">\n\n\t<configuration-module moduleId=\"messaging\">\n\n\t\t<!-- host of message broker (JMS server ActiveMQ) to connect to -->\n\t\t<entry entryKey=\"broker-host\">\n\t\t\t<value>not defined</value>\n\t\t</entry>\n\n\t\t<!-- protocol used to connect to message broker -->\n\t\t<entry entryKey=\"broker-protocol\">\n\t\t\t<value>not defined</value>\n\t\t</entry>\n\n\t\t<!-- port used to connect to message broker -->\n\t\t<entry entryKey=\"broker-port\">\n\t\t\t<value>-1</value>\n\t\t</entry>\n\t\t\n\t</configuration-module>\n\n\t<configuration-module moduleId=\"security\">\n\n\t\t<!-- username for authenticating connection to broker -->\n\t\t<entry entryKey=\"username\">\n\t\t\t<value>not defined</value>\n\t\t</entry>\n\n\t\t<!-- password for authenticating connection to broker -->\n\t\t<entry entryKey=\"password\">\n\t\t\t<value>not defined</value>\n\t\t</entry>\n\t\n\t</configuration-module>\n\n\t<configuration-module moduleId=\"filebroker\">\n\t\n\t    <!-- url of this file broker instance -->\n\t\t<entry entryKey=\"url\">\n\t\t\t<value>http://mockhost</value>\n\t\t</entry>\n\t\t\n\t\t<!-- server port to use in this file broker instance -->\n\t\t<entry entryKey=\"port\">\n\t\t\t<value>-1</value>\t\t\t\n        </entry>\t\t\n        \n        \n        <entry entryKey=\"metadata-port\">\n\t\t\t<value>-1</value>\n       \t\t</entry>\n        \n        \n        <entry entryKey=\"clean-up-trigger-limit-percentage\" type=\"int\" description=\"when disk usage reaches this percentage clean up\">\n\t\t\t<value>22</value>\n\t\t</entry>\n\n\t\t<entry entryKey=\"clean-up-target-percentage\" type=\"int\" description=\"when cleaning up drop disk usage to this percentage\">\n\t\t\t<value>20</value>\n\t\t</entry>\n\n\n\t\t<entry entryKey=\"clean-up-minimum-file-age\" type=\"int\" description=\"only clean up files older than this, seconds\">\n\t\t\t<value>259200</value>\n\t\t</entry>\n\n\t\t<entry entryKey=\"minimum-space-for-accept-upload\" type=\"int\" description=\"when client requests for free space, say no if less than this many megabytes would be available after upload, megabytes\">\n\t\t\t<value>100</value>\n\t\t</entry>\n        \n\t</configuration-module>\n\n</configuration>\n";
    }

    public void testStorageSessions() throws Exception {
        ModuleManager moduleManager = new ModuleManager("fi.csc.microarray.module.chipster.MicroarrayModule");
        Session.getSession().setModuleManager(moduleManager);
        this.authenticationListener = new SimpleAuthenticationRequestListener(this.username, this.password);
        DataManager manager = new DataManager();
        moduleManager.plugAll(manager, null);
        LinkedList<ToolModule> toolModules = new LinkedList<ToolModule>();
        RemoteServiceAccessor serviceAccessor = new RemoteServiceAccessor();
        serviceAccessor.initialise(manager, this.authenticationListener);
        serviceAccessor.fetchDescriptions(new MicroarrayModule());
        Session.getSession().setServiceAccessor(serviceAccessor);
        toolModules.addAll(serviceAccessor.getModules());
        FileBrokerClient fileBrokerClient = serviceAccessor.getFileBrokerClient();
        SessionManager sessionManager = new SessionManager(manager, null, fileBrokerClient, null);
        DataBean data = manager.createDataBean("test");
        data.setParent(manager.getRootFolder());
        int dbCountOrig = manager.databeans().size();
        String sessionName = "unit test session " + new Random().nextInt(10000);
        sessionManager.saveStorageSession(sessionName);
        manager.deleteAllDataItems();
        List<DbSession> sessions = fileBrokerClient.listRemoteSessions();
        String sessionId = this.findSession(sessionName, sessions);
        sessionManager.loadStorageSession(sessionId);
        Assert.assertEquals((long)manager.databeans().size(), (long)dbCountOrig);
        fileBrokerClient.removeRemoteSession(sessionId);
        List<DbSession> sessions2 = fileBrokerClient.listRemoteSessions();
        Assert.assertNull((Object)this.findSession(sessionName, sessions2));
    }

    private String findSession(String sessionName, List<DbSession> sessions) throws MalformedURLException {
        String sessionId = null;
        for (DbSession session : sessions) {
            if (!sessionName.equals(session.getName())) continue;
            sessionId = session.getDataId();
            break;
        }
        return sessionId;
    }
}

