/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.session;

import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.operation.ColoredCircleIcon;
import fi.csc.microarray.client.session.RemoteSessionChooserFactory;
import fi.csc.microarray.client.session.SessionManager;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.filebroker.DbSession;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.messaging.AuthCancelledException;
import fi.csc.microarray.messaging.admin.StorageAdminAPI;
import fi.csc.microarray.messaging.admin.StorageEntry;
import fi.csc.microarray.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import net.miginfocom.swing.MigLayout;

public class RemoteSessionAccessory
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final Color LOW_DISK_USAGE_COLOR = VisualConstants.COLOR_BLUE_GREEN;
    private static final Color HIGH_DISK_USAGE_COLOR = VisualConstants.COLOR_ORANGE;
    private String disclaimer = "Storage here is for working copies and may not be backed up. Store another copy of all your valuable data elsewhere.";
    private String cloudInfo = "<html><div style=\"width:300px\"<p>Cloud sessions store the data files on server side instead of your local computer.This way you need less storage space on your computer and data transfers are minimized.</p><p><br/>Important things to consider when using cloud sessions:</p><ul><li><strong>no backups</strong></li><li>use for <strong>temporary storage</strong> while working with your data</li><li>beta, may be disabled in the future</li></ul><p>Please <strong>store a copy of your valuable data also elsewhere!</strong><br/></p></div></html>";
    private JPanel panel = new JPanel();
    private JLabel manageTitle = new JLabel("Session info");
    private JLabel diskUsageTitle = new JLabel("Total disk usage");
    private JLabel disclaimerTitle = new JLabel("No backups");
    private JLabel previewLabel = new JLabel(" ");
    private JLabel cloudTitle = new JLabel("Cloud sessions (BETA)");
    private JLabel temporaryTitle = new JLabel("Temporary only");
    private JButton removeButton = new JButton("Delete");
    private JProgressBar quotaBar = new JProgressBar();
    private JTextArea disclaimerText = new JTextArea(this.disclaimer);
    private JLabel lowDiskUsageIcon = new JLabel(new ColoredCircleIcon(LOW_DISK_USAGE_COLOR));
    private JLabel highDiskUsageIcon = new JLabel(new ColoredCircleIcon(HIGH_DISK_USAGE_COLOR));
    private JTextArea lowDiskUsageText = new JTextArea();
    private JTextArea highDiskUsageText = new JTextArea();
    private JFileChooser fileChooser;
    private SessionManager sessionManager;
    private SwingClientApplication app;
    private ExecutorService previewExecutor = Executors.newFixedThreadPool(1);

    public RemoteSessionAccessory(JFileChooser fileChooser, SessionManager sessionManager, SwingClientApplication app) throws AuthCancelledException {
        this.fileChooser = fileChooser;
        this.sessionManager = sessionManager;
        this.app = app;
        fileChooser.addPropertyChangeListener(this);
        this.panel.setLayout((LayoutManager)new MigLayout("", "[fill]", ""));
        this.panel.setBackground(Color.white);
        this.panel.setBorder(new LineBorder(VisualConstants.TOOL_LIST_BORDER_COLOR));
        this.removeButton.addActionListener(this);
        this.disclaimerText.setLineWrap(true);
        this.lowDiskUsageText.setLineWrap(true);
        this.highDiskUsageText.setLineWrap(true);
        this.disclaimerText.setWrapStyleWord(true);
        this.lowDiskUsageText.setWrapStyleWord(true);
        this.highDiskUsageText.setWrapStyleWord(true);
        this.disclaimerText.setEditable(false);
        this.lowDiskUsageText.setEditable(false);
        this.highDiskUsageText.setEditable(false);
        this.disclaimerText.setOpaque(false);
        this.lowDiskUsageText.setOpaque(false);
        this.highDiskUsageText.setOpaque(false);
        this.quotaBar.setStringPainted(true);
        this.quotaBar.setBackground(Color.white);
        this.quotaBar.setBorderPainted(false);
        this.quotaBar.setBorder(null);
        JPanel quotaPanel = new JPanel((LayoutManager)new MigLayout("fill, gap 0!, insets 0"));
        quotaPanel.setBorder(new LineBorder(Color.GRAY));
        quotaPanel.add((Component)this.quotaBar, "growx, width 300px");
        this.manageTitle.setFont(UIManager.getFont("TitledBorder.font"));
        this.diskUsageTitle.setFont(UIManager.getFont("TitledBorder.font"));
        this.disclaimerTitle.setFont(UIManager.getFont("TitledBorder.font"));
        this.cloudTitle.setFont(UIManager.getFont("TitledBorder.font"));
        this.temporaryTitle.setFont(UIManager.getFont("TitledBorder.font"));
        this.manageTitle.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.diskUsageTitle.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.disclaimerTitle.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.cloudTitle.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.temporaryTitle.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.panel.add((Component)this.cloudTitle, "span, wrap");
        this.panel.add((Component)new JLabel(this.cloudInfo), "skip, wrap");
        this.panel.add((Component)this.manageTitle, "span, wrap, gap top 15");
        this.panel.add((Component)this.previewLabel, "skip, wrap");
        this.panel.add((Component)this.removeButton, "sizegroup actions, skip, growx 0, wrap");
        this.panel.add((Component)this.diskUsageTitle, "span, wrap, gap top 15");
        this.panel.add((Component)quotaPanel, "skip, wrap");
        this.setLayout((LayoutManager)new MigLayout("fill, insets 0 0 1 1"));
        this.add((Component)this.panel, "grow");
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.removeButton) {
            this.removeSelectedSession();
        }
    }

    private void removeSelectedSession() {
        String sessionUuid = null;
        try {
            sessionUuid = this.getSelectedSession().getDataId();
            if (sessionUuid == null) {
                throw new RuntimeException("session not found");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("internal error: URL or name from save dialog was invalid");
        }
        try {
            if (this.sessionManager.removeRemoteSession(sessionUuid)) {
                this.update();
            }
        }
        catch (FileBrokerException | AuthCancelledException e) {
            this.app.reportException(e);
        }
    }

    private DbSession getSelectedSession() throws MalformedURLException {
        File selectedFile = this.fileChooser.getSelectedFile();
        if (selectedFile == null || !selectedFile.getPath().startsWith("Cloud sessions")) {
            return null;
        }
        String filename = selectedFile.getPath().substring("Cloud sessions".length() + 1);
        List sessions = (List)this.fileChooser.getClientProperty("sessions");
        return this.sessionManager.findSessionWithName(sessions, filename);
    }

    private void update() throws AuthCancelledException {
        try {
            RemoteSessionChooserFactory.updateRemoteSessions(this.sessionManager, this.fileChooser, true);
            StorageAdminAPI.StorageEntryMessageListener reply = this.sessionManager.getStorageUsage();
            long quota = reply.getQuota();
            long quotaWarning = reply.getQuotaWarning();
            long diskUsage = reply.getStorageUsage();
            this.quotaBar.setMaximum((int)(quota / 1024L / 1024L));
            this.quotaBar.setValue((int)(diskUsage / 1024L / 1024L));
            String humanReadableDiskUsage = Strings.toHumanReadable(diskUsage, true, true);
            String humanReadableQuota = Strings.toHumanReadable(quota, true, true);
            this.quotaBar.setString("Total disk usage: " + humanReadableDiskUsage + "B / " + humanReadableQuota + "B");
            this.quotaBar.setForeground(LOW_DISK_USAGE_COLOR);
            String quotaWarningString = Strings.toHumanReadable(quotaWarning, true, true).trim() + "B";
            String quotaString = Strings.toHumanReadable(quota, true, true).trim() + "B";
            String lowDiskUsage = "Store up to " + quotaWarningString + " as long as you want.";
            String highDiskUsage = "Store up to " + quotaString + ", but please remove your data when you aren't anymore actively working on it.";
            this.lowDiskUsageText.setText(lowDiskUsage);
            this.highDiskUsageText.setText(highDiskUsage);
            this.selectedSessionChanged();
        }
        catch (FileBrokerException | InterruptedException | MalformedURLException e) {
            this.app.reportException(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("SelectedFileChangedProperty".equals(evt.getPropertyName())) {
            this.selectedSessionChanged();
        }
    }

    private void selectedSessionChanged() {
        try {
            DbSession session = this.getSelectedSession();
            String uuid = null;
            String name = null;
            if (session != null) {
                uuid = session.getDataId();
                name = session.getName();
            }
            boolean isExampleSession = name != null && name.startsWith("Example sessions");
            this.removeButton.setEnabled(name != null && !isExampleSession);
            this.updateSessionPreview(uuid);
        }
        catch (MalformedURLException e) {
            this.app.reportException(e);
        }
    }

    private void updateSessionPreview(final String uuid) {
        this.previewExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    this.updateGui(" ");
                    if (uuid != null) {
                        String preview = " ";
                        StorageAdminAPI.StorageEntryMessageListener reply = RemoteSessionAccessory.this.sessionManager.getStorageUsage();
                        for (StorageEntry session : reply.getEntries()) {
                            if (!uuid.equals(session.getID())) continue;
                            preview = preview + Strings.toHumanReadable(session.getSize(), true, true) + "B, ";
                            preview = preview + session.getDate();
                        }
                        this.updateGui(preview);
                    }
                }
                catch (Exception e) {
                    RemoteSessionAccessory.this.app.reportException(e);
                }
            }

            private void updateGui(final String preview) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RemoteSessionAccessory.this.previewLabel.setText(preview);
                    }
                });
            }
        });
    }
}

