/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.serverfiles;

import java.awt.Component;
import java.awt.Container;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;

public class ServerFileUtils {
    public static void hideJFileChooserButtons(JFileChooser sessionFileChooser) {
        ServerFileUtils.hideChildButtonsWithTooltip(sessionFileChooser, "Sessions at server");
        ServerFileUtils.hideChildButtonsWithTooltip(sessionFileChooser, "Up One Level");
        ServerFileUtils.hideChildButtonsWithTooltip(sessionFileChooser, "Remote sessions");
        ServerFileUtils.hideChildButtonsWithTooltip(sessionFileChooser, "Create New Folder");
        ServerFileUtils.hideChildButtonsWithTooltip(sessionFileChooser, "List");
        ServerFileUtils.hideChildButtonsWithTooltip(sessionFileChooser, "Details");
    }

    private static void hideChildButtonsWithTooltip(Container parent, String tooltip) {
        for (Component component : parent.getComponents()) {
            if (component instanceof AbstractButton && tooltip.equals(((AbstractButton)component).getToolTipText())) {
                component.setVisible(false);
                continue;
            }
            if (!(component instanceof Container)) continue;
            ServerFileUtils.hideChildButtonsWithTooltip((Container)component, tooltip);
        }
    }

    private static JButton lookupButton(Container c, String text) {
        JButton button = null;
        for (Component comp : c.getComponents()) {
            if (comp == null) continue;
            if (comp instanceof JButton && (button = (JButton)comp).getText() != null && button.getText().equals(text)) {
                return button;
            }
            if (!(comp instanceof Container) || (button = ServerFileUtils.lookupButton((Container)comp, text)) == null) continue;
            return button;
        }
        return button;
    }

    public static void addButton(JFileChooser fileChooser) {
        fileChooser.setApproveButtonText("approveButton");
        JButton button = ServerFileUtils.lookupButton(fileChooser, "approveButton");
        fileChooser.setApproveButtonText(null);
        button.getParent().add((Component)new JButton("Save"), 0);
    }

    public static void hideApproveButton(JFileChooser fileChooser) {
        fileChooser.setApproveButtonText("approveButton");
        JButton button = ServerFileUtils.lookupButton(fileChooser, "approveButton");
        fileChooser.setApproveButtonText(null);
        button.setVisible(false);
    }

    public static void setCancelButtonText(JFileChooser fileChooser, String text) {
        JButton button = ServerFileUtils.lookupButton(fileChooser, "Cancel");
        if (button != null) {
            button.setText(text);
        }
    }
}

