/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.client.dataimport.trimmer.DataTrimmer;
import fi.csc.microarray.client.dataimport.trimmer.NormalStringReplace;
import fi.csc.microarray.client.dataimport.trimmer.ReqularExpressionStringReplace;
import org.junit.Assert;
import org.junit.Test;

public class DataTrimmerTest {
    @Test
    public void testNormal() {
        DataTrimmer trimmer = new DataTrimmer();
        trimmer.pushOperation(new NormalStringReplace("a", "A", false, 1));
        trimmer.pushOperation(new NormalStringReplace("(", "[", false, 1));
        trimmer.pushOperation(new NormalStringReplace(")", "}", false, 2));
        trimmer.pushOperation(new NormalStringReplace("A", "s", false, 1));
        trimmer.popOperation();
        trimmer.pushOperation(new NormalStringReplace("A", "f", false, 1));
        String column1 = "(aAaA)";
        String column2 = "(aAaA)";
        String trimmedColumn1 = trimmer.doTrimming(column1, 1);
        String trimmedColumn2 = trimmer.doTrimming(column2, 2);
        System.out.println("Normal string replacement (" + trimmer.getOperationCount() + " operations)");
        System.out.println("Column1: " + trimmedColumn1);
        System.out.println("Column2: " + trimmedColumn2);
        Assert.assertTrue((boolean)trimmedColumn1.equals("[ffff)"));
        Assert.assertTrue((boolean)trimmedColumn2.equals("(aAaA}"));
    }

    @Test
    public void testRegexp() {
        DataTrimmer trimmer = new DataTrimmer();
        trimmer.pushOperation(new ReqularExpressionStringReplace("go*", "aa", 1));
        trimmer.pushOperation(new ReqularExpressionStringReplace("go+g", "a", 2));
        String column1 = "gogogooogo";
        String column2 = "goooooggogoo";
        String trimmedColumn1 = trimmer.doTrimming(column1, 1);
        String trimmedColumn2 = trimmer.doTrimming(column2, 2);
        System.out.println("Regular expression replacement");
        System.out.println("Column1: " + trimmedColumn1);
        System.out.println("Column2: " + trimmedColumn2);
        Assert.assertTrue((boolean)trimmedColumn1.equals("aaaaaaaa"));
        Assert.assertTrue((boolean)trimmedColumn2.equals("aaoo"));
    }
}

