/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.ngs;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.TsvLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.TsvSorter;
import fi.csc.microarray.comp.java.JavaCompJobBase;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.util.Exceptions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;

public class SortTsv
extends JavaCompJobBase {
    public static final String COLUMN_ID = "column";
    public static final String FIRST_ID = "first";
    public static final String SECOND_ID = "second";

    @Override
    public String getSADL() {
        return "TOOL fi.csc.chipster.tools.ngs.SortTsv.java: \"Sort TSV\" (Sort a TSV file by chromosome and start position.)\nINPUT input.tsv: \"TSV file\" TYPE GENERIC\nOUTPUT sorted.tsv: \"Sorted TSV file\"\nPARAMETER column: \"Chromosome column\" TYPE [first: First, second: Second] DEFAULT first (Select the column that contains chromosome information.)\n";
    }

    @Override
    protected void execute() {
        this.updateStateToClient(JobState.RUNNING, "sorting");
        try {
            File inputFile = new File(this.jobDataDir, this.toolDescription.getInputFiles().get(0).getFileName());
            File outputFile = new File(this.jobDataDir, this.toolDescription.getOutputFiles().get(0).getFileName().getID());
            List<String> parameters = this.inputMessage.getParameters(JAVA_PARAMETER_SECURITY_POLICY, this.toolDescription);
            String columnString = parameters.get(0);
            int chrColumn = 0;
            if (SECOND_ID.equals(columnString)) {
                chrColumn = 1;
            }
            SortTsv.sort(inputFile, outputFile, chrColumn);
        }
        catch (Exception e) {
            this.getResultMessage().setErrorMessage(Exceptions.getStackTrace(e));
            this.updateState(JobState.FAILED, "");
            return;
        }
        this.updateStateToClient(JobState.RUNNING, "sorting finished");
    }

    private static void sort(File inputFile, File outputFile, int chrColumn) throws MalformedURLException, IOException, URISyntaxException, Exception {
        new TsvSorter().sort(inputFile, outputFile, chrColumn, chrColumn + 1, new TsvLineParser(new DataUrl(inputFile), chrColumn));
    }

    public static void main(String[] args) throws Exception {
        try {
            File in = new File(args[0]);
            File out = new File(args[1]);
            int chrColumn = Integer.parseInt(args[2]) - 1;
            SortTsv.sort(in, out, chrColumn);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("usage: SortGtf input-file output-file chr-column\n  chr-column:\tnumber of column containin chromosomes, starting from 1\n  \nexample:\n   java -cp chipster-3.0.0.jar fi.csc.chipster.tools.ngs.SortTsv de-genes-cufflinks.tsv de-genes-cufflinks-sort.tsv 2");
        }
    }
}

