/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.dev.toolchecker;

import fi.csc.chipster.toolbox.SADLTool;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ToolChecker {
    private Set<String> parseR(String rPath) {
        FileInputStream fileStream;
        File file = new File(rPath);
        HashSet<String> parametersList = new HashSet<String>();
        try {
            fileStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return parametersList;
        }
        try {
            SADLTool.ParsedScript script = new SADLTool("#").parseScript(fileStream);
            SADLParser parser = new SADLParser();
            SADLDescription description = parser.parse(script.SADL);
            List<SADLDescription.Parameter> parameters = description.getParameters();
            for (SADLDescription.Parameter p : parameters) {
                parametersList.add(p.getName().getDisplayName());
            }
        }
        catch (SADLParser.ParseException | IOException e) {
            System.err.println(e);
        }
        return parametersList;
    }

    private Set<String> parseHTML(String documentationPath) {
        File documentation = new File(documentationPath);
        try {
            Document doc = Jsoup.parse((File)documentation, (String)"UTF-8");
            Elements parameters = doc.select("h3:contains(Parameters) + ul > li");
            HashSet<String> parametersList = new HashSet<String>();
            for (Element p : parameters) {
                String[] tokens = p.text().split("\\(|\\[|\\.|\\:");
                parametersList.add(tokens[0].trim());
            }
            return parametersList;
        }
        catch (IOException e) {
            System.err.println("File not found: " + documentationPath);
            e.printStackTrace();
            return null;
        }
    }

    private void writeParameters(Set<String> newParameters, String documentationPath) {
        File documentation = new File(documentationPath);
        try {
            Document doc = Jsoup.parse((File)documentation, (String)"UTF-8");
            Elements parameters = doc.select("h3:contains(Parameters) + ul");
            parameters.html("");
            for (String p : newParameters) {
                parameters.prepend("<li>" + p + "</li>");
            }
            FileWriter newFile = new FileWriter(documentation, false);
            newFile.write(doc.outerHtml());
            newFile.close();
            System.out.println(doc.outerHtml());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String manualError(Path rScriptPath, String manualDir) {
        String fileName = rScriptPath.getFileName().toString();
        fileName = fileName.substring(0, fileName.lastIndexOf(46));
        String filePath = manualDir + '/' + fileName + ".html";
        if (new File(filePath).isFile()) {
            return this.parametersErrors(rScriptPath, manualDir);
        }
        return "MANUAL NOT FOUND: " + fileName;
    }

    private String parametersErrors(Path filePath, String manualDir) {
        String fileName = filePath.getFileName().toString();
        fileName = fileName.substring(0, fileName.lastIndexOf(46));
        Set<String> manualParameters = this.parseHTML(manualDir + '/' + fileName + ".html");
        Set<String> rParameters = this.parseR(filePath.toString());
        HashSet<String> filteredRParameters = new HashSet<String>();
        for (String p : rParameters) {
            filteredRParameters.add(p.replaceAll("\\s+", " ").trim().replaceAll("\\.", ""));
        }
        if (manualParameters.isEmpty()) {
            if (rParameters.isEmpty()) {
                return null;
            }
            return "No parameters in manual\n";
        }
        if (manualParameters.containsAll(filteredRParameters)) {
            return null;
        }
        HashSet rCopy = new HashSet(filteredRParameters);
        System.err.println(((Object)filteredRParameters).toString());
        System.err.println(manualParameters.toString());
        filteredRParameters.removeAll(manualParameters);
        manualParameters.removeAll(rCopy);
        return "Script's parameters mismatches: " + ((Object)filteredRParameters).toString() + "\nManual's parameters mismatches: " + manualParameters.toString() + "\n";
    }

    private void scanDir(String rDirPath) {
        int ok = 0;
        int error = 0;
        File dir = new File(rDirPath);
        File[] directoryListing = dir.listFiles();
        String errorMessage = null;
        if (directoryListing != null) {
            for (File child : directoryListing) {
                if (!child.isFile()) continue;
                errorMessage = this.manualError(child.toPath(), "/home/aoikari/git/chipster-tools/manual");
                if (errorMessage == null) {
                    System.out.println("Manual is OK: " + child.toString());
                    ++ok;
                    continue;
                }
                System.out.println("MANUAL IS NOT OK: " + child.toString() + "\n" + errorMessage);
                ++error;
            }
        } else {
            System.err.println("No directory: " + rDirPath);
        }
        System.out.println("Manuals OK: " + ok + " Manuals not OK: " + error);
    }

    public static void main(String[] args) {
        new ToolChecker().scanDir("/home/aoikari/git/chipster-tools/tools/ngs/R");
    }
}

