/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster;

import fi.csc.chipster.toolbox.SADLTool;
import fi.csc.microarray.auth.Authenticator;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.comp.CompServer;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.filebroker.FileServer;
import fi.csc.microarray.jobmanager.JobManager;
import fi.csc.microarray.manager.Manager;
import fi.csc.microarray.messaging.JMSMessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.admin.AdminAPI;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import fi.csc.microarray.util.CommandLineParser;
import fi.csc.microarray.webstart.WebstartJettyServer;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.SwingUtilities;

public class ChipsterMain {
    public static void main(String[] args) {
        block22: {
            try {
                CommandLineParser cmdParser = new CommandLineParser();
                cmdParser.addParameter("client", false, false, null, "start client (default)");
                cmdParser.addParameter("authenticator", false, false, null, "start authenticator");
                cmdParser.addParameter("fileserver", false, false, null, "start fileserver");
                cmdParser.addParameter("comp", false, false, null, "start comp");
                cmdParser.addParameter("webstart", false, false, null, "start webstart service");
                cmdParser.addParameter("manager", false, false, null, "start manager service");
                cmdParser.addParameter("jobmanager", false, false, null, "start jobmanager service");
                cmdParser.addParameter("ping", false, false, null, "query and print system status");
                cmdParser.addParameter("ping-nagios", false, false, null, "query and print system status in nagios compatible format");
                cmdParser.addParameter("rcheck", false, true, null, "check R script syntax");
                cmdParser.addParameter("-config", false, true, null, "configuration file URL (chipster-config.xml)");
                cmdParser.addParameter("-module", false, true, null, "client module (e.g. fi.csc.microarray.module.chipster.MicroarrayModule)");
                cmdParser.parse(args);
                String configURL = cmdParser.getValue("-config");
                if (cmdParser.userAskedHelp()) {
                    System.out.println("Chipster " + ApplicationConstants.VERSION);
                    System.out.println("Parameters:");
                    System.out.println(cmdParser.getDescription());
                    System.exit(0);
                }
                if (cmdParser.hasValue("authenticator")) {
                    new Authenticator(configURL);
                    break block22;
                }
                if (cmdParser.hasValue("comp")) {
                    new CompServer(configURL);
                    break block22;
                }
                if (cmdParser.hasValue("fileserver")) {
                    new FileServer(configURL, null);
                    break block22;
                }
                if (cmdParser.hasValue("webstart")) {
                    new WebstartJettyServer().start();
                    break block22;
                }
                if (cmdParser.hasValue("manager")) {
                    new Manager(configURL);
                    break block22;
                }
                if (cmdParser.hasValue("jobmanager")) {
                    new JobManager(configURL);
                    break block22;
                }
                if (cmdParser.hasValue("ping") || cmdParser.hasValue("ping-nagios")) {
                    boolean ok;
                    String error = "";
                    String status = "";
                    try {
                        NodeBase nodeSupport = new NodeBase(){

                            @Override
                            public String getName() {
                                return "ping";
                            }
                        };
                        DirectoryLayout.initialiseSimpleLayout(configURL).getConfiguration();
                        JMSMessagingEndpoint endpoint = new JMSMessagingEndpoint(nodeSupport);
                        AdminAPI api = new AdminAPI(endpoint.createTopic(Topics.Name.ADMIN_TOPIC, MessagingTopic.AccessMode.READ_WRITE), null);
                        boolean fastCheck = cmdParser.hasValue("ping-nagios");
                        ok = api.areAllServicesUp(fastCheck);
                        error = api.getErrorStatus();
                        status = api.generateStatusReport();
                        endpoint.close();
                    }
                    catch (Exception e) {
                        ok = false;
                        error = e.getMessage();
                    }
                    if (cmdParser.hasValue("ping-nagios")) {
                        if (ok) {
                            System.out.println("CHIPSTER OK");
                            System.exit(0);
                        } else {
                            System.out.println("CHIPSTER FAILED: " + error);
                            System.exit(2);
                        }
                    } else {
                        if (ok) {
                            System.out.println("Chipster OK.");
                        } else {
                            System.out.println("Chipster failed: " + error);
                        }
                        System.out.println(status);
                    }
                    break block22;
                }
                if (cmdParser.hasValue("rcheck")) {
                    boolean fails = false;
                    try {
                        SADLTool.ParsedScript res = new SADLTool("#").parseScript(new FileInputStream(cmdParser.getValue("rcheck")));
                        new ChipsterSADLParser.Validator().validate(cmdParser.getValue("rcheck"), res.SADL);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        fails = true;
                    }
                    System.out.println("parse succeeded: " + !fails);
                    break block22;
                }
                final String module = cmdParser.getValue("-module");
                final String config = configURL;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SwingClientApplication.start(config, module);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            System.exit(0);
                        }
                    }
                });
            }
            catch (CommandLineParser.CommandLineException e) {
                System.out.println("Illegal parameters");
                System.out.println("  " + e.getMessage());
                System.exit(1);
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(1);
            }
        }
    }
}

