@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  chipster-web-server startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

@rem Add default JVM options here. You can also use JAVA_OPTS and CHIPSTER_WEB_SERVER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windowz variants

if not "%OS%" == "Windows_NT" goto win9xME_args
if "%@eval[2+2]" == "4" goto 4NT_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*
goto execute

:4NT_args
@rem Get arguments from the 4NT Shell from JP Software
set CMD_LINE_ARGS=%$

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\chipster-web-server.jar;%APP_HOME%\lib\log4j-api-2.7.jar;%APP_HOME%\lib\log4j-core-2.7.jar;%APP_HOME%\lib\log4j-jul-2.7.jar;%APP_HOME%\lib\log4j-slf4j-impl-2.7.jar;%APP_HOME%\lib\log4j-1.2-api-2.4.1.jar;%APP_HOME%\lib\jersey-container-grizzly2-http-2.25.jar;%APP_HOME%\lib\jersey-media-json-jackson-2.25.jar;%APP_HOME%\lib\jersey-container-jetty-http-2.25.jar;%APP_HOME%\lib\hibernate-java8-5.0.0.CR4.jar;%APP_HOME%\lib\hibernate-c3p0-5.0.0.CR4.jar;%APP_HOME%\lib\h2-1.3.176.jar;%APP_HOME%\lib\javax.websocket-api-1.1.jar;%APP_HOME%\lib\javax-websocket-server-impl-9.2.20.v20161216.jar;%APP_HOME%\lib\tyrus-client-1.13.jar;%APP_HOME%\lib\tyrus-container-grizzly-client-1.13.jar;%APP_HOME%\lib\activemq-client-5.10.0.jar;%APP_HOME%\lib\commons-compress-1.13.jar;%APP_HOME%\lib\jetty-jmx-9.2.20.v20161216.jar;%APP_HOME%\lib\jetty-proxy-9.2.20.v20161216.jar;%APP_HOME%\lib\commons-io-2.4.jar;%APP_HOME%\lib\spring-2.5.6.jar;%APP_HOME%\lib\argparse4j-0.7.0.jar;%APP_HOME%\lib\commons-lang3-3.4.jar;%APP_HOME%\lib\yamlbeans-1.06.jar;%APP_HOME%\lib\chipster-3.11.2.jar;%APP_HOME%\lib\slf4j-api-1.7.21.jar;%APP_HOME%\lib\javax.inject-2.5.0-b30.jar;%APP_HOME%\lib\grizzly-http-server-2.3.28.jar;%APP_HOME%\lib\jersey-common-2.25.jar;%APP_HOME%\lib\jersey-server-2.25.jar;%APP_HOME%\lib\javax.ws.rs-api-2.0.1.jar;%APP_HOME%\lib\jersey-entity-filtering-2.25.jar;%APP_HOME%\lib\jackson-jaxrs-base-2.8.4.jar;%APP_HOME%\lib\jackson-jaxrs-json-provider-2.8.4.jar;%APP_HOME%\lib\jackson-annotations-2.8.4.jar;%APP_HOME%\lib\jetty-continuation-9.2.14.v20151106.jar;%APP_HOME%\lib\jboss-logging-3.3.0.Final.jar;%APP_HOME%\lib\hibernate-core-5.0.0.CR4.jar;%APP_HOME%\lib\c3p0-0.9.2.1.jar;%APP_HOME%\lib\jetty-annotations-9.2.20.v20161216.jar;%APP_HOME%\lib\javax-websocket-client-impl-9.2.20.v20161216.jar;%APP_HOME%\lib\websocket-server-9.2.20.v20161216.jar;%APP_HOME%\lib\tyrus-core-1.13.jar;%APP_HOME%\lib\geronimo-jms_1.1_spec-1.1.1.jar;%APP_HOME%\lib\hawtbuf-1.10.jar;%APP_HOME%\lib\geronimo-j2ee-management_1.1_spec-1.0.1.jar;%APP_HOME%\lib\jetty-client-9.2.20.v20161216.jar;%APP_HOME%\lib\commons-logging-1.1.1.jar;%APP_HOME%\lib\javax.annotation-api-1.2.jar;%APP_HOME%\lib\jersey-guava-2.25.jar;%APP_HOME%\lib\hk2-api-2.5.0-b30.jar;%APP_HOME%\lib\hk2-locator-2.5.0-b30.jar;%APP_HOME%\lib\osgi-resource-locator-1.0.1.jar;%APP_HOME%\lib\jersey-client-2.25.jar;%APP_HOME%\lib\jersey-media-jaxb-2.25.jar;%APP_HOME%\lib\validation-api-1.1.0.Final.jar;%APP_HOME%\lib\jackson-core-2.8.4.jar;%APP_HOME%\lib\jackson-databind-2.8.4.jar;%APP_HOME%\lib\jackson-module-jaxb-annotations-2.8.4.jar;%APP_HOME%\lib\javax.servlet-api-3.1.0.jar;%APP_HOME%\lib\geronimo-jta_1.1_spec-1.1.1.jar;%APP_HOME%\lib\hibernate-jpa-2.1-api-1.0.0.Final.jar;%APP_HOME%\lib\antlr-2.7.7.jar;%APP_HOME%\lib\jandex-1.2.2.Final.jar;%APP_HOME%\lib\dom4j-1.6.1.jar;%APP_HOME%\lib\hibernate-commons-annotations-5.0.0.Final.jar;%APP_HOME%\lib\mchange-commons-java-0.2.3.4.jar;%APP_HOME%\lib\jetty-plus-9.2.20.v20161216.jar;%APP_HOME%\lib\jetty-webapp-9.2.20.v20161216.jar;%APP_HOME%\lib\asm-5.0.1.jar;%APP_HOME%\lib\asm-commons-5.0.1.jar;%APP_HOME%\lib\websocket-client-9.2.20.v20161216.jar;%APP_HOME%\lib\websocket-common-9.2.20.v20161216.jar;%APP_HOME%\lib\websocket-servlet-9.2.20.v20161216.jar;%APP_HOME%\lib\jetty-servlet-9.2.20.v20161216.jar;%APP_HOME%\lib\tyrus-spi-1.13.jar;%APP_HOME%\lib\hk2-utils-2.5.0-b30.jar;%APP_HOME%\lib\aopalliance-repackaged-2.5.0-b30.jar;%APP_HOME%\lib\xml-apis-1.0.b2.jar;%APP_HOME%\lib\jetty-jndi-9.2.20.v20161216.jar;%APP_HOME%\lib\jetty-xml-9.2.20.v20161216.jar;%APP_HOME%\lib\asm-tree-5.0.1.jar;%APP_HOME%\lib\websocket-api-9.2.20.v20161216.jar;%APP_HOME%\lib\jetty-security-9.2.20.v20161216.jar;%APP_HOME%\lib\javax.inject-1.jar;%APP_HOME%\lib\grizzly-http-2.3.28.jar;%APP_HOME%\lib\jetty-util-9.2.20.v20161216.jar;%APP_HOME%\lib\jetty-http-9.2.20.v20161216.jar;%APP_HOME%\lib\jetty-io-9.2.20.v20161216.jar;%APP_HOME%\lib\javassist-3.20.0-GA.jar;%APP_HOME%\lib\jetty-server-9.2.20.v20161216.jar;%APP_HOME%\lib\grizzly-framework-2.3.28.jar

@rem Execute chipster-web-server
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %CHIPSTER_WEB_SERVER_OPTS%  -classpath "%CLASSPATH%" fi.csc.chipster.rest.ServerLauncher %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable CHIPSTER_WEB_SERVER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%CHIPSTER_WEB_SERVER_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
