/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans.tokenizer;

import com.esotericsoftware.yamlbeans.tokenizer.AliasToken;
import com.esotericsoftware.yamlbeans.tokenizer.AnchorToken;
import com.esotericsoftware.yamlbeans.tokenizer.DirectiveToken;
import com.esotericsoftware.yamlbeans.tokenizer.ScalarToken;
import com.esotericsoftware.yamlbeans.tokenizer.TagToken;
import com.esotericsoftware.yamlbeans.tokenizer.Token;
import com.esotericsoftware.yamlbeans.tokenizer.TokenType;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tokenizer {
    private static final String LINEBR = "\n\u0085\u2028\u2029";
    private static final String NULL_BL_LINEBR = "\u0000 \r\n\u0085";
    private static final String NULL_BL_T_LINEBR = "\u0000 \t\r\n\u0085";
    private static final String NULL_OR_OTHER = "\u0000 \t\r\n\u0085";
    private static final String NULL_OR_LINEBR = "\u0000\r\n\u0085";
    private static final String FULL_LINEBR = "\r\n\u0085";
    private static final String BLANK_OR_LINEBR = " \r\n\u0085";
    private static final String S4 = "\u0000 \t\r\n([]{}";
    private static final String ALPHA = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_";
    private static final String STRANGE_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789][-';/?:@&=+$,.!~*()%";
    private static final String RN = "\r\n";
    private static final String BLANK_T = " \t";
    private static final String SPACES_AND_STUFF = "'\"\\\u0000 \t\r\n\u0085";
    private static final String DOUBLE_ESC = "\"\\";
    private static final String NON_ALPHA_OR_NUM = "\u0000 \t\r\n\u0085?:,]}%@`";
    private static final Pattern NON_PRINTABLE = Pattern.compile("[^\t\n\r -~\u0085\u00a0-\u00ff]");
    private static final Pattern NOT_HEXA = Pattern.compile("[^0-9A-Fa-f]");
    private static final Pattern NON_ALPHA = Pattern.compile("[^-0-9A-Za-z_]");
    private static final Pattern R_FLOWZERO = Pattern.compile("[\u0000 \t\r\n\u0085]|(:[\u0000 \t\r\n(])");
    private static final Pattern R_FLOWNONZERO = Pattern.compile("[\u0000 \t\r\n\u0085\\[\\]{},:?]");
    private static final Pattern END_OR_START = Pattern.compile("^(---|\\.\\.\\.)[\u0000 \t\r\n\u0085]$");
    private static final Pattern ENDING = Pattern.compile("^---[\u0000 \t\r\n\u0085]$");
    private static final Pattern START = Pattern.compile("^\\.\\.\\.[\u0000 \t\r\n\u0085]$");
    private static final Pattern BEG = Pattern.compile("^([^\u0000 \t\r\n\u0085\\-?:,\\[\\]{}#&*!|>'\"%@]|([\\-?:][^\u0000 \t\r\n\u0085]))");
    private static final Map<Character, String> ESCAPE_REPLACEMENTS = new HashMap<Character, String>();
    private static final Map<Character, Integer> ESCAPE_CODES = new HashMap<Character, Integer>();
    private boolean done = false;
    private int flowLevel = 0;
    private int tokensTaken = 0;
    private int indent = -1;
    private boolean allowSimpleKey = true;
    private boolean eof;
    private int lineNumber = 0;
    private int column = 0;
    private int pointer = 0;
    private final StringBuilder buffer;
    private final Reader reader;
    private final List<Token> tokens = new LinkedList<Token>();
    private final List<Integer> indents = new LinkedList<Integer>();
    private final Map<Integer, SimpleKey> possibleSimpleKeys = new HashMap<Integer, SimpleKey>();
    private boolean docStart = false;

    public Tokenizer(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader cannot be null.");
        }
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.reader = reader;
        this.buffer = new StringBuilder();
        this.eof = false;
        this.fetchStreamStart();
    }

    public Tokenizer(String yaml) {
        this(new StringReader(yaml));
    }

    public Token peekNextToken() throws TokenizerException {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        return this.tokens.isEmpty() ? null : this.tokens.get(0);
    }

    public TokenType peekNextTokenType() throws TokenizerException {
        Token token = this.peekNextToken();
        if (token == null) {
            return null;
        }
        return token.type;
    }

    public Token getNextToken() throws TokenizerException {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            ++this.tokensTaken;
            Token token = this.tokens.remove(0);
            return token;
        }
        return null;
    }

    public Iterator iterator() {
        return new Iterator(){

            public boolean hasNext() {
                return null != Tokenizer.this.peekNextToken();
            }

            public Object next() {
                return Tokenizer.this.getNextToken();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private char peek() {
        if (this.pointer + 1 > this.buffer.length()) {
            this.update(1);
        }
        return this.buffer.charAt(this.pointer);
    }

    private char peek(int index) {
        if (this.pointer + index + 1 > this.buffer.length()) {
            this.update(index + 1);
        }
        return this.buffer.charAt(this.pointer + index);
    }

    private String prefix(int length) {
        if (this.pointer + length >= this.buffer.length()) {
            this.update(length);
        }
        if (this.pointer + length > this.buffer.length()) {
            return this.buffer.substring(this.pointer, this.buffer.length());
        }
        return this.buffer.substring(this.pointer, this.pointer + length);
    }

    private String prefixForward(int length) {
        if (this.pointer + length + 1 >= this.buffer.length()) {
            this.update(length + 1);
        }
        String buff = null;
        buff = this.pointer + length > this.buffer.length() ? this.buffer.substring(this.pointer, this.buffer.length()) : this.buffer.substring(this.pointer, this.pointer + length);
        char ch = '\u0000';
        int j = buff.length();
        for (int i = 0; i < j; ++i) {
            ch = buff.charAt(i);
            ++this.pointer;
            if (LINEBR.indexOf(ch) != -1 || ch == '\r' && buff.charAt(i + 1) != '\n') {
                this.column = 0;
                ++this.lineNumber;
                continue;
            }
            if (ch == '\ufeff') continue;
            ++this.column;
        }
        return buff;
    }

    private void forward() {
        if (this.pointer + 2 >= this.buffer.length()) {
            this.update(2);
        }
        char ch1 = this.buffer.charAt(this.pointer);
        ++this.pointer;
        if (ch1 == '\n' || ch1 == '\u0085' || ch1 == '\r' && this.buffer.charAt(this.pointer) != '\n') {
            this.column = 0;
            ++this.lineNumber;
        } else {
            ++this.column;
        }
    }

    private void forward(int length) {
        if (this.pointer + length + 1 >= this.buffer.length()) {
            this.update(length + 1);
        }
        char ch = '\u0000';
        for (int i = 0; i < length; ++i) {
            ch = this.buffer.charAt(this.pointer);
            ++this.pointer;
            if (LINEBR.indexOf(ch) != -1 || ch == '\r' && this.buffer.charAt(this.pointer) != '\n') {
                this.column = 0;
                ++this.lineNumber;
                continue;
            }
            if (ch == '\ufeff') continue;
            ++this.column;
        }
    }

    private void update(int length) {
        this.buffer.delete(0, this.pointer);
        this.pointer = 0;
        while (this.buffer.length() < length) {
            String rawData = "";
            if (!this.eof) {
                char[] data = new char[1024];
                int converted = -2;
                try {
                    converted = this.reader.read(data);
                }
                catch (IOException ioe) {
                    throw new TokenizerException("Error reading from stream.", ioe);
                }
                if (converted == -1) {
                    this.eof = true;
                } else {
                    rawData = String.valueOf(data, 0, converted);
                }
            }
            this.buffer.append(rawData);
            if (!this.eof) continue;
            this.buffer.append('\u0000');
            break;
        }
    }

    private boolean needMoreTokens() {
        if (this.done) {
            return false;
        }
        return this.tokens.isEmpty() || this.nextPossibleSimpleKey() == this.tokensTaken;
    }

    private Token fetchMoreTokens() {
        this.scanToNextToken();
        this.unwindIndent(this.column);
        char ch = this.peek();
        boolean colz = this.column == 0;
        switch (ch) {
            case '\u0000': {
                return this.fetchStreamEnd();
            }
            case '\'': {
                return this.fetchSingle();
            }
            case '\"': {
                return this.fetchDouble();
            }
            case '?': {
                if (this.flowLevel == 0 && "\u0000 \t\r\n\u0085".indexOf(this.peek(1)) == -1) break;
                return this.fetchKey();
            }
            case ':': {
                if (this.flowLevel == 0 && "\u0000 \t\r\n\u0085".indexOf(this.peek(1)) == -1) break;
                return this.fetchValue();
            }
            case '%': {
                if (!colz) break;
                return this.fetchDirective();
            }
            case '-': {
                if ((colz || this.docStart) && ENDING.matcher(this.prefix(4)).matches()) {
                    return this.fetchDocumentStart();
                }
                if ("\u0000 \t\r\n\u0085".indexOf(this.peek(1)) == -1) break;
                return this.fetchBlockEntry();
            }
            case '.': {
                if (!colz || !START.matcher(this.prefix(4)).matches()) break;
                return this.fetchDocumentEnd();
            }
            case '[': {
                return this.fetchFlowSequenceStart();
            }
            case '{': {
                return this.fetchFlowMappingStart();
            }
            case ']': {
                return this.fetchFlowSequenceEnd();
            }
            case '}': {
                return this.fetchFlowMappingEnd();
            }
            case ',': {
                return this.fetchFlowEntry();
            }
            case '*': {
                return this.fetchAlias();
            }
            case '&': {
                return this.fetchAnchor();
            }
            case '!': {
                return this.fetchTag();
            }
            case '|': {
                if (this.flowLevel != 0) break;
                return this.fetchLiteral();
            }
            case '>': {
                if (this.flowLevel != 0) break;
                return this.fetchFolded();
            }
        }
        if (BEG.matcher(this.prefix(2)).find()) {
            return this.fetchPlain();
        }
        if (ch == '\t') {
            throw new TokenizerException("Tabs cannot be used for indentation.");
        }
        throw new TokenizerException("While scanning for the next token, a character that cannot begin a token was found: " + this.ch(ch));
    }

    private int nextPossibleSimpleKey() {
        for (SimpleKey key : this.possibleSimpleKeys.values()) {
            if (key.tokenNumber <= 0) continue;
            return key.tokenNumber;
        }
        return -1;
    }

    private void savePossibleSimpleKey() {
        if (this.allowSimpleKey) {
            this.possibleSimpleKeys.put(this.flowLevel, new SimpleKey(this.tokensTaken + this.tokens.size(), this.column));
        }
    }

    private void unwindIndent(int col) {
        if (this.flowLevel != 0) {
            return;
        }
        while (this.indent > col) {
            this.indent = this.indents.remove(0);
            this.tokens.add(Token.BLOCK_END);
        }
    }

    private boolean addIndent(int col) {
        if (this.indent < col) {
            this.indents.add(0, this.indent);
            this.indent = col;
            return true;
        }
        return false;
    }

    private Token fetchStreamStart() {
        this.docStart = true;
        this.tokens.add(Token.STREAM_START);
        return Token.STREAM_START;
    }

    private Token fetchStreamEnd() {
        this.unwindIndent(-1);
        this.allowSimpleKey = false;
        this.possibleSimpleKeys.clear();
        this.tokens.add(Token.STREAM_END);
        this.done = true;
        return Token.STREAM_END;
    }

    private Token fetchDirective() {
        this.unwindIndent(-1);
        this.allowSimpleKey = false;
        Token tok = this.scanDirective();
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchDocumentStart() {
        this.docStart = false;
        return this.fetchDocumentIndicator(Token.DOCUMENT_START);
    }

    private Token fetchDocumentEnd() {
        return this.fetchDocumentIndicator(Token.DOCUMENT_END);
    }

    private Token fetchDocumentIndicator(Token tok) {
        this.unwindIndent(-1);
        this.allowSimpleKey = false;
        this.forward(3);
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchFlowSequenceStart() {
        return this.fetchFlowCollectionStart(Token.FLOW_SEQUENCE_START);
    }

    private Token fetchFlowMappingStart() {
        return this.fetchFlowCollectionStart(Token.FLOW_MAPPING_START);
    }

    private Token fetchFlowCollectionStart(Token tok) {
        this.savePossibleSimpleKey();
        ++this.flowLevel;
        this.allowSimpleKey = true;
        this.forward(1);
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchFlowSequenceEnd() {
        return this.fetchFlowCollectionEnd(Token.FLOW_SEQUENCE_END);
    }

    private Token fetchFlowMappingEnd() {
        return this.fetchFlowCollectionEnd(Token.FLOW_MAPPING_END);
    }

    private Token fetchFlowCollectionEnd(Token tok) {
        --this.flowLevel;
        this.allowSimpleKey = false;
        this.forward(1);
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchFlowEntry() {
        this.allowSimpleKey = true;
        this.forward(1);
        this.tokens.add(Token.FLOW_ENTRY);
        return Token.FLOW_ENTRY;
    }

    private Token fetchBlockEntry() {
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                throw new TokenizerException("Found a sequence entry where it is not allowed.");
            }
            if (this.addIndent(this.column)) {
                this.tokens.add(Token.BLOCK_SEQUENCE_START);
            }
        }
        this.allowSimpleKey = true;
        this.forward();
        this.tokens.add(Token.BLOCK_ENTRY);
        return Token.BLOCK_ENTRY;
    }

    private Token fetchKey() {
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                throw new TokenizerException("Found a mapping key where it is not allowed.");
            }
            if (this.addIndent(this.column)) {
                this.tokens.add(Token.BLOCK_MAPPING_START);
            }
        }
        this.allowSimpleKey = this.flowLevel == 0;
        this.forward();
        this.tokens.add(Token.KEY);
        return Token.KEY;
    }

    private Token fetchValue() {
        SimpleKey key = this.possibleSimpleKeys.get(this.flowLevel);
        if (null == key) {
            if (this.flowLevel == 0 && !this.allowSimpleKey) {
                throw new TokenizerException("Found a mapping value where it is not allowed.");
            }
        } else {
            this.possibleSimpleKeys.remove(this.flowLevel);
            this.tokens.add(key.tokenNumber - this.tokensTaken, Token.KEY);
            if (this.flowLevel == 0 && this.addIndent(key.column)) {
                this.tokens.add(key.tokenNumber - this.tokensTaken, Token.BLOCK_MAPPING_START);
            }
            this.allowSimpleKey = false;
        }
        this.forward();
        this.tokens.add(Token.VALUE);
        return Token.VALUE;
    }

    private Token fetchAlias() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor(new AliasToken());
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchAnchor() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor(new AnchorToken());
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchTag() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanTag();
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchLiteral() {
        return this.fetchBlockScalar('|');
    }

    private Token fetchFolded() {
        return this.fetchBlockScalar('>');
    }

    private Token fetchBlockScalar(char style) {
        this.allowSimpleKey = true;
        Token tok = this.scanBlockScalar(style);
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchSingle() {
        return this.fetchFlowScalar('\'');
    }

    private Token fetchDouble() {
        return this.fetchFlowScalar('\"');
    }

    private Token fetchFlowScalar(char style) {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanFlowScalar(style);
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchPlain() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanPlain();
        this.tokens.add(tok);
        return tok;
    }

    private void scanToNextToken() {
        while (true) {
            if (this.peek() == ' ') {
                this.forward();
                continue;
            }
            if (this.peek() == '#') {
                while (NULL_OR_LINEBR.indexOf(this.peek()) == -1) {
                    this.forward();
                }
            }
            if (this.scanLineBreak().length() == 0) break;
            if (this.flowLevel != 0) continue;
            this.allowSimpleKey = true;
        }
    }

    private Token scanDirective() {
        this.forward();
        String name = this.scanDirectiveName();
        String value = null;
        if (name.equals("YAML")) {
            value = this.scanYamlDirectiveValue();
        } else if (name.equals("TAG")) {
            value = this.scanTagDirectiveValue();
        } else {
            char ch;
            StringBuilder buffer = new StringBuilder();
            while (NULL_OR_LINEBR.indexOf(ch = this.peek()) == -1) {
                buffer.append(ch);
                this.forward();
            }
            value = buffer.toString().trim();
        }
        this.scanDirectiveIgnoredLine();
        return new DirectiveToken(name, value);
    }

    private String scanDirectiveName() {
        int length = 0;
        char ch = this.peek(length);
        boolean zlen = true;
        while (ALPHA.indexOf(ch) != -1) {
            zlen = false;
            ch = this.peek(++length);
        }
        if (zlen) {
            throw new TokenizerException("While scanning for a directive name, expected an alpha or numeric character but found: " + this.ch(ch));
        }
        String value = this.prefixForward(length);
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning for a directive name, expected an alpha or numeric character but found: " + this.ch(ch));
        }
        return value;
    }

    private String scanYamlDirectiveValue() {
        while (this.peek() == ' ') {
            this.forward();
        }
        String major = this.scanYamlDirectiveNumber();
        if (this.peek() != '.') {
            throw new TokenizerException("While scanning for a directive value, expected a digit or '.' but found: " + this.ch(this.peek()));
        }
        this.forward();
        String minor = this.scanYamlDirectiveNumber();
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning for a directive value, expected a digit or '.' but found: " + this.ch(this.peek()));
        }
        return major + " " + minor;
    }

    private String scanYamlDirectiveNumber() {
        char ch = this.peek();
        if (!Character.isDigit(ch)) {
            throw new TokenizerException("While scanning for a directive number, expected a digit but found: " + this.ch(ch));
        }
        int length = 0;
        while (Character.isDigit(this.peek(length))) {
            ++length;
        }
        String value = this.prefixForward(length);
        return value;
    }

    private String scanTagDirectiveValue() {
        while (this.peek() == ' ') {
            this.forward();
        }
        String handle = this.scanTagDirectiveHandle();
        while (this.peek() == ' ') {
            this.forward();
        }
        String prefix = this.scanTagDirectivePrefix();
        return handle + " " + prefix;
    }

    private String scanTagDirectiveHandle() {
        String value = this.scanTagHandle("directive");
        if (this.peek() != ' ') {
            throw new TokenizerException("While scanning for a directive tag handle, expected ' ' but found: " + this.ch(this.peek()));
        }
        return value;
    }

    private String scanTagDirectivePrefix() {
        String value = this.scanTagUri("directive");
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning for a directive tag prefix, expected ' ' but found: " + this.ch(this.peek()));
        }
        return value;
    }

    private String scanDirectiveIgnoredLine() {
        char ch;
        while (this.peek() == ' ') {
            this.forward();
        }
        if (this.peek() == '\"') {
            while (NULL_OR_LINEBR.indexOf(this.peek()) == -1) {
                this.forward();
            }
        }
        if (NULL_OR_LINEBR.indexOf(ch = this.peek()) == -1) {
            throw new TokenizerException("While scanning a directive, expected a comment or line break but found: " + this.ch(this.peek()));
        }
        return this.scanLineBreak();
    }

    private Token scanAnchor(Token tok) {
        String chunk;
        char indicator = this.peek();
        String name = indicator == '*' ? "alias" : "anchor";
        this.forward();
        int length = 0;
        int chunk_size = 16;
        Matcher m = null;
        while (!(m = NON_ALPHA.matcher(chunk = this.prefix(chunk_size))).find()) {
            chunk_size += 16;
        }
        length = m.start();
        if (length == 0) {
            throw new TokenizerException("While scanning an " + name + ", a non-alpha, non-numeric character was found.");
        }
        String value = this.prefixForward(length);
        if (NON_ALPHA_OR_NUM.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning an " + name + ", expected an alpha or numeric character but found: " + this.ch(this.peek()));
        }
        if (tok instanceof AnchorToken) {
            ((AnchorToken)tok).setInstanceName(value);
        } else {
            ((AliasToken)tok).setInstanceName(value);
        }
        return tok;
    }

    private Token scanTag() {
        char ch = this.peek(1);
        String handle = null;
        String suffix = null;
        if (ch == '<') {
            this.forward(2);
            suffix = this.scanTagUri("tag");
            if (this.peek() != '>') {
                throw new TokenizerException("While scanning a tag, expected '>' but found: " + this.ch(this.peek()));
            }
            this.forward();
        } else if ("\u0000 \t\r\n\u0085".indexOf(ch) != -1) {
            suffix = "!";
            this.forward();
        } else {
            int length = 1;
            boolean useHandle = false;
            while ("\u0000 \t\r\n\u0085".indexOf(ch) == -1) {
                if (ch == '!') {
                    useHandle = true;
                    break;
                }
                ch = this.peek(++length);
            }
            handle = "!";
            if (useHandle) {
                handle = this.scanTagHandle("tag");
            } else {
                handle = "!";
                this.forward();
            }
            suffix = this.scanTagUri("tag");
        }
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning a tag, expected ' ' but found: " + this.ch(this.peek()));
        }
        return new TagToken(handle, suffix);
    }

    private Token scanBlockScalar(char style) {
        boolean folded = style == '>';
        StringBuilder chunks = new StringBuilder();
        this.forward();
        Object[] chompi = this.scanBlockScalarIndicators();
        boolean chomping = (Boolean)chompi[0];
        int increment = (Integer)chompi[1];
        this.scanBlockScalarIgnoredLine();
        int minIndent = this.indent + 1;
        if (minIndent < 1) {
            minIndent = 1;
        }
        String breaks = null;
        int maxIndent = 0;
        int ind = 0;
        if (increment == -1) {
            Object[] brme = this.scanBlockScalarIndentation();
            breaks = (String)brme[0];
            maxIndent = (Integer)brme[1];
            ind = minIndent > maxIndent ? minIndent : maxIndent;
        } else {
            ind = minIndent + increment - 1;
            breaks = this.scanBlockScalarBreaks(ind);
        }
        String lineBreak = "";
        while (this.column == ind && this.peek() != '\u0000') {
            chunks.append(breaks);
            boolean leadingNonSpace = BLANK_T.indexOf(this.peek()) == -1;
            int length = 0;
            while (NULL_OR_LINEBR.indexOf(this.peek(length)) == -1) {
                ++length;
            }
            chunks.append(this.prefixForward(length));
            lineBreak = this.scanLineBreak();
            breaks = this.scanBlockScalarBreaks(ind);
            if (this.column != ind || this.peek() == '\u0000') break;
            if (folded && lineBreak.equals("\n") && leadingNonSpace && BLANK_T.indexOf(this.peek()) == -1) {
                if (breaks.length() != 0) continue;
                chunks.append(" ");
                continue;
            }
            chunks.append(lineBreak);
        }
        if (chomping) {
            chunks.append(lineBreak);
            chunks.append(breaks);
        }
        return new ScalarToken(chunks.toString(), false, style);
    }

    private Object[] scanBlockScalarIndicators() {
        boolean chomping = false;
        int increment = -1;
        char ch = this.peek();
        if (ch == '-' || ch == '+') {
            chomping = ch == '+';
            this.forward();
            ch = this.peek();
            if (Character.isDigit(ch)) {
                increment = Integer.parseInt("" + ch);
                if (increment == 0) {
                    throw new TokenizerException("While scanning a black scaler, expected indentation indicator between 1 and 9 but found: 0");
                }
                this.forward();
            }
        } else if (Character.isDigit(ch)) {
            increment = Integer.parseInt("" + ch);
            if (increment == 0) {
                throw new TokenizerException("While scanning a black scaler, expected indentation indicator between 1 and 9 but found: 0");
            }
            this.forward();
            ch = this.peek();
            if (ch == '-' || ch == '+') {
                chomping = ch == '+';
                this.forward();
            }
        }
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning a block scalar, expected chomping or indentation indicators but found: " + this.ch(this.peek()));
        }
        return new Object[]{chomping, increment};
    }

    private String scanBlockScalarIgnoredLine() {
        while (this.peek() == ' ') {
            this.forward();
        }
        if (this.peek() == '#') {
            while (NULL_OR_LINEBR.indexOf(this.peek()) == -1) {
                this.forward();
            }
        }
        if (NULL_OR_LINEBR.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning a block scalar, expected a comment or line break but found: " + this.ch(this.peek()));
        }
        return this.scanLineBreak();
    }

    private Object[] scanBlockScalarIndentation() {
        StringBuilder chunks = new StringBuilder();
        int maxIndent = 0;
        while (BLANK_OR_LINEBR.indexOf(this.peek()) != -1) {
            if (this.peek() != ' ') {
                chunks.append(this.scanLineBreak());
                continue;
            }
            this.forward();
            if (this.column <= maxIndent) continue;
            maxIndent = this.column;
        }
        return new Object[]{chunks.toString(), maxIndent};
    }

    private String scanBlockScalarBreaks(int indent) {
        StringBuilder chunks = new StringBuilder();
        while (this.column < indent && this.peek() == ' ') {
            this.forward();
        }
        while (FULL_LINEBR.indexOf(this.peek()) != -1) {
            chunks.append(this.scanLineBreak());
            while (this.column < indent && this.peek() == ' ') {
                this.forward();
            }
        }
        return chunks.toString();
    }

    private Token scanFlowScalar(char style) {
        boolean dbl = style == '\"';
        StringBuilder chunks = new StringBuilder();
        char quote = this.peek();
        this.forward();
        chunks.append(this.scanFlowScalarNonSpaces(dbl));
        while (this.peek() != quote) {
            chunks.append(this.scanFlowScalarSpaces());
            chunks.append(this.scanFlowScalarNonSpaces(dbl));
        }
        this.forward();
        return new ScalarToken(chunks.toString(), false, style);
    }

    private String scanFlowScalarNonSpaces(boolean dbl) {
        StringBuilder chunks;
        block8: {
            char ch;
            chunks = new StringBuilder();
            while (true) {
                int length = 0;
                while (SPACES_AND_STUFF.indexOf(this.peek(length)) == -1) {
                    ++length;
                }
                if (length != 0) {
                    chunks.append(this.prefixForward(length));
                }
                ch = this.peek();
                if (!dbl && ch == '\'' && this.peek(1) == '\'') {
                    chunks.append("'");
                    this.forward(2);
                    continue;
                }
                if (dbl && ch == '\'' || !dbl && DOUBLE_ESC.indexOf(ch) != -1) {
                    chunks.append(ch);
                    this.forward();
                    continue;
                }
                if (!dbl || ch != '\\') break block8;
                this.forward();
                ch = this.peek();
                if (ESCAPE_REPLACEMENTS.containsKey(Character.valueOf(ch))) {
                    chunks.append(ESCAPE_REPLACEMENTS.get(Character.valueOf(ch)));
                    this.forward();
                    continue;
                }
                if (ESCAPE_CODES.containsKey(Character.valueOf(ch))) {
                    length = ESCAPE_CODES.get(Character.valueOf(ch));
                    this.forward();
                    String val = this.prefix(length);
                    if (NOT_HEXA.matcher(val).find()) {
                        throw new TokenizerException("While scanning a double quoted scalar, expected an escape sequence of " + length + " hexadecimal numbers but found: " + this.ch(this.peek()));
                    }
                    chunks.append(Character.toChars(Integer.parseInt(val, 16)));
                    this.forward(length);
                    continue;
                }
                if (FULL_LINEBR.indexOf(ch) == -1) break;
                this.scanLineBreak();
                chunks.append(this.scanFlowScalarBreaks());
            }
            throw new TokenizerException("While scanning a double quoted scalar, found unknown escape character: " + this.ch(ch));
        }
        return chunks.toString();
    }

    private String scanFlowScalarSpaces() {
        StringBuilder chunks = new StringBuilder();
        int length = 0;
        while (BLANK_T.indexOf(this.peek(length)) != -1) {
            ++length;
        }
        String whitespaces = this.prefixForward(length);
        char ch = this.peek();
        if (ch == '\u0000') {
            throw new TokenizerException("While scanning a quoted scalar, found unexpected end of stream.");
        }
        if (FULL_LINEBR.indexOf(ch) != -1) {
            String lineBreak = this.scanLineBreak();
            String breaks = this.scanFlowScalarBreaks();
            if (!lineBreak.equals("\n")) {
                chunks.append(lineBreak);
            } else if (breaks.length() == 0) {
                chunks.append(" ");
            }
            chunks.append(breaks);
        } else {
            chunks.append(whitespaces);
        }
        return chunks.toString();
    }

    private String scanFlowScalarBreaks() {
        StringBuilder chunks = new StringBuilder();
        String pre = null;
        while (true) {
            if (((pre = this.prefix(3)).equals("---") || pre.equals("...")) && "\u0000 \t\r\n\u0085".indexOf(this.peek(3)) != -1) {
                throw new TokenizerException("While scanning a quoted scalar, found unexpected document separator.");
            }
            while (BLANK_T.indexOf(this.peek()) != -1) {
                this.forward();
            }
            if (FULL_LINEBR.indexOf(this.peek()) == -1) break;
            chunks.append(this.scanLineBreak());
        }
        return chunks.toString();
    }

    private Token scanPlain() {
        StringBuilder chunks = new StringBuilder();
        int ind = this.indent + 1;
        String spaces = "";
        boolean f_nzero = true;
        Pattern r_check = R_FLOWNONZERO;
        if (this.flowLevel == 0) {
            f_nzero = false;
            r_check = R_FLOWZERO;
        }
        while (this.peek() != '#') {
            int length = 0;
            int chunkSize = 32;
            Matcher m = null;
            while (!(m = r_check.matcher(this.prefix(chunkSize))).find()) {
                chunkSize += 32;
            }
            length = m.start();
            char ch = this.peek(length);
            if (f_nzero && ch == ':' && S4.indexOf(this.peek(length + 1)) == -1) {
                this.forward(length);
                throw new TokenizerException("While scanning a plain scalar, found unexpected ':'. See: http://pyyaml.org/wiki/YAMLColonInFlowContext");
            }
            if (length == 0) break;
            this.allowSimpleKey = false;
            chunks.append(spaces);
            chunks.append(this.prefixForward(length));
            spaces = this.scanPlainSpaces();
            if (spaces != null && (this.flowLevel != 0 || this.column >= ind)) continue;
            break;
        }
        return new ScalarToken(chunks.toString(), true);
    }

    private String scanPlainSpaces() {
        StringBuilder chunks = new StringBuilder();
        int length = 0;
        while (this.peek(length) == ' ') {
            ++length;
        }
        String whitespaces = this.prefixForward(length);
        char ch = this.peek();
        if (FULL_LINEBR.indexOf(ch) != -1) {
            String lineBreak = this.scanLineBreak();
            this.allowSimpleKey = true;
            if (END_OR_START.matcher(this.prefix(4)).matches()) {
                return "";
            }
            StringBuilder breaks = new StringBuilder();
            while (BLANK_OR_LINEBR.indexOf(this.peek()) != -1) {
                if (' ' == this.peek()) {
                    this.forward();
                    continue;
                }
                breaks.append(this.scanLineBreak());
                if (!END_OR_START.matcher(this.prefix(4)).matches()) continue;
                return "";
            }
            if (!lineBreak.equals("\n")) {
                chunks.append(lineBreak);
            } else if (breaks.length() == 0) {
                chunks.append(" ");
            }
            chunks.append((CharSequence)breaks);
        } else {
            chunks.append(whitespaces);
        }
        return chunks.toString();
    }

    private String scanTagHandle(String name) {
        char ch = this.peek();
        if (ch != '!') {
            throw new TokenizerException("While scanning a " + name + ", expected '!' but found: " + this.ch(ch));
        }
        int length = 1;
        ch = this.peek(length);
        if (ch != ' ') {
            while (ALPHA.indexOf(ch) != -1) {
                ch = this.peek(++length);
            }
            if ('!' != ch) {
                this.forward(length);
                throw new TokenizerException("While scanning a " + name + ", expected '!' but found: " + this.ch(ch));
            }
            ++length;
        }
        String value = this.prefixForward(length);
        return value;
    }

    private String scanTagUri(String name) {
        StringBuilder chunks = new StringBuilder();
        int length = 0;
        char ch = this.peek(length);
        while (STRANGE_CHAR.indexOf(ch) != -1) {
            if ('%' == ch) {
                chunks.append(this.prefixForward(length));
                length = 0;
                chunks.append(this.scanUriEscapes(name));
            } else {
                ++length;
            }
            ch = this.peek(length);
        }
        if (length != 0) {
            chunks.append(this.prefixForward(length));
        }
        if (chunks.length() == 0) {
            throw new TokenizerException("While scanning a " + name + ", expected a URI but found: " + this.ch(ch));
        }
        return chunks.toString();
    }

    private String scanUriEscapes(String name) {
        StringBuilder bytes = new StringBuilder();
        while (this.peek() == '%') {
            this.forward();
            try {
                bytes.append(Integer.parseInt(this.prefix(2), 16));
            }
            catch (NumberFormatException nfe) {
                throw new TokenizerException("While scanning a " + name + ", expected a URI escape sequence of 2 hexadecimal numbers but found: " + this.ch(this.peek(1)) + " and " + this.ch(this.peek(2)));
            }
            this.forward(2);
        }
        return bytes.toString();
    }

    private String scanLineBreak() {
        char val = this.peek();
        if (FULL_LINEBR.indexOf(val) != -1) {
            if (RN.equals(this.prefix(2))) {
                this.forward(2);
            } else {
                this.forward();
            }
            return "\n";
        }
        return "";
    }

    private String ch(char ch) {
        return "'" + ch + "' (" + ch + ")";
    }

    public static void main(String[] args) throws Exception {
        Iterator iter = new Tokenizer(new FileReader("test/test.yml")).iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

    static {
        ESCAPE_REPLACEMENTS.put(Character.valueOf('0'), "\u0000");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('a'), "\u0007");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('b'), "\b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('t'), "\t");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\t'), "\t");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('n'), "\n");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('v'), "\u000b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('f'), "\f");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('r'), "\r");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('e'), "\u001b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf(' '), " ");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\"'), "\"");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\\'), "\\");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('N'), "\u0085");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('_'), "\u00a0");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('L'), "\u2028");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('P'), "\u2029");
        ESCAPE_CODES.put(Character.valueOf('x'), 2);
        ESCAPE_CODES.put(Character.valueOf('u'), 4);
        ESCAPE_CODES.put(Character.valueOf('U'), 8);
    }

    static class SimpleKey {
        public final int tokenNumber;
        public final int column;

        public SimpleKey(int tokenNumber, int column) {
            this.tokenNumber = tokenNumber;
            this.column = column;
        }
    }

    public class TokenizerException
    extends RuntimeException {
        public TokenizerException(String message, Throwable cause) {
            super("Line " + Tokenizer.this.getLineNumber() + ", column " + Tokenizer.this.getColumn() + ": " + message, cause);
        }

        public TokenizerException(String message) {
            this(message, null);
        }
    }
}

