/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlProperties
extends Properties {
    static final String DTD_SYSTEM_ID = "http://www.mchange.com/dtd/xml-properties.dtd";
    static final String DTD_RSRC_PATH = "dtd/xml-properties.dtd";
    DocumentBuilder docBuilder;
    Transformer identityTransformer;

    public XmlProperties() throws ParserConfigurationException, TransformerConfigurationException {
        EntityResolver er = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                if (XmlProperties.DTD_SYSTEM_ID.equals(systemId)) {
                    InputStream is = XmlProperties.class.getResourceAsStream(XmlProperties.DTD_RSRC_PATH);
                    return new InputSource(is);
                }
                return null;
            }
        };
        ErrorHandler eh = new ErrorHandler(){

            public void warning(SAXParseException e) throws SAXException {
                System.err.println("[Warning] " + e.toString());
            }

            public void error(SAXParseException e) throws SAXException {
                System.err.println("[Error] " + e.toString());
            }

            public void fatalError(SAXParseException e) throws SAXException {
                System.err.println("[Fatal Error] " + e.toString());
            }
        };
        DocumentBuilderFactory dbFact = DocumentBuilderFactory.newInstance();
        dbFact.setValidating(true);
        dbFact.setCoalescing(true);
        dbFact.setIgnoringComments(true);
        this.docBuilder = dbFact.newDocumentBuilder();
        this.docBuilder.setEntityResolver(er);
        this.docBuilder.setErrorHandler(eh);
        TransformerFactory tFact = TransformerFactory.newInstance();
        this.identityTransformer = tFact.newTransformer();
        this.identityTransformer.setOutputProperty("indent", "yes");
        this.identityTransformer.setOutputProperty("doctype-system", DTD_SYSTEM_ID);
    }

    public synchronized void loadXml(InputStream is) throws IOException, SAXException {
        Document doc = this.docBuilder.parse(is);
        NodeList nl = doc.getElementsByTagName("property");
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            this.extractProperty(nl.item(i));
        }
    }

    private void extractProperty(Node propNode) {
        String val;
        Element propElem = (Element)propNode;
        String key = propElem.getAttribute("name");
        boolean trim = Boolean.valueOf(propElem.getAttribute("trim"));
        NodeList nl = propElem.getChildNodes();
        int len = nl.getLength();
        assert (len >= 0 && len <= 1) : "Bad number of children of property element: " + len;
        String string = val = len == 0 ? "" : ((Text)nl.item(0)).getNodeValue();
        if (trim) {
            val = val.trim();
        }
        this.put(key, val);
    }

    public synchronized void saveXml(OutputStream os) throws IOException, TransformerException {
        this.storeXml(os, null);
    }

    public synchronized void storeXml(OutputStream os, String header) throws IOException, TransformerException {
        Document doc = this.docBuilder.newDocument();
        if (header != null) {
            Comment comment = doc.createComment(header);
            doc.appendChild(comment);
        }
        Element xmlPropsElem = doc.createElement("xml-properties");
        Iterator<Object> ii = this.keySet().iterator();
        while (ii.hasNext()) {
            Element propsElem = doc.createElement("property");
            String key = (String)ii.next();
            String val = (String)this.get(key);
            propsElem.setAttribute("name", key);
            Text valNode = doc.createTextNode(val);
            propsElem.appendChild(valNode);
            xmlPropsElem.appendChild(propsElem);
        }
        doc.appendChild(xmlPropsElem);
        this.identityTransformer.transform(new DOMSource(doc), new StreamResult(os));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] argv) {
        block19: {
            InputStream is = null;
            OutputStream os = null;
            is = new BufferedInputStream(new FileInputStream(argv[0]));
            os = new BufferedOutputStream(new FileOutputStream(argv[1]));
            XmlProperties xmlProps = new XmlProperties();
            xmlProps.loadXml(is);
            xmlProps.list(System.out);
            xmlProps.storeXml(os, "This is the resaved test document.");
            os.flush();
            Object var5_5 = null;
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            try {
                if (os != null) {
                    os.close();
                }
                break block19;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            break block19;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    Object var5_6 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    try {
                        if (os != null) {
                            os.close();
                        }
                        break block19;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }
}

