/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.internal.FileXmlSource;
import org.hibernate.boot.jaxb.spi.Binder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.jaxb.spi.XmlSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.SerializationException;

public class CacheableFileXmlSource
extends XmlSource {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(CacheableFileXmlSource.class);
    private final File xmlFile;
    private final File serFile;
    private final boolean strict;

    public CacheableFileXmlSource(Origin origin, File xmlFile, boolean strict) {
        super(origin);
        boolean useCachedFile;
        this.xmlFile = xmlFile;
        this.strict = strict;
        this.serFile = CacheableFileXmlSource.determineCachedFile(xmlFile);
        boolean bl = useCachedFile = xmlFile.exists() && this.serFile.exists() && xmlFile.lastModified() < this.serFile.lastModified();
        if (strict && !useCachedFile) {
            throw new MappingException(String.format("Cached file [%s] could not be found or could not be used", origin.getName()), origin);
        }
    }

    private static File determineCachedFile(File xmlFile) {
        return new File(xmlFile.getAbsolutePath() + ".bin");
    }

    @Override
    public Binding doBind(Binder binder) {
        if (this.strict) {
            try {
                return new Binding(this.readSerFile(), this.getOrigin());
            }
            catch (SerializationException e) {
                throw new MappingException(String.format("Unable to deserialize from cached file [%s]", this.getOrigin().getName()), e, this.getOrigin());
            }
            catch (FileNotFoundException e) {
                throw new MappingException(String.format("Unable to locate cached file [%s]", this.getOrigin().getName()), e, this.getOrigin());
            }
        }
        try {
            return (Binding)this.readSerFile();
        }
        catch (SerializationException e) {
            log.unableToDeserializeCache(this.serFile.getName(), e);
        }
        catch (FileNotFoundException e) {
            log.cachedFileNotFound(this.serFile.getName(), e);
        }
        log.readingMappingsFromFile(this.xmlFile.getPath());
        Binding binding = FileXmlSource.doBind(binder, this.xmlFile, this.getOrigin());
        this.writeSerFile(binding);
        return null;
    }

    private <T> T readSerFile() throws SerializationException, FileNotFoundException {
        log.readingCachedMappings(this.serFile);
        return SerializationHelper.deserialize(new FileInputStream(this.serFile));
    }

    private void writeSerFile(Object binding) {
        try {
            log.debugf("Writing cache file for: %s to: %s", this.xmlFile.getAbsolutePath(), this.serFile.getAbsolutePath());
            SerializationHelper.serialize((Serializable)binding, new FileOutputStream(this.serFile));
        }
        catch (Exception e) {
            log.unableToWriteCachedFile(this.serFile.getAbsolutePath(), e.getMessage());
        }
    }
}

