/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.toolbox;

import fi.csc.microarray.description.SADLDescription;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SADLReplacements {
    private static final Logger logger = Logger.getLogger(SADLReplacements.class);
    private File toolsBin;

    public SADLReplacements(File toolsBin) {
        this.toolsBin = toolsBin;
    }

    public SADLDescription.Name[] processNames(Collection<SADLDescription.Name> options) throws IOException {
        ArrayList<SADLDescription.Name> newOptions = new ArrayList<SADLDescription.Name>();
        for (SADLDescription.Name option : options) {
            List<String> replaced = this.processReplacements(option.getID());
            if (replaced.size() == 1 && option.getID().equals(replaced.get(0))) {
                newOptions.add(option);
                continue;
            }
            newOptions.addAll(this.getNames(replaced));
        }
        return newOptions.toArray(new SADLDescription.Name[0]);
    }

    public String[] processStrings(Collection<String> options) throws IOException {
        ArrayList newOptions = new ArrayList();
        Iterator<String> iterator = options.iterator();
        if (iterator.hasNext()) {
            String option = iterator.next();
            return this.processReplacements(option).toArray(new String[0]);
        }
        return newOptions.toArray(new String[0]);
    }

    private List<String> processReplacements(String option) throws IOException {
        String FILES = "FILES";
        String SYMLINK_TARGET = "SYMLINK_TARGET";
        String[] tokens = this.parseReplacements(option);
        if (tokens.length >= 1) {
            if (FILES.equals(tokens[0])) {
                if (tokens.length == 3) {
                    return this.getFiles(tokens[1], tokens[2]);
                }
                throw new IOException(FILES + " expected 2 parameters, but got " + (tokens.length - 1));
            }
            if (SYMLINK_TARGET.equals(tokens[0])) {
                if (tokens.length == 3) {
                    return Arrays.asList(this.getSymlinkTarget(tokens[1], tokens[2]));
                }
                throw new IOException(SYMLINK_TARGET + " expected 2 parameters, but got " + (tokens.length - 1));
            }
        }
        return Arrays.asList(option);
    }

    private String[] parseReplacements(String value) {
        String[] tokens = value.split("\\s+");
        return tokens;
    }

    private ArrayList<SADLDescription.Name> getNames(Collection<String> ids) {
        ArrayList<SADLDescription.Name> names = new ArrayList<SADLDescription.Name>();
        for (String id : ids) {
            SADLDescription.Name name = new SADLDescription.Name();
            name.setID(id);
            names.add(name);
        }
        return names;
    }

    private ArrayList<String> getFiles(String path, String endsWith) throws IOException {
        ArrayList<String> basenames = new ArrayList<String>();
        File dir = new File(this.toolsBin, path);
        if (!dir.exists()) {
            throw new IOException("failed to get enum options from files, file not found: " + dir.getPath());
        }
        for (String fileName : dir.list()) {
            if (!fileName.endsWith(endsWith)) continue;
            String basename = fileName.substring(0, fileName.length() - endsWith.length());
            basenames.add(basename);
        }
        basenames.sort(null);
        return basenames;
    }

    private String getSymlinkTarget(String path, String fileExtension) throws IOException {
        Path symlink = new File(this.toolsBin, path).toPath();
        if (Files.isSymbolicLink(symlink)) {
            String target = Files.readSymbolicLink(symlink).getFileName().toString();
            target = StringUtils.removeEnd((String)target, (String)fileExtension);
            return target;
        }
        throw new IOException("failed to get symlink target, not a symlink: " + path);
    }
}

