/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessionworker;

import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.filebroker.RestFileBrokerClient;
import fi.csc.chipster.rest.CredentialsProvider;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.StaticCredentials;
import fi.csc.chipster.rest.hibernate.Transaction;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.SessionDbClient;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Input;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.Session;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="sessions")
public class SessionWorkerResource {
    private static final String SESSION_JSON = "session.json";
    private static final String DATASETS_JSON = "datasets.json";
    private static final String JOBS_JSON = "jobs.json";
    protected static final List<String> compressedExtensions = Arrays.asList(".gz", ".zip", ".bam");
    private static Logger logger = LogManager.getLogger();
    private ServiceLocatorClient serviceLocator;

    @GET
    @Path(value="{sessionId}")
    @Produces(value={"application/octet-stream"})
    @Transaction
    public Response get(final @PathParam(value="sessionId") UUID sessionId, @Context SecurityContext sc) throws IOException, RestException {
        StaticCredentials credentials = this.getUserCredentials(sc);
        final RestFileBrokerClient fileBroker = new RestFileBrokerClient(this.serviceLocator, (CredentialsProvider)credentials);
        SessionDbClient sessionDb = new SessionDbClient(this.serviceLocator, credentials);
        ArrayList<InputStreamEntry> entries = new ArrayList<InputStreamEntry>();
        Session session = sessionDb.getSession(sessionId);
        String sessionJson = RestUtils.asJson(session, true);
        String datasetsJson = RestUtils.asJson(sessionDb.getDatasets(sessionId).values(), true);
        String jobsJson = RestUtils.asJson(sessionDb.getJobs(sessionId).values(), true);
        entries.add(new InputStreamEntry(SESSION_JSON, sessionJson));
        entries.add(new InputStreamEntry(DATASETS_JSON, datasetsJson));
        entries.add(new InputStreamEntry(JOBS_JSON, jobsJson));
        for (final Dataset dataset : sessionDb.getSession(sessionId).getDatasets().values()) {
            entries.add(new InputStreamEntry(dataset.getDatasetId().toString(), new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    return fileBroker.download(sessionId, dataset.getDatasetId());
                }
            }, this.getCompressionLevel(dataset.getName())));
        }
        Response.ResponseBuilder response = Response.ok((Object)this.getZipStreamingOuput(entries));
        RestUtils.configureForDownload(response, session.getName() + ".zip");
        return response.build();
    }

    private int getCompressionLevel(String name) {
        for (String extension : compressedExtensions) {
            if (!name.endsWith(extension)) continue;
            return 0;
        }
        return 1;
    }

    private StreamingOutput getZipStreamingOuput(final ArrayList<InputStreamEntry> entries) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(output, 0x200000));){
                    for (InputStreamEntry entry : entries) {
                        zos.putNextEntry(new ZipEntry(entry.getName()));
                        zos.setLevel(entry.getCompressionLevel());
                        try (InputStream entryStream = entry.getInputStreamCallable().call();){
                            IOUtils.copy((InputStream)entryStream, (OutputStream)zos);
                        }
                        zos.closeEntry();
                    }
                }
                catch (Exception e) {
                    logger.error("error in copyin dataset input stream to zip output stream", (Throwable)e);
                    throw new InternalServerErrorException("error in copyin dataset input stream to zip output stream");
                }
            }
        };
    }

    private static Callable<InputStream> toCallable(final String str) {
        return new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return IOUtils.toInputStream((String)str);
            }
        };
    }

    public SessionWorkerResource(ServiceLocatorClient serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{sessionId}/datasets/{datasetId}")
    @Transaction
    public Response post(@PathParam(value="sessionId") UUID sessionId, @PathParam(value="datasetId") UUID zipDatasetId, @Context SecurityContext sc) throws RestException, IOException {
        UUID newId;
        UUID oldId;
        StaticCredentials credentials = this.getUserCredentials(sc);
        RestFileBrokerClient fileBroker = new RestFileBrokerClient(this.serviceLocator, (CredentialsProvider)credentials);
        SessionDbClient sessionDb = new SessionDbClient(this.serviceLocator, credentials);
        HashMap<UUID, UUID> datasetIdMap = new HashMap<UUID, UUID>();
        HashMap<UUID, UUID> jobIdMap = new HashMap<UUID, UUID>();
        Session session = null;
        List datasets = null;
        List jobs = null;
        ArrayList<String> warnings = new ArrayList<String>();
        try (Iterator zipInputStream = new ZipInputStream(fileBroker.download(sessionId, zipDatasetId));){
            ZipEntry entry;
            while ((entry = ((ZipInputStream)((Object)zipInputStream)).getNextEntry()) != null) {
                if (entry.getName().equals(SESSION_JSON)) {
                    session = RestUtils.parseJson(Session.class, IOUtils.toString((InputStream)((Object)zipInputStream)));
                    continue;
                }
                if (entry.getName().equals(DATASETS_JSON)) {
                    datasets = RestUtils.parseJson(List.class, Dataset.class, IOUtils.toString((InputStream)((Object)zipInputStream)));
                    continue;
                }
                if (entry.getName().equals(JOBS_JSON)) {
                    jobs = RestUtils.parseJson(List.class, Job.class, IOUtils.toString(zipInputStream));
                    continue;
                }
                UUID datasetId = sessionDb.createDataset(sessionId, new Dataset());
                datasetIdMap.put(UUID.fromString(entry.getName()), datasetId);
                fileBroker.upload(sessionId, datasetId, new NonClosableInputStream((InputStream)((Object)zipInputStream)));
            }
        }
        session.setSessionId(sessionId);
        sessionDb.updateSession(session);
        for (Job job : jobs) {
            oldId = job.getJobId();
            job.setJobId(null);
            for (Input input : job.getInputs()) {
                UUID newDatasetId = (UUID)datasetIdMap.get(UUID.fromString(input.getDatasetId()));
                if (input.getDatasetId() != null && newDatasetId == null) {
                    warnings.add("input dataset of job " + job.getToolId() + " " + input.getInputId() + " missing");
                    continue;
                }
                input.setDatasetId(newDatasetId.toString());
            }
            newId = sessionDb.createJob(sessionId, job);
            jobIdMap.put(oldId, newId);
        }
        for (Dataset dataset : datasets) {
            oldId = dataset.getDatasetId();
            newId = (UUID)datasetIdMap.get(oldId);
            if (newId == null) {
                warnings.add("dataset " + dataset.getName() + " missing");
            }
            dataset.setDatasetId(newId);
            UUID newSourceJobId = (UUID)jobIdMap.get(dataset.getSourceJob());
            if (dataset.getSourceJob() != null && newSourceJobId == null) {
                warnings.add("source job of dataset " + dataset.getName() + " missing");
            }
            dataset.setSourceJob(newSourceJobId);
            dataset.setFile(null);
            sessionDb.updateDataset(sessionId, dataset);
        }
        HashMap<String, ArrayList<String>> output = new HashMap<String, ArrayList<String>>();
        output.put("warnings", warnings);
        return Response.ok(output).build();
    }

    private StaticCredentials getUserCredentials(SecurityContext sc) {
        String token = ((AuthPrincipal)sc.getUserPrincipal()).getTokenKey();
        return new StaticCredentials("token", token);
    }

    class NonClosableInputStream
    extends InputStream {
        private InputStream in;

        public NonClosableInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public void close() throws IOException {
            logger.debug("zip input stream close ignored");
        }

        public void closeForReal() throws IOException {
            this.in.close();
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.in.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }
    }

    public static class InputStreamEntry {
        private String name;
        private Callable<InputStream> inputStreamCallable;
        private int compressionLevel;

        public InputStreamEntry(String name, String content) {
            this(name, SessionWorkerResource.toCallable(content));
        }

        public InputStreamEntry(String name, Callable<InputStream> inputStreamCallable) {
            this(name, inputStreamCallable, 1);
        }

        public InputStreamEntry(String name, Callable<InputStream> inputStreamCallable, int compressionLevel) {
            this.name = name;
            this.inputStreamCallable = inputStreamCallable;
            this.compressionLevel = compressionLevel;
        }

        public int getCompressionLevel() {
            return this.compressionLevel;
        }

        public void setCompressionLevel(int compressionLevel) {
            this.compressionLevel = compressionLevel;
        }

        public Callable<InputStream> getInputStreamCallable() {
            return this.inputStreamCallable;
        }

        public void setInputStreamCallable(Callable<InputStream> inputStreamCallable) {
            this.inputStreamCallable = inputStreamCallable;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

