/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.rest.CredentialsProvider;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.websocket.WebSocketClient;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.model.Authorization;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessiondb.model.SessionEvent;
import fi.csc.chipster.sessiondb.model.TableStats;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import javax.websocket.MessageHandler;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionDbClient {
    private static final Logger logger = LogManager.getLogger();
    private ServiceLocatorClient serviceLocator;
    private List<String> sessionDbList;
    private List<String> sessionDbEventsList;
    private CredentialsProvider credentials;
    private WebSocketClient client;
    private WebTarget sessionDbTarget;
    private String sessionDbEventsUri;

    public SessionDbClient(ServiceLocatorClient serviceLocator, CredentialsProvider credentials) {
        this.serviceLocator = serviceLocator;
        this.credentials = credentials;
        this.sessionDbList = serviceLocator.get("session-db");
        this.sessionDbEventsList = serviceLocator.get("session-db-events");
        if (this.sessionDbList.isEmpty()) {
            throw new InternalServerErrorException("no session-dbs registered to service-locator");
        }
        if (this.sessionDbEventsList.isEmpty()) {
            throw new InternalServerErrorException("no session-db-events registered to service-locator");
        }
        this.init(this.sessionDbList.get(0), this.sessionDbEventsList.get(0));
    }

    public SessionDbClient(String sessionDbUri, String sessionDbEventsUri, CredentialsProvider credentials) {
        this.credentials = credentials;
        this.init(sessionDbUri, sessionDbEventsUri);
    }

    private void init(String sessionDbUri, String sessionDbEventsUri) {
        this.sessionDbTarget = this.credentials != null ? AuthenticationClient.getClient(this.credentials.getUsername(), this.credentials.getPassword(), true).target(sessionDbUri) : AuthenticationClient.getClient().target(sessionDbUri);
        this.sessionDbEventsUri = sessionDbEventsUri;
    }

    public void subscribe(String topic, final SessionEventListener listener, String name) throws RestException {
        try {
            UriBuilder uriBuilder = UriBuilder.fromUri((String)this.sessionDbEventsUri).path("events").path(topic);
            if (this.credentials != null) {
                uriBuilder = uriBuilder.queryParam("token", new Object[]{this.credentials.getPassword().toString()});
            }
            this.client = new WebSocketClient(uriBuilder.toString(), new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    listener.onEvent(RestUtils.parseJson(SessionEvent.class, message));
                }
            }, true, name);
        }
        catch (WebSocketClient.WebSocketClosedException | WebSocketClient.WebSocketErrorException | InterruptedException e) {
            throw new RestException("websocket error", e);
        }
    }

    public void close() throws IOException {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    private WebTarget getSessionsTarget() {
        return this.sessionDbTarget.path("sessions");
    }

    private WebTarget getSessionTarget(UUID sessionId) {
        return this.getSessionsTarget().path(sessionId.toString());
    }

    private WebTarget getDatasetsTarget(UUID sessionId) {
        return this.getSessionTarget(sessionId).path("datasets");
    }

    private WebTarget getDatasetTarget(UUID sessionId, UUID datasetId) {
        return this.getDatasetsTarget(sessionId).path(datasetId.toString());
    }

    private WebTarget getJobsTarget(UUID sessionId) {
        return this.getSessionTarget(sessionId).path("jobs");
    }

    private WebTarget getJobTarget(UUID sessionId, UUID jobId) {
        return this.getJobsTarget(sessionId).path(jobId.toString());
    }

    private WebTarget getAuthorizationsTarget() {
        return this.sessionDbTarget.path("authorizations");
    }

    private WebTarget getAuthorizationTarget(UUID authorizationId) {
        return this.getAuthorizationsTarget().path(authorizationId.toString());
    }

    private <T> List<T> getList(WebTarget target, Class<T> type) throws RestException {
        Response response = (Response)target.request().get(Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new RestException("get a list of " + type.getSimpleName() + " failed ", response, target.getUri());
        }
        String json = (String)response.readEntity(String.class);
        return RestUtils.parseJson(List.class, type, json);
    }

    private <T> T get(WebTarget target, Class<T> type) throws RestException {
        Response response = (Response)target.request().get(Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new RestException("get " + type.getSimpleName() + " failed ", response, target.getUri());
        }
        return (T)response.readEntity(type);
    }

    private UUID post(WebTarget target, Object obj) throws RestException {
        Response response = (Response)target.request().post(Entity.entity((Object)obj, (String)"application/json"), Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new RestException("post " + obj.getClass().getSimpleName() + " failed ", response, target.getUri());
        }
        return UUID.fromString(RestUtils.basename(response.getLocation().getPath()));
    }

    private Response put(WebTarget target, Object obj) throws RestException {
        Response response = (Response)target.request().put(Entity.entity((Object)obj, (String)"application/json"), Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new RestException("put " + obj.getClass().getSimpleName() + " failed ", response, target.getUri());
        }
        return response;
    }

    private void delete(WebTarget target) throws RestException {
        Response response = (Response)target.request().delete(Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new RestException("delete failed ", response, target.getUri());
        }
    }

    public HashMap<UUID, Session> getSessions() throws RestException {
        List<Session> sessionList = this.getList(this.getSessionsTarget(), Session.class);
        HashMap<UUID, Session> map = new HashMap<UUID, Session>();
        for (Session session : sessionList) {
            map.put(session.getSessionId(), session);
        }
        return map;
    }

    public Session getSession(UUID sessionId) throws RestException {
        Session session = this.get(this.getSessionTarget(sessionId), Session.class);
        HashMap<UUID, Dataset> datasets = this.getDatasets(sessionId);
        HashMap<UUID, Job> jobs = this.getJobs(sessionId);
        session.setDatasets(datasets);
        session.setJobs(jobs);
        return session;
    }

    public UUID createSession(Session session) throws RestException {
        UUID id = this.post(this.getSessionsTarget(), session);
        session.setSessionId(id);
        return id;
    }

    public void updateSession(Session session) throws RestException {
        this.put(this.getSessionTarget(session.getSessionId()), session);
    }

    public void deleteSession(UUID sessionId) throws RestException {
        this.delete(this.getSessionTarget(sessionId));
    }

    public HashMap<UUID, Dataset> getDatasets(UUID sessionId) throws RestException {
        List<Dataset> datasetList = this.getList(this.getDatasetsTarget(sessionId), Dataset.class);
        HashMap<UUID, Dataset> datasetMap = new HashMap<UUID, Dataset>();
        for (Dataset dataset : datasetList) {
            datasetMap.put(dataset.getDatasetId(), dataset);
        }
        return datasetMap;
    }

    public Dataset getDataset(UUID sessionId, UUID datasetId) throws RestException {
        return this.get(this.getDatasetTarget(sessionId, datasetId), Dataset.class);
    }

    public Dataset getDataset(String username, UUID sessionId, UUID datasetId, boolean requireReadWrite) throws RestException {
        try {
            int status = ((Response)this.sessionDbTarget.path("authorizations").queryParam("session-id", new Object[]{sessionId}).queryParam("username", new Object[]{username}).queryParam("read-write", new Object[]{requireReadWrite}).request().get(Response.class)).getStatus();
            if (RestUtils.isSuccessful(status)) {
                return this.getDataset(sessionId, datasetId);
            }
            return null;
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (RestException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw e;
        }
        catch (WebApplicationException e) {
            logger.error("failed to get the dataset " + this.sessionDbTarget.getUri() + " " + ((Object)((Object)e)).getClass().getName() + ": " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public UUID createDataset(UUID sessionId, Dataset dataset) throws RestException {
        UUID id = this.post(this.getDatasetsTarget(sessionId), dataset);
        dataset.setDatasetId(id);
        return id;
    }

    public Response updateDataset(UUID sessionId, Dataset dataset) throws RestException {
        return this.put(this.getDatasetTarget(sessionId, dataset.getDatasetId()), dataset);
    }

    public void deleteDataset(UUID sessionId, UUID datasetId) throws RestException {
        this.delete(this.getDatasetTarget(sessionId, datasetId));
    }

    public HashMap<UUID, Job> getJobs(UUID sessionId) throws RestException {
        List<Job> jobsList = this.getList(this.getJobsTarget(sessionId), Job.class);
        HashMap<UUID, Job> jobMap = new HashMap<UUID, Job>();
        for (Job job : jobsList) {
            jobMap.put(job.getJobId(), job);
        }
        return jobMap;
    }

    public Job getJob(UUID sessionId, UUID jobId) throws RestException {
        return this.get(this.getJobTarget(sessionId, jobId), Job.class);
    }

    public UUID createJob(UUID sessionId, Job job) throws RestException {
        UUID id = this.post(this.getJobsTarget(sessionId), job);
        job.setJobId(id);
        return id;
    }

    public void updateJob(UUID sessionId, Job job) throws RestException {
        this.put(this.getJobTarget(sessionId, job.getJobId()), job);
    }

    public void deleteJob(UUID sessionId, UUID jobId) throws RestException {
        this.delete(this.getJobTarget(sessionId, jobId));
    }

    public Authorization getAuthorization(UUID authorizationId) throws RestException {
        return this.get(this.getAuthorizationTarget(authorizationId), Authorization.class);
    }

    public Iterator<Authorization> getAuthorizations() throws RestException, JsonParseException, IOException {
        InputStream inStream = this.get(this.getAuthorizationsTarget(), InputStream.class);
        JsonFactory factory = RestUtils.getObjectMapper().getFactory();
        final JsonParser parser = factory.createParser(inStream);
        JsonToken token = parser.nextToken();
        if (token == null) {
            throw new RestException("failed to get authorizations: empty response");
        }
        if (!JsonToken.START_ARRAY.equals((Object)token)) {
            throw new RestException("failed to get authorizations: not an array");
        }
        return new Iterator<Authorization>(){
            private Authorization next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        JsonToken token2 = parser.nextToken();
                        if (!JsonToken.START_OBJECT.equals((Object)token2)) {
                            return false;
                        }
                        if (token2 == null) {
                            return false;
                        }
                        this.next = (Authorization)parser.readValueAs(Authorization.class);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("failed to get authorizations", e);
                    }
                }
                return this.next != null;
            }

            @Override
            public Authorization next() {
                if (this.hasNext()) {
                    Authorization current = this.next;
                    this.next = null;
                    return current;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public List<TableStats> getTableStats() throws RestException {
        List<TableStats> tables = this.getList(this.sessionDbTarget.path("admin").path("tables"), TableStats.class);
        return tables;
    }

    public static interface SessionEventListener {
        public void onEvent(SessionEvent var1);
    }
}

