/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.exception.NotAuthorizedException;
import fi.csc.chipster.rest.hibernate.HibernateRequestFilter;
import fi.csc.chipster.rest.hibernate.HibernateResponseFilter;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.token.TokenRequestFilter;
import fi.csc.chipster.rest.websocket.PubSubServer;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.SessionDbCluster;
import fi.csc.chipster.sessiondb.model.Authorization;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.File;
import fi.csc.chipster.sessiondb.model.Input;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.MetadataEntry;
import fi.csc.chipster.sessiondb.model.Parameter;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessiondb.resource.AuthorizationResource;
import fi.csc.chipster.sessiondb.resource.SessionDbAdminResource;
import fi.csc.chipster.sessiondb.resource.SessionResource;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class SessionDb
implements PubSubServer.TopicCheck {
    private Logger logger = LogManager.getLogger();
    public static final String EVENTS_PATH = "events";
    public static final String JOBS_TOPIC = "jobs";
    public static final String FILES_TOPIC = "files";
    public static final String AUTHORIZATIONS_TOPIC = "authorizations";
    public static final String DATASETS_TOPIC = "datasets";
    public static final String SESSIONS_TOPIC = "sessions";
    private static HibernateUtil hibernate;
    private String serviceId;
    private ServiceLocatorClient serviceLocator;
    private AuthenticationClient authService;
    private Config config;
    private HttpServer httpServer;
    private PubSubServer pubSubServer;
    private SessionResource sessionResource;
    private AuthorizationResource authorizationResource;
    private SessionDbAdminResource adminResource;

    public SessionDb(Config config) {
        this.config = config;
    }

    public void startServer() throws ServletException, DeploymentException, RestException, IOException {
        String username = "session-db";
        String password = this.config.getPassword(username);
        this.serviceLocator = new ServiceLocatorClient(this.config);
        this.authService = new AuthenticationClient(this.serviceLocator, username, password);
        List<Class<?>> hibernateClasses = Arrays.asList(Authorization.class, Session.class, Dataset.class, MetadataEntry.class, Job.class, Parameter.class, Input.class, File.class);
        boolean replicate = this.config.getBoolean("session-db-replicate");
        String hibernateSchema = this.config.getString("session-db-hibernate-schema");
        if (replicate) {
            hibernateSchema = "create";
        }
        hibernate = new HibernateUtil(hibernateSchema);
        hibernate.buildSessionFactory(hibernateClasses, this.config.getString("session-db-name"));
        this.authorizationResource = new AuthorizationResource(hibernate);
        this.sessionResource = new SessionResource(hibernate, this.authorizationResource);
        this.adminResource = new SessionDbAdminResource(hibernate);
        if (replicate) {
            new SessionDbCluster().replicate(this.serviceLocator, this.authService, this.authorizationResource, this.sessionResource, this.adminResource, hibernate, this);
        }
        String pubSubUri = this.config.getString("session-db-events-bind");
        String path = "events/{topic-name}";
        this.pubSubServer = new PubSubServer(pubSubUri, path, this.authService, null, this, "session-db-events");
        this.pubSubServer.start();
        this.sessionResource.setPubSubServer(this.pubSubServer);
        ResourceConfig rc = RestUtils.getDefaultResourceConfig().register((Object)this.authorizationResource).register((Object)this.sessionResource).register((Object)this.adminResource).register((Object)new HibernateRequestFilter(hibernate)).register((Object)new HibernateResponseFilter(hibernate)).register((Object)new TokenRequestFilter(this.authService));
        URI baseUri = URI.create(this.config.getString("session-db-bind"));
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)baseUri, (ResourceConfig)rc);
    }

    public PubSubServer getPubSubServer() {
        return this.pubSubServer;
    }

    public static void main(String[] args) throws IOException, ServletException, DeploymentException, RestException {
        SessionDb server = new SessionDb(new Config());
        server.startServer();
        RestUtils.waitForShutdown("session-db", server.getHttpServer());
        hibernate.getSessionFactory().close();
    }

    public static HibernateUtil getHibernate() {
        return hibernate;
    }

    public void close() {
        this.getPubSubServer().stop();
        RestUtils.shutdown("session-db", this.httpServer);
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    @Override
    public boolean isAuthorized(final AuthPrincipal principal, String topic) {
        this.logger.debug("check topic authorization for topic " + topic);
        if (JOBS_TOPIC.equals(topic) || FILES_TOPIC.equals(topic)) {
            return principal.getRoles().contains("server");
        }
        if (DATASETS_TOPIC.equals(topic) || AUTHORIZATIONS_TOPIC.equals(topic) || SESSIONS_TOPIC.equals(topic)) {
            return principal.getRoles().contains("session-db");
        }
        final UUID sessionId = UUID.fromString(topic);
        Boolean isAuthorized = hibernate.runInTransaction(new HibernateUtil.HibernateRunnable<Boolean>(){

            @Override
            public Boolean run(org.hibernate.Session hibernateSession) {
                try {
                    Authorization auth = SessionDb.this.sessionResource.getAuthorizationResource().checkAuthorization(principal.getName(), sessionId, false, hibernateSession);
                    return auth != null;
                }
                catch (NotAuthorizedException | ForbiddenException | NotFoundException e) {
                    return false;
                }
            }
        });
        return isAuthorized;
    }
}

