/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.servicelocator;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.servicelocator.resource.Service;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServiceLocatorClient {
    private static final Logger logger = LogManager.getLogger();
    private String baseUri;

    public ServiceLocatorClient(Config config) throws IOException {
        this.baseUri = config.getString("service-locator");
        logger.info("get services from " + this.baseUri);
    }

    public List<String> get(String role) {
        ArrayList<String> uriList = new ArrayList<String>();
        List<Service> services = this.getServices(role);
        for (Service service : services) {
            if (!role.equals(service.getRole())) continue;
            uriList.add(service.getUri());
        }
        return uriList;
    }

    public List<Service> getServices(String role) {
        WebTarget serviceTarget = AuthenticationClient.getClient().target(this.baseUri).path("services");
        String servicesJson = (String)serviceTarget.request(new String[]{"application/json"}).get(String.class);
        List services = RestUtils.parseJson(List.class, Service.class, servicesJson);
        return services;
    }
}

