/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.websocket;

import com.mchange.rmi.NotAuthorizedException;
import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.token.PubSubTokenServletFilter;
import fi.csc.chipster.rest.websocket.PubSubEndpoint;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;

public class PubSubServer {
    private static final Logger logger = LogManager.getLogger();
    public static final String DEFAULT_TOPIC = "default-topic";
    ConcurrentHashMap<String, Topic> topics = new ConcurrentHashMap();
    private MessageHandler.Whole<String> replyHandler;
    private Server server;
    private String baseUri;
    private String path;
    private AuthenticationClient authService;
    private TopicCheck topicAuthorization;
    private String name;

    public PubSubServer(String baseUri, String path, AuthenticationClient authService, MessageHandler.Whole<String> replyHandler, TopicCheck topicCheck, String name) throws ServletException, DeploymentException {
        this.baseUri = baseUri;
        this.path = path;
        this.authService = authService;
        this.replyHandler = replyHandler;
        this.topicAuthorization = topicCheck;
        this.name = name;
        this.init();
    }

    public void init() throws DeploymentException, ServletException {
        this.server = new Server();
        URI uri = URI.create(this.baseUri);
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost(uri.getHost());
        connector.setPort(uri.getPort());
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler(1);
        String contextPath = uri.getPath().replaceAll("/$", "");
        if (contextPath.isEmpty()) {
            contextPath = "/";
        }
        logger.debug("context path " + contextPath);
        context.setContextPath(contextPath);
        PubSubTokenServletFilter filter = new PubSubTokenServletFilter(this.authService, this.topicAuthorization, contextPath + this.path);
        context.addFilter(new FilterHolder((Filter)filter), "/*", null);
        this.server.setHandler((Handler)context);
        ServerContainer wscontainer = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)context);
        ServerEndpointConfig serverConfig = ServerEndpointConfig.Builder.create(PubSubEndpoint.class, (String)("/" + this.path)).build();
        serverConfig.getUserProperties().put(this.getClass().getName(), this);
        wscontainer.addEndpoint(serverConfig);
    }

    public void publish(Object obj) {
        this.publish(DEFAULT_TOPIC, RestUtils.asJson(obj));
    }

    public void publish(String topic, Object obj) {
        this.publish(topic, RestUtils.asJson(obj));
    }

    private void publish(String topicName, String msg) {
        Topic topic = this.topics.get(topicName);
        if (topic != null) {
            topic.publish(msg);
        } else {
            logger.debug("no one listening on topic: " + topicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String topicName, Subscriber s) {
        if (topicName == null) {
            topicName = DEFAULT_TOPIC;
        }
        ConcurrentHashMap<String, Topic> concurrentHashMap = this.topics;
        synchronized (concurrentHashMap) {
            if (!this.topics.containsKey(topicName)) {
                logger.debug("topic " + topicName + " not found, create it");
                this.topics.put(topicName, new Topic());
            }
            Topic topic = this.topics.get(topicName);
            topic.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String topicName, RemoteEndpoint.Basic basicRemote) {
        if (topicName == null) {
            topicName = DEFAULT_TOPIC;
        }
        ConcurrentHashMap<String, Topic> concurrentHashMap = this.topics;
        synchronized (concurrentHashMap) {
            Topic topic = this.topics.get(topicName);
            topic.remove(basicRemote);
            if (topic.isEmpty()) {
                logger.debug("topic " + topicName + " is empty, remove it");
                this.topics.remove(topicName);
            }
        }
    }

    public MessageHandler.Whole<String> getMessageHandler() {
        return this.replyHandler;
    }

    public void stop() {
        try {
            this.server.stop();
            logger.info("stopped a pub-sub server: " + this.name);
        }
        catch (Exception e) {
            logger.warn("failed to stop the pub-sub server", (Throwable)e);
        }
    }

    public void start() {
        try {
            logger.debug("start a pub-sub server: " + this.name);
            this.server.start();
        }
        catch (Exception e) {
            logger.error("failed to start PubSubServer", (Throwable)e);
        }
    }

    public boolean isTopicAuthorized(AuthPrincipal principal, String topic) throws NotAuthorizedException {
        if (this.topicAuthorization != null) {
            return this.topicAuthorization.isAuthorized(principal, topic);
        }
        return true;
    }

    public static interface TopicCheck {
        public boolean isAuthorized(AuthPrincipal var1, String var2);
    }

    public static class Topic {
        private ConcurrentHashMap<RemoteEndpoint.Basic, Subscriber> subscribers = new ConcurrentHashMap();

        public void add(Subscriber s) {
            this.subscribers.put(s.remote, s);
            logger.debug("subscribers: " + this.subscribers.size());
        }

        public void remove(RemoteEndpoint.Basic basicRemote) {
            this.subscribers.remove(basicRemote);
        }

        public boolean isEmpty() {
            return this.subscribers.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(String msg) {
            Topic topic = this;
            synchronized (topic) {
                logger.debug("publish to " + this.subscribers.size() + " subscribers: " + msg);
                for (Subscriber s : this.subscribers.values()) {
                    try {
                        logger.debug("send to " + s.remoteAddress);
                        s.getRemote().sendText(msg);
                    }
                    catch (IOException e) {
                        logger.warn("failed to publish a message to: " + this.subscribers.get(s.getRemoteAddress()), (Throwable)e);
                    }
                }
            }
        }
    }

    public static class Subscriber {
        private RemoteEndpoint.Basic remote;
        private String remoteAddress;

        public Subscriber(RemoteEndpoint.Basic remote, String remoteAddress) {
            this.remote = remote;
            this.remoteAddress = remoteAddress;
        }

        public RemoteEndpoint.Basic getRemote() {
            return this.remote;
        }

        public void setRemote(RemoteEndpoint.Basic remote) {
            this.remote = remote;
        }

        public String getRemoteAddress() {
            return this.remoteAddress;
        }

        public void setRemoteAddress(String remoteAddress) {
            this.remoteAddress = remoteAddress;
        }
    }
}

