/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.websocket;

import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.rest.websocket.PubSubServer;
import java.io.IOException;
import java.net.SocketTimeoutException;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PubSubEndpoint
extends Endpoint {
    public static final Logger logger = LogManager.getLogger();
    public static final String TOPIC_KEY = "topic-name";

    public void onOpen(Session session, EndpointConfig config) {
        String topic = (String)session.getPathParameters().get(TOPIC_KEY);
        try {
            boolean isAuthorized = this.getServer(session).isTopicAuthorized((AuthPrincipal)session.getUserPrincipal(), topic);
            if (!isAuthorized) {
                this.close(session, CloseReason.CloseCodes.VIOLATED_POLICY, "access denied");
                return;
            }
        }
        catch (Exception e) {
            logger.error("error in topic authorization check", (Throwable)e);
            this.close(session, CloseReason.CloseCodes.UNEXPECTED_CONDITION, "internal server error");
            return;
        }
        session.getUserProperties().put(TOPIC_KEY, topic);
        this.getServer(session).subscribe(topic, new PubSubServer.Subscriber(session.getBasicRemote(), this.getRemoteAddress(session)));
        MessageHandler.Whole<String> messageHandler = this.getServer(session).getMessageHandler();
        if (messageHandler != null) {
            session.addMessageHandler(messageHandler);
        }
    }

    private String getRemoteAddress(Session session) {
        return session.getUserProperties().get("javax.websocket.endpoint.remoteAddress").toString();
    }

    private void close(Session session, CloseReason.CloseCodes closeCode, String reason) {
        try {
            session.close(new CloseReason((CloseReason.CloseCode)closeCode, reason));
        }
        catch (IOException ex) {
            logger.error("failed to close websocket", (Throwable)ex);
        }
    }

    private PubSubServer getServer(Session session) {
        return (PubSubServer)session.getUserProperties().get(PubSubServer.class.getName());
    }

    private void unsubscribe(Session session) {
        String topic = (String)session.getUserProperties().get(TOPIC_KEY);
        this.getServer(session).unsubscribe(topic, session.getBasicRemote());
    }

    public void onClose(Session session, CloseReason closeReason) {
        logger.debug("client has closed the websocket: " + closeReason.getReasonPhrase());
        this.unsubscribe(session);
    }

    public void onError(Session session, Throwable thr) {
        if (thr instanceof SocketTimeoutException) {
            logger.warn("idle timeout, unsubscribe a pub-sub client " + this.getRemoteAddress(session));
        } else {
            logger.error("websocket error", thr);
        }
        this.unsubscribe(session);
    }
}

