/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.token;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.auth.model.Token;
import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.auth.resource.AuthSecurityContext;
import fi.csc.chipster.rest.exception.NotAuthorizedException;
import fi.csc.chipster.rest.token.BasicAuthParser;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.annotation.Priority;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=1000)
public class TokenRequestFilter
implements ContainerRequestFilter {
    public static final String QUERY_PARAMETER_TOKEN = "token";
    public static final String HEADER_AUTHORIZATION = "authorization";
    public static final String TOKEN_USER = "token";
    private static final int CACHE_MAX_SIZE = 1000;
    private LinkedHashMap<String, Token> tokenCache = new LinkedHashMap();
    private boolean authenticationRequired = true;
    private AuthenticationClient authService;

    public TokenRequestFilter(AuthenticationClient authService) {
        this.authService = authService;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String authParameter;
        if ("OPTIONS".equals(requestContext.getMethod())) {
            return;
        }
        String authHeader = requestContext.getHeaderString(HEADER_AUTHORIZATION);
        String password = this.getToken(authHeader, authParameter = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"token"));
        if (password == null && !this.authenticationRequired) {
            requestContext.setSecurityContext((SecurityContext)new AuthSecurityContext(new AuthPrincipal(null, "unauthenticated"), requestContext.getSecurityContext()));
            return;
        }
        AuthPrincipal principal = this.tokenAuthentication(password);
        requestContext.setSecurityContext((SecurityContext)new AuthSecurityContext(principal, requestContext.getSecurityContext()));
    }

    public String getToken(String authHeader, String authParameter) {
        if (authHeader != null) {
            BasicAuthParser parser = new BasicAuthParser(authHeader);
            if (!"token".equals(parser.getUsername())) {
                throw new NotAuthorizedException("only tokens allowed");
            }
            return parser.getPassword();
        }
        return authParameter;
    }

    public AuthPrincipal tokenAuthentication(String clientTokenKey) {
        if (clientTokenKey == null) {
            throw new NotAuthorizedException("no authorization header");
        }
        Token dbClientToken = null;
        if (this.tokenCache.containsKey(clientTokenKey)) {
            dbClientToken = this.tokenCache.get(clientTokenKey);
        } else {
            dbClientToken = this.authService.getDbToken(clientTokenKey);
            if (dbClientToken == null) {
                throw new ForbiddenException("token not found");
            }
            this.tokenCache.put(clientTokenKey, dbClientToken);
            Iterator<String> iter = this.tokenCache.keySet().iterator();
            while (this.tokenCache.size() > 1000) {
                iter.remove();
            }
        }
        if (dbClientToken.getValid().isBefore(LocalDateTime.now())) {
            throw new ForbiddenException();
        }
        return new AuthPrincipal(dbClientToken.getUsername(), clientTokenKey, dbClientToken.getRoles());
    }

    public void authenticationRequired(boolean authenticationRequired) {
        this.authenticationRequired = authenticationRequired;
    }
}

