/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.token;

import fi.csc.chipster.rest.exception.NotAuthorizedException;
import javax.xml.bind.DatatypeConverter;

public class BasicAuthParser {
    private String username;
    private String password;

    public BasicAuthParser(String auth) {
        auth = auth.replaceFirst("[B|b]asic ", "");
        byte[] decodedBytes = DatatypeConverter.parseBase64Binary((String)auth);
        if (decodedBytes == null || decodedBytes.length == 0) {
            throw new NotAuthorizedException("authorization header is null or empty");
        }
        String[] credentials = new String(decodedBytes).split(":", 2);
        if (credentials == null || credentials.length != 2) {
            throw new NotAuthorizedException("username or password missing");
        }
        this.setUsername(credentials[0]);
        this.setPassword(credentials[1]);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

