/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.hibernate;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.service.ServiceRegistry;

public class HibernateUtil {
    private static Logger logger = LogManager.getLogger();
    private SessionFactory sessionFactory;
    private String schema;

    public HibernateUtil(String schema) {
        this.schema = schema;
    }

    public void buildSessionFactory(List<Class<?>> hibernateClasses, String dbName) {
        try {
            Configuration hibernateConf = new Configuration();
            String dbDriver = "org.h2.Driver";
            String dbUrl = "jdbc:h2:database/" + dbName;
            String dbUsername = "sa";
            String dbPassword = "";
            hibernateConf.setProperty("hibernate.connection.driver_class", dbDriver);
            hibernateConf.setProperty("hibernate.connection.url", dbUrl);
            hibernateConf.setProperty("hibernate.connection.username", dbUsername);
            hibernateConf.setProperty("hibernate.connection.password", dbPassword);
            hibernateConf.setProperty("hibernate.dialect", H2Dialect.class.getName());
            hibernateConf.setProperty("hibernate.show_sql", "false");
            hibernateConf.setProperty("hibernate.current_session_context_class", "thread");
            hibernateConf.setProperty("hibernate.c3p0.min_size", "3");
            hibernateConf.setProperty("hibernate.hbm2ddl.auto", this.schema);
            for (Class<?> c : hibernateClasses) {
                hibernateConf.addAnnotatedClass(c);
            }
            this.sessionFactory = hibernateConf.buildSessionFactory((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)hibernateConf.getProperties()).build());
        }
        catch (Throwable ex) {
            logger.error("sessionFactory creation failed.", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Session beginTransaction() {
        Session session = this.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        return session;
    }

    public void commit() {
        this.getSessionFactory().getCurrentSession().getTransaction().commit();
    }

    public void rollback() {
        this.getSessionFactory().getCurrentSession().getTransaction().rollback();
    }

    public Session session() {
        return this.getSessionFactory().getCurrentSession();
    }

    public void rollbackIfActive() {
        if (this.session().getTransaction().getStatus().canRollback()) {
            this.session().getTransaction().rollback();
        }
    }

    public <T> T runInTransaction(HibernateRunnable<T> runnable) {
        T returnObj = null;
        Session session = this.getSessionFactory().openSession();
        Transaction transaction = session.beginTransaction();
        try {
            returnObj = runnable.run(session);
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            logger.error("transaction failed", (Throwable)e);
        }
        session.close();
        return returnObj;
    }

    public static interface HibernateRunnable<T> {
        public T run(Session var1);
    }
}

