/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.proxy;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.proxy.ChipsterProxyAdminResource;
import fi.csc.chipster.proxy.ProxyServer;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.token.TokenRequestFilter;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class ChipsterProxyServer {
    private final Logger logger = LogManager.getLogger();
    private ProxyServer proxy;
    private ServiceLocatorClient serviceLocator;
    private AuthenticationClient authService;
    private String serviceId;
    private HttpServer restServer;
    private Config config;
    private ChipsterProxyAdminResource adminResource;

    public static void main(String[] args) throws IOException {
        ChipsterProxyServer server = new ChipsterProxyServer(new Config());
        server.startServer();
        RestUtils.waitForShutdown("proxy", null);
        server.close();
    }

    public ChipsterProxyServer(Config config) {
        this.config = config;
        try {
            this.proxy = new ProxyServer(URI.create(config.getString("proxy-bind")));
            this.proxy.addRoute("sessiondb", config.getString("session-db"));
            this.proxy.addRoute("sessiondbevents", config.getString("session-db-events"));
            this.proxy.addRoute("auth", config.getString("authentication-service"));
            this.proxy.addRoute("filebroker", config.getString("file-broker"));
            this.proxy.addRoute("toolbox", config.getString("toolbox-url"));
        }
        catch (IOException | URISyntaxException e) {
            this.logger.error("proxy configuration error", (Throwable)e);
        }
    }

    private void startAdminAPI() throws IOException {
        String username = "proxy";
        String password = this.config.getPassword(username);
        this.serviceLocator = new ServiceLocatorClient(this.config);
        this.authService = new AuthenticationClient(this.serviceLocator, username, password);
        this.adminResource = new ChipsterProxyAdminResource(this.proxy);
        ResourceConfig rc = RestUtils.getDefaultResourceConfig().register((Object)new TokenRequestFilter(this.authService)).register((Object)this.adminResource);
        this.restServer = GrizzlyHttpServerFactory.createHttpServer((URI)this.config.getURI("proxy-admin-bind"), (ResourceConfig)rc);
    }

    public void startServer() throws IOException {
        this.proxy.startServer();
        this.startAdminAPI();
    }

    public void close() {
        RestUtils.shutdown("proxy-admin", this.restServer);
        this.proxy.close();
    }
}

