/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.filebroker;

import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.exception.ConflictException;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.SessionDbClient;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.SessionEvent;
import fi.csc.microarray.util.IOUtils;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.servlet.DefaultServlet;

public class FileServlet
extends DefaultServlet
implements SessionDbClient.SessionEventListener {
    private static final Logger logger = LogManager.getLogger();
    private boolean logRest = false;
    private File storageRoot;
    private SessionDbClient sessionDbClient;

    public FileServlet(File storageRoot, SessionDbClient sessionDbClient) {
        this.storageRoot = storageRoot;
        this.sessionDbClient = sessionDbClient;
        this.logRest = true;
        logger.info("logging rest requests: " + this.logRest);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("RESTful file access: GET request for " + request.getRequestURI());
        }
        try {
            boolean download = request.getHeader("download") != null;
            boolean type = request.getHeader("type") != null;
            String username = request.getUserPrincipal().getName();
            Path path = this.parsePath(request.getPathInfo());
            Dataset dataset = this.getDataset(path.getSessionId(), path.getDatasetId(), username, false);
            if (dataset.getFile() == null || dataset.getFile().getFileId() == null) {
                throw new ForbiddenException("file id is null");
            }
            UUID fileId = dataset.getFile().getFileId();
            File f = this.getStorageFile(fileId);
            if (!f.exists()) {
                throw new ForbiddenException("no such file");
            }
            RewrittenRequest rewrittenRequest = new RewrittenRequest(request, "/" + fileId.toString());
            if (download) {
                RestUtils.configureForDownload(response, dataset.getName());
            }
            if (type) {
                response.setContentType(this.getType(dataset).toString());
            }
            LocalDateTime before = LocalDateTime.now();
            super.doGet((HttpServletRequest)rewrittenRequest, response);
            LocalDateTime after = LocalDateTime.now();
            Duration duration = Duration.between(before, after);
            double rate = this.getTransferRate(f.length(), duration);
            if (this.logRest) {
                logger.info("GET " + f.getName() + " " + "from " + request.getRemoteHost() + " | " + FileUtils.byteCountToDisplaySize((long)f.length()) + " | " + DurationFormatUtils.formatDurationHMS((long)duration.toMillis()) + " | " + new DecimalFormat("###.##").format(rate) + " MB/s");
            }
        }
        catch (RestException e) {
            throw new ServletException("failed to get the dataset", (Throwable)e);
        }
    }

    private Path parsePath(String pathInfo) {
        String[] path = pathInfo.split("/");
        if (path.length != 5) {
            throw new NotFoundException();
        }
        if (!"".equals(path[0])) {
            throw new BadRequestException("path doesn't start with slash");
        }
        if (!"sessions".equals(path[1])) {
            throw new NotFoundException(path[1] + " not found");
        }
        UUID sessionId = UUID.fromString(path[2]);
        if (!"datasets".equals(path[3])) {
            throw new NotFoundException(path[3] + " not found");
        }
        UUID datasetId = UUID.fromString(path[4]);
        return new Path(sessionId, datasetId);
    }

    private Dataset getDataset(UUID sessionId, UUID datasetId, String username, boolean requireReadWrite) throws RestException {
        Dataset dataset = this.sessionDbClient.getDataset(username, sessionId, datasetId, requireReadWrite);
        if (dataset == null) {
            throw new ForbiddenException("dataset not found");
        }
        return dataset;
    }

    private MediaType getType(Dataset dataset) {
        MediaType type = null;
        if (dataset.getName().toLowerCase().endsWith(".html")) {
            type = MediaType.TEXT_HTML_TYPE;
        }
        return type;
    }

    private File getStorageFile(UUID fileId) {
        return new File(this.storageRoot, fileId.toString());
    }

    private static Long getParameterLong(HttpServletRequest req, String key) {
        String stringValue = req.getParameter(key);
        if (stringValue != null) {
            return Long.parseLong(stringValue);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.info("PUT request for " + request.getRequestURI());
        }
        Long chunkNumber = FileServlet.getParameterLong(request, "flowChunkNumber");
        Long chunkSize = FileServlet.getParameterLong(request, "flowChunkSize");
        Long flowTotalChunks = FileServlet.getParameterLong(request, "flowTotalChunks");
        String username = request.getUserPrincipal().getName();
        UUID fileId = null;
        Dataset dataset = null;
        try {
            logger.debug("chunkNumber " + chunkNumber + " uploading");
            Path path = this.parsePath(request.getPathInfo());
            dataset = this.getDataset(path.getSessionId(), path.getDatasetId(), username, true);
            ServletInputStream inputStream = request.getInputStream();
            if (chunkNumber == null || chunkNumber == 1L) {
                if (dataset.getFile() != null) {
                    throw new ConflictException("file not null");
                }
                fileId = RestUtils.createUUID();
                File f = this.getStorageFile(fileId);
                if (f.exists()) {
                    throw new ConflictException("file exists");
                }
                try {
                    IOUtils.copy((InputStream)inputStream, (File)f);
                    fi.csc.chipster.sessiondb.model.File file = new fi.csc.chipster.sessiondb.model.File();
                    file.setFileId(fileId);
                    file.setSize(f.length());
                    file.setCreated(LocalDateTime.now());
                    dataset.setFile(file);
                    this.sessionDbClient.updateDataset(path.getSessionId(), dataset);
                }
                catch (EOFException e) {
                    f.delete();
                    throw new BadRequestException("EOF");
                }
            }
            if (dataset.getFile() == null) {
                throw new ConflictException("file is null");
            }
            fileId = dataset.getFile().getFileId();
            File f = this.getStorageFile(fileId);
            if (f.exists()) {
                if (chunkNumber == null || chunkSize == null) {
                    throw new ConflictException("missing query parameters");
                }
                if (this.isChunkReady(f, chunkNumber, chunkSize)) {
                    inputStream.close();
                    response.setStatus(200);
                    return;
                }
            }
            File chunkFile = new File(f.getParent(), f.getName() + ".chunk" + chunkNumber);
            try {
                Throwable throwable;
                logger.debug("file size at start: " + f.length());
                try {
                    throwable = null;
                    try (FileOutputStream chunkOutStream = new FileOutputStream(chunkFile, false);){
                        IOUtils.copy((InputStream)inputStream, (OutputStream)chunkOutStream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    inputStream.close();
                }
                logger.debug("chunk file size: " + chunkFile.length());
                throwable = null;
                try (FileInputStream chunkInStream = new FileInputStream(chunkFile);
                     FileOutputStream outStream = new FileOutputStream(f, true);){
                    IOUtils.copy((InputStream)chunkInStream, (OutputStream)outStream);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                logger.debug("file size after copy: " + f.length());
                if (flowTotalChunks == chunkNumber) {
                    dataset.getFile().setSize(f.length());
                    this.sessionDbClient.updateDataset(path.getSessionId(), dataset);
                }
            }
            catch (EOFException e) {
                throw new BadRequestException("EOF");
            }
            finally {
                if (chunkFile.exists()) {
                    chunkFile.delete();
                }
            }
            response.setStatus(200);
            return;
        }
        catch (RestException | IOException e) {
            throw new InternalServerErrorException("upload failed", (Throwable)e);
        }
    }

    private boolean isChunkReady(File f, Long chunkNumber, Long chunkSize) {
        long expectedSize = chunkNumber * chunkSize;
        logger.debug("is chunk " + chunkNumber + " ready? File size: " + f.length() + " expected " + expectedSize);
        return f.exists() && f.length() >= expectedSize;
    }

    @Override
    public void onEvent(SessionEvent e) {
        logger.debug("received a file event: " + (Object)((Object)e.getResourceType()) + " " + (Object)((Object)e.getType()));
        if (SessionEvent.ResourceType.FILE == e.getResourceType() && SessionEvent.EventType.DELETE == e.getType()) {
            if (e.getResourceId() != null) {
                this.getStorageFile(e.getResourceId()).delete();
            } else {
                logger.warn("received a file deletion event with null id");
            }
        }
    }

    private double getTransferRate(long fileSize, Duration duration) {
        double rate = duration.toMillis() != 0L ? (double)fileSize / (double)duration.toMillis() * 1000.0 / 1024.0 / 1024.0 : 0.0;
        return rate;
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(200);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    public static class Path {
        private UUID datasetId;
        private UUID sessionId;

        public Path(UUID sessionId, UUID datasetId) {
            this.sessionId = sessionId;
            this.datasetId = datasetId;
        }

        public UUID getDatasetId() {
            return this.datasetId;
        }

        public void setDatasetId(UUID datasetId) {
            this.datasetId = datasetId;
        }

        public UUID getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(UUID sessionId) {
            this.sessionId = sessionId;
        }
    }

    public static class RewrittenRequest
    extends HttpServletRequestWrapper {
        private String newPath;

        public RewrittenRequest(HttpServletRequest request, String newPath) {
            super(request);
            this.newPath = newPath;
        }

        public String getPathInfo() {
            return this.newPath;
        }
    }
}

