/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.filebroker;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.filebroker.FileServlet;
import fi.csc.chipster.rest.CORSServletFilter;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.exception.ExceptionServletFilter;
import fi.csc.chipster.rest.token.TokenRequestFilter;
import fi.csc.chipster.rest.token.TokenServletFilter;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.SessionDbClient;
import java.io.File;
import java.net.URI;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AllowSymLinkAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class FileBroker {
    private Logger logger = LogManager.getLogger();
    private AuthenticationClient authService;
    private ServiceLocatorClient serviceLocator;
    private Config config;
    private String serviceId;
    private SessionDbClient sessionDbClient;
    private Server server;

    public FileBroker(Config config) {
        this.config = config;
    }

    public void startServer() throws Exception {
        String username = "file-broker";
        String password = this.config.getPassword(username);
        this.serviceLocator = new ServiceLocatorClient(this.config);
        this.authService = new AuthenticationClient(this.serviceLocator, username, password);
        this.sessionDbClient = new SessionDbClient(this.serviceLocator, this.authService.getCredentials());
        File storage = new File("storage");
        storage.mkdir();
        TokenRequestFilter tokenRequestFilter = new TokenRequestFilter(this.authService);
        URI baseUri = URI.create(this.config.getString("file-broker-bind"));
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(baseUri.getPort());
        connector.setHost(baseUri.getHost());
        this.server.addConnector((Connector)connector);
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)this.server, "/", false, false);
        contextHandler.addAliasCheck((ContextHandler.AliasCheck)new AllowSymLinkAliasChecker());
        contextHandler.setResourceBase(storage.getPath());
        FileServlet fileServlet = new FileServlet(storage, this.sessionDbClient);
        contextHandler.addServlet(new ServletHolder((Servlet)fileServlet), "/*");
        contextHandler.addFilter(new FilterHolder((Filter)new ExceptionServletFilter()), "/*", null);
        contextHandler.addFilter(new FilterHolder((Filter)new TokenServletFilter(tokenRequestFilter)), "/*", null);
        contextHandler.addFilter(new FilterHolder((Filter)new CORSServletFilter()), "/*", null);
        this.sessionDbClient.subscribe("files", fileServlet, "file-broker-file-listener");
        this.server.start();
    }

    public static void main(String[] args) throws Exception {
        new FileBroker(new Config()).startServer();
    }

    public void close() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            this.logger.warn("failed to stop the file broker", (Throwable)e);
        }
    }
}

