/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.comp;

import fi.csc.chipster.sessiondb.model.MetadataEntry;
import fi.csc.microarray.util.ToolUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.util.StringUtils;

public class RestPhenodataUtils {
    public static final String FILE_PHENODATA2 = "phenodata2.tsv";
    public static final String FILE_PHENODATA = "phenodata.tsv";
    public static final String HEADER_SAMPLE = "sample";
    public static final String HEADER_COLUMN = "column";
    public static final String HEADER_INPUT = "input";
    public static final String PREFIX_CHIP = "chip.";

    public static void writePhenodata(File jobWorkDir, HashMap<String, List<MetadataEntry>> metadata, boolean columnPhenodata, boolean fullPhenodata) throws IOException {
        Throwable throwable;
        BufferedWriter writer;
        for (String inputId : metadata.keySet()) {
            List<MetadataEntry> datasetMetadatas = metadata.get(inputId);
            for (MetadataEntry entry : datasetMetadatas) {
                if (!entry.getColumn().matches(ToolUtils.NAME_PATTERN)) {
                    throw new IllegalArgumentException("Dataset column " + entry.getColumn() + " contains illegal characters.");
                }
                if (!entry.getKey().matches(ToolUtils.NAME_PATTERN)) {
                    throw new IllegalArgumentException("Phenodata column " + entry.getKey() + " contains illegal characters.");
                }
                if (entry.getValue().matches(ToolUtils.NAME_PATTERN)) continue;
                throw new IllegalArgumentException("Phenodata value " + entry.getValue() + " contains illegal characters.");
            }
        }
        ArrayList<String> headers = RestPhenodataUtils.getHeaders(metadata);
        ArrayList<PhenodataRow> array = RestPhenodataUtils.getArray(metadata, headers);
        HashSet<String> uniqueInputs = new HashSet<String>();
        for (PhenodataRow row : array) {
            uniqueInputs.add(row.getInputId());
        }
        if (columnPhenodata) {
            if (uniqueInputs.size() != 1) {
                throw new IllegalArgumentException("The tool requires phenodata in the old format, which doesn't support multipele datasets, but more than one input dataset contains phenodata. Please remove the phenodata form other input datasets to indicate which one to use.");
            }
            writer = new BufferedWriter(new FileWriter(new File(jobWorkDir, FILE_PHENODATA)));
            throwable = null;
            try {
                writer.write(StringUtils.arrayToDelimitedString((Object[])headers.toArray(), (String)"\t"));
                writer.write("\n");
                for (PhenodataRow row : array) {
                    writer.write(StringUtils.arrayToDelimitedString((Object[])row.getRow().toArray(), (String)"\t"));
                    writer.write("\n");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        if (fullPhenodata) {
            writer = new BufferedWriter(new FileWriter(new File(jobWorkDir, FILE_PHENODATA2)));
            throwable = null;
            try {
                writer.write("input\tcolumn\t" + StringUtils.arrayToDelimitedString((Object[])headers.toArray(), (String)"\t"));
                writer.write("\n");
                for (PhenodataRow row : array) {
                    writer.write(row.getInputId() + "\t" + row.getColumn() + "\t" + StringUtils.arrayToDelimitedString((Object[])row.getRow().toArray(), (String)"\t"));
                    writer.write("\n");
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
    }

    private static ArrayList<String> getHeaders(HashMap<String, List<MetadataEntry>> metadata) {
        LinkedHashSet<String> headers = new LinkedHashSet<String>();
        for (List<MetadataEntry> entries : metadata.values()) {
            for (MetadataEntry entry : entries) {
                headers.add(entry.getKey());
            }
        }
        return new ArrayList<String>(headers);
    }

    private static ArrayList<PhenodataRow> getArray(HashMap<String, List<MetadataEntry>> metadata, ArrayList<String> headers) {
        ArrayList<PhenodataRow> phenodata = new ArrayList<PhenodataRow>();
        for (String inputId : metadata.keySet()) {
            for (MetadataEntry entry : metadata.get(inputId)) {
                PhenodataRow row = RestPhenodataUtils.getRow(inputId, entry.getColumn(), phenodata, headers);
                row.getRow().set(headers.indexOf(entry.getKey()), entry.getValue());
            }
        }
        return phenodata;
    }

    private static PhenodataRow getRow(String inputId, String column, ArrayList<PhenodataRow> phendoata, ArrayList<String> headers) {
        for (PhenodataRow row : phendoata) {
            boolean columnEquals = false;
            if (column != null) {
                columnEquals = column.equals(row.getColumn());
            } else {
                boolean bl = columnEquals = row.getColumn() == null;
            }
            if (!inputId.equals(row.getInputId()) || !columnEquals) continue;
            return row;
        }
        PhenodataRow row = new PhenodataRow(inputId, column, headers.size());
        phendoata.add(row);
        return row;
    }

    public static List<MetadataEntry> parseMetadata(File workinDir, String inputId) throws FileNotFoundException, IOException {
        ArrayList<MetadataEntry> metadata = new ArrayList<MetadataEntry>();
        File phenodata1 = new File(workinDir, FILE_PHENODATA);
        File phenodata2 = new File(workinDir, FILE_PHENODATA2);
        File phenodata = null;
        boolean isPhenodata2 = false;
        if (phenodata1.exists()) {
            phenodata = phenodata1;
        }
        if (phenodata2.exists()) {
            phenodata = phenodata2;
            isPhenodata2 = true;
        }
        if (phenodata != null && phenodata.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(phenodata));){
                String line;
                List<String> headers = null;
                while ((line = reader.readLine()) != null) {
                    String[] splitted = line.split("\t");
                    if (headers == null) {
                        headers = Arrays.asList(splitted);
                        continue;
                    }
                    String rowInputId = null;
                    String column = null;
                    if (isPhenodata2) {
                        rowInputId = splitted[headers.indexOf(HEADER_INPUT)];
                        column = splitted[headers.indexOf(HEADER_COLUMN)];
                    } else {
                        rowInputId = inputId;
                        column = PREFIX_CHIP + splitted[headers.indexOf(HEADER_SAMPLE)];
                    }
                    if (!inputId.equals(rowInputId)) continue;
                    for (String header : headers) {
                        if (HEADER_INPUT.equals(header) || HEADER_COLUMN.equals(header)) continue;
                        MetadataEntry entry = new MetadataEntry();
                        entry.setColumn(column);
                        entry.setKey(header);
                        entry.setValue(splitted[headers.indexOf(header)]);
                        metadata.add(entry);
                    }
                }
            }
        }
        return metadata;
    }

    public static class PhenodataRow {
        private ArrayList<String> row;
        private String inputId;
        private String column;

        public PhenodataRow(String inputId, String column, int length) {
            this.inputId = inputId;
            this.column = column;
            this.row = new ArrayList<String>(Arrays.asList(new String[length]));
        }

        public ArrayList<String> getRow() {
            return this.row;
        }

        public void setRow(ArrayList<String> row) {
            this.row = row;
        }

        public String getInputId() {
            return this.inputId;
        }

        public void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String column) {
            this.column = column;
        }
    }
}

