/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.auth;

import fi.csc.chipster.auth.model.Token;
import fi.csc.chipster.auth.resource.AuthenticationRequestFilter;
import fi.csc.chipster.auth.resource.TokenResource;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.hibernate.HibernateRequestFilter;
import fi.csc.chipster.rest.hibernate.HibernateResponseFilter;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.microarray.config.ConfigurationLoader;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class AuthenticationService {
    private Logger logger = LogManager.getLogger();
    private static HibernateUtil hibernate;
    private Config config;
    private HttpServer httpServer;

    public AuthenticationService(Config config) {
        this.config = config;
    }

    public void startServer() throws IOException, ConfigurationLoader.IllegalConfigurationException {
        List<Class<?>> hibernateClasses = Arrays.asList(Token.class);
        hibernate = new HibernateUtil("update");
        hibernate.buildSessionFactory(hibernateClasses, "chipster-auth-db");
        TokenResource authResource = new TokenResource(hibernate);
        ResourceConfig rc = RestUtils.getDefaultResourceConfig().register((Object)authResource).register((Object)new HibernateRequestFilter(hibernate)).register((Object)new HibernateResponseFilter(hibernate)).register((Object)new AuthenticationRequestFilter(hibernate, this.config));
        URI baseUri = URI.create(this.config.getString("authentication-service-bind"));
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)baseUri, (ResourceConfig)rc);
    }

    public static void main(String[] args) throws IOException, ConfigurationLoader.IllegalConfigurationException {
        AuthenticationService server = new AuthenticationService(new Config());
        server.startServer();
        RestUtils.waitForShutdown("authentication service", server.getHttpServer());
        hibernate.getSessionFactory().close();
    }

    private HttpServer getHttpServer() {
        return this.httpServer;
    }

    public HibernateUtil getHibernate() {
        return hibernate;
    }

    public void close() {
        RestUtils.shutdown("auth", this.httpServer);
    }
}

