/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.webstart;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.SystemMonitorUtil;
import fi.csc.microarray.webstart.JnlpServlet;
import java.io.File;
import java.util.Arrays;
import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebstartJettyServer
implements ShutdownCallback {
    private static Logger logger;
    private Server jettyInstance;

    public static void main(String[] args) throws Exception {
        System.setProperty("DEBUG", "true");
        WebstartJettyServer server = new WebstartJettyServer();
        server.start();
        server.jettyInstance.join();
    }

    public void start() {
        try {
            DirectoryLayout.initialiseServerLayout(Arrays.asList("webstart"));
            Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
            logger = Logger.getLogger(WebstartJettyServer.class);
            if (logger.isDebugEnabled()) {
                System.setProperty("DEBUG", "true");
            }
            this.jettyInstance = new Server();
            ServerConnector connector = new ServerConnector(this.jettyInstance);
            connector.setPort(configuration.getInt("webstart", "port"));
            this.jettyInstance.setConnectors(new Connector[]{connector});
            ServletContextHandler wsRoot = new ServletContextHandler((HandlerContainer)this.jettyInstance, "/", false, false);
            wsRoot.setResourceBase("web-root/");
            wsRoot.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
            wsRoot.addServlet(new ServletHolder((Servlet)new JnlpServlet()), "/servlet.jnlp");
            WebAppContext context = new WebAppContext();
            context.setWar(new File(DirectoryLayout.getInstance().getWebappsDir(), "tool-editor.war").getAbsolutePath());
            context.setContextPath("/tool-editor");
            HandlerCollection handlers = new HandlerCollection();
            handlers.setHandlers(new Handler[]{context, wsRoot});
            this.jettyInstance.setHandler((Handler)handlers);
            this.jettyInstance.start();
            KeepAliveShutdownHandler.init(this);
            logger.info((Object)("webstart is up and running [" + ApplicationConstants.VERSION + "]"));
            logger.info((Object)("[mem: " + SystemMonitorUtil.getMemInfo() + "]"));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e, (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.jettyInstance.isRunning();
    }

    @Override
    public void shutdown() {
        logger.info((Object)"shutdown requested");
        logger.info((Object)"shutting down");
    }
}

