/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.webstart;

import fi.csc.microarray.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class JnlpServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/x-java-jnlp-file");
        String memoryString = req.getParameter("memory");
        Integer memory = null;
        if (memoryString != null) {
            try {
                memory = Integer.parseInt(memoryString);
            }
            catch (NumberFormatException e) {
                resp.sendError(400, "parameter 'memory' must be an integer");
                return;
            }
        }
        resp.setStatus(200);
        PrintWriter writer = resp.getWriter();
        try {
            Document jnlp = this.getJnlp(memory);
            XmlUtil.printXml(jnlp, writer);
        }
        catch (Exception e) {
            resp.sendError(500, "jnlp modification failed");
            return;
        }
    }

    private Document getJnlp(Integer memory) throws SAXException, IOException, ParserConfigurationException {
        File wsConfigFile = new File("web-root" + File.separator + "chipster.jnlp");
        if (!wsConfigFile.exists()) {
            throw new IOException("chipster.jnlp not found");
        }
        Document doc = XmlUtil.parseFile(wsConfigFile);
        Element jnlp = doc.getDocumentElement();
        String href = "servlet.jnlp";
        if (memory != null) {
            href = href + "?";
        }
        if (memory != null) {
            href = href + "memory=" + memory;
        }
        jnlp.setAttribute("href", href);
        if (memory != null) {
            Element resources = (Element)jnlp.getElementsByTagName("resources").item(0);
            Element j2se = (Element)resources.getElementsByTagName("j2se").item(0);
            j2se.setAttribute("java-vm-args", "-Xmx" + memory + "m");
        }
        return doc;
    }
}

