/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.util.GeneralFileFilter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageExportUtils {
    public static BufferedImage componentToImage(Component component, int resolution) throws IOException {
        BufferedImage img = new BufferedImage(component.getWidth() * resolution, component.getHeight() * resolution, 3);
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        g2.scale(resolution, resolution);
        g2.setColor(component.getForeground());
        g2.setFont(component.getFont());
        component.paintAll(g2);
        return img;
    }

    public static JFileChooser getSaveFileChooser() {
        JFileChooser fileChooser = ImportUtils.getFixedFileChooser();
        String[] extensions = new String[]{"png"};
        fileChooser.setFileFilter(new GeneralFileFilter("PNG Image Files", extensions));
        fileChooser.setSelectedFile(new File("exported-image.png"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setApproveButtonText("Save");
        fileChooser.setAccessory(new ResolutionAccessory());
        return fileChooser;
    }

    public static JFileChooser saveComponent(Component component, JFileChooser fileChooser) throws IOException {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(component);
        return ImageExportUtils.saveComponents(components, fileChooser);
    }

    public static JFileChooser saveComponents(ArrayList<Component> components, JFileChooser fileChooser) throws IOException {
        int option;
        if (fileChooser == null) {
            fileChooser = ImageExportUtils.getSaveFileChooser();
        }
        if ((option = fileChooser.showOpenDialog(components.get(0))) == 0) {
            ResolutionAccessory accessory = (ResolutionAccessory)fileChooser.getAccessory();
            int widthSum = 0;
            int maxHeight = 0;
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            for (Component component : components) {
                BufferedImage image = ImageExportUtils.componentToImage(component, accessory.getResolution());
                widthSum += image.getWidth();
                maxHeight = Math.max(maxHeight, image.getHeight());
                images.add(image);
            }
            BufferedImage collage = new BufferedImage(widthSum, maxHeight, 3);
            int x = 0;
            for (BufferedImage image : images) {
                collage.getGraphics().drawImage(image, x, 0, null);
                x += image.getWidth();
            }
            ImageIO.write((RenderedImage)collage, "png", fileChooser.getSelectedFile());
        }
        return fileChooser;
    }

    public static int printComponent(Graphics g, PageFormat pf, int page, Component component) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        double scaleX = pf.getImageableWidth() / (double)component.getWidth();
        double scaleY = pf.getImageableHeight() / (double)component.getHeight();
        double scale = Math.min(scaleX, scaleY);
        g2d.scale(scale, scale);
        component.paintAll(g);
        return 0;
    }

    public static void printComponent(Printable component) throws PrinterException {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(component);
        boolean doPrint = job.printDialog();
        if (doPrint) {
            job.print();
        }
    }

    public static class ResolutionAccessory
    extends JPanel {
        private JComboBox<Resolution> comboBox;

        public ResolutionAccessory() {
            JLabel label = new JLabel("Resolution: ");
            this.comboBox = new JComboBox<Resolution>(Resolution.values());
            this.add(label);
            this.add(this.comboBox);
        }

        public int getResolution() {
            Resolution res = (Resolution)((Object)this.comboBox.getSelectedItem());
            return res.resolution;
        }
    }

    static enum Resolution {
        RES1("1X", 1),
        RES2("2X", 2),
        RES4("4X", 4),
        RES8("8X", 8);

        private String name;
        private int resolution;

        private Resolution(String name, int resolution) {
            this.name = name;
            this.resolution = resolution;
        }

        public String toString() {
            return this.name;
        }
    }
}

