/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.module.chipster;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.QuickLinkPanel;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.selection.IntegratedEntity;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.methods.ArrayLayout;
import fi.csc.microarray.client.visualisation.methods.ChipsterGBrowserVisualisation;
import fi.csc.microarray.client.visualisation.methods.ClusteredProfiles;
import fi.csc.microarray.client.visualisation.methods.ExpressionProfile;
import fi.csc.microarray.client.visualisation.methods.Heatmap;
import fi.csc.microarray.client.visualisation.methods.HierarchicalClustering;
import fi.csc.microarray.client.visualisation.methods.Histogram;
import fi.csc.microarray.client.visualisation.methods.PhenodataEditor;
import fi.csc.microarray.client.visualisation.methods.SOM;
import fi.csc.microarray.client.visualisation.methods.SamBamViewer;
import fi.csc.microarray.client.visualisation.methods.Scatterplot;
import fi.csc.microarray.client.visualisation.methods.Scatterplot3DPCA;
import fi.csc.microarray.client.visualisation.methods.VennDiagram;
import fi.csc.microarray.client.visualisation.methods.Volcanoplot;
import fi.csc.microarray.client.visualisation.methods.threed.Scatterplot3D;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.TypeTag;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.databeans.features.bio.IdentifierProvider;
import fi.csc.microarray.databeans.features.bio.NormalisedExpressionProvider;
import fi.csc.microarray.databeans.features.stat.HierarchicalClusterProvider;
import fi.csc.microarray.databeans.features.stat.SomClusterProvider;
import fi.csc.microarray.databeans.features.table.EditableTable;
import fi.csc.microarray.databeans.features.table.TableBeanEditor;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.filebroker.ChecksumInputStream;
import fi.csc.microarray.filebroker.DbSession;
import fi.csc.microarray.module.Module;
import fi.csc.microarray.module.basic.BasicModule;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.JMSException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import org.jdesktop.swingx.JXHyperlink;

public class MicroarrayModule
implements Module {
    @Override
    public void plugContentTypes(DataManager manager) {
        manager.plugContentType("application/x-treeview", true, false, "Newick formatted tree from clustering", "/types/text.png", "tre");
        manager.plugContentType("application/cel", true, false, "Affymetrix CEL", "/types/rawdata.png", "cel");
        manager.plugContentType("text/bed", true, false, "BED file", "/types/text.png", "bed");
        manager.plugContentType("text/gtf", true, false, "Gene Transfer Format file", "/types/text.png", "gtf", "gff", "gff2", "gff3");
        manager.plugContentType("chemical/x-fasta", true, false, "FASTA", "/types/text.png", "fasta", "fa", "fna", "fsa", "mpfa");
        manager.plugContentType("text/fastq", true, false, "FASTQ", "/types/text.png", "fastq", "fq");
        manager.plugContentType("application/gzip", true, true, "Gzip file", "/types/binary.png", "gz");
        manager.plugContentType("text/vcf", true, false, "Variant Call Format", "/types/text.png", "vcf");
        manager.plugContentType("application/bam", true, false, "Binary sequence Alignment/Map format", "/types/text.png", "bam");
        manager.plugContentType("text/qual", true, false, "Quality file", "/types/text.png", "qual");
        manager.plugContentType("text/mothur-oligos", true, false, "Mothur oligos file", "/types/text.png", "oligos");
        manager.plugContentType("text/mothur-names", true, false, "Mothur names file", "/types/text.png", "names");
        manager.plugContentType("text/mothur-groups", true, false, "Mothur groups file", "/types/text.png", "groups");
        manager.plugContentType("text/mothur-stability", true, false, "Mothur stability file", "/types/text.png", "files");
        manager.plugContentType("text/sff", true, false, "sff file", "/types/text.png", "sff");
    }

    @Override
    public void plugFeatures(DataManager manager) {
        manager.plugFeatureFactory("/normalised-expression", new NormalisedExpressionProvider());
        manager.plugFeatureFactory("/identifier", new IdentifierProvider());
        manager.plugFeatureFactory("/clusters/som", new SomClusterProvider());
        manager.plugFeatureFactory("/clusters/hierarchical", new HierarchicalClusterProvider());
    }

    @Override
    public void plugModifiers(DataManager manager) {
    }

    @Override
    public String[] getServerModuleNames() {
        return new String[]{"microarray", "ngs", "misc"};
    }

    @Override
    public String getModuleLongName(String moduleName) {
        if ("microarray".equals(moduleName)) {
            return "Microarrays";
        }
        if ("ngs".equals(moduleName)) {
            return "NGS";
        }
        if ("misc".equals(moduleName)) {
            return "Misc";
        }
        return moduleName;
    }

    @Override
    public void addImportMenuItems(JMenu importMenu) {
    }

    @Override
    public void addImportLinks(QuickLinkPanel quickLinkPanel, List<JXHyperlink> importLinks) {
    }

    @Override
    public boolean isImportToolSupported() {
        return true;
    }

    @Override
    public boolean isWorkflowCompatible(DataBean data) {
        return true;
    }

    @Override
    public VisualisationMethod[] getVisualisationMethods() {
        return new VisualisationMethod[]{VisualisationMethods.PHENODATA, VisualisationMethods.ARRAY_LAYOUT, VisualisationMethods.HEATMAP, VisualisationMethods.HISTOGRAM, VisualisationMethods.SCATTERPLOT, VisualisationMethods.SCATTERPLOT3D, VisualisationMethods.SCATTERPLOT3DPCA, VisualisationMethods.VOLCANOPLOT, VisualisationMethods.SOM, VisualisationMethods.HIERARCHICAL, VisualisationMethods.EXPRESSION_PROFILE, VisualisationMethods.CLUSTERED_PROFILES, VisualisationMethods.VENN_DIAGRAM, VisualisationMethods.SAMBAM_VIEWER, VisualisationMethods.GBROWSER};
    }

    @Override
    public List<DbSession> getExampleSessions(boolean isStandalone) throws JMSException, Exception {
        List<DbSession> sessions = Session.getSession().getServiceAccessor().getFileBrokerClient().listPublicRemoteSessions();
        return sessions;
    }

    @Override
    public String[][] getRepositoryWorkflows() {
        return new String[][]{{"Gene expression analysis", "/gene-expression-analysis.bsh"}, {"Protein expression analysis", "/protein-expression-analysis.bsh"}, {"miRNA expression analysis", "/mirna-expression-analysis.bsh"}};
    }

    public static DataBean getProperSource(DataBean dataBean) {
        if (dataBean == null || dataBean.getLinkTargets(DataBean.Link.DERIVATION).size() == 0) {
            return null;
        }
        if (dataBean.getLinkTargets(DataBean.Link.DERIVATION).size() == 1) {
            return dataBean.getLinkTargets(DataBean.Link.DERIVATION).iterator().next();
        }
        LinkedList<DataBean> sourceCollector = new LinkedList<DataBean>();
        for (DataBean source : dataBean.getLinkTargets(DataBean.Link.DERIVATION)) {
            if (!source.queryFeatures("/phenodata").exists()) continue;
            sourceCollector.add(source);
        }
        if (sourceCollector.size() == 0 || sourceCollector.size() > 1) {
            return null;
        }
        return (DataBean)sourceCollector.getFirst();
    }

    public static DataBean[] getSourcePath(DataBean dataBean) {
        LinkedList<DataBean> list = new LinkedList<DataBean>();
        if (MicroarrayModule.getProperSource(dataBean) != null) {
            list.addAll(Arrays.asList(MicroarrayModule.getSourcePath(MicroarrayModule.getProperSource(dataBean))));
        }
        list.add(dataBean);
        return list.toArray(new DataBean[0]);
    }

    @Override
    public boolean isMetadata(DataBean data) {
        return data.queryFeatures("/phenodata").exists();
    }

    @Override
    public void preProcessInputMetadata(Operation oper, DataBean metadataInput) throws MicroarrayException, IOException {
        try (Table table = metadataInput.queryFeatures("/column/*").asTable();){
            Pattern pattern = Pattern.compile("\\s");
            for (String column : table.getColumnNames()) {
                Matcher matcher = pattern.matcher(column);
                if (!matcher.find()) continue;
                throw new MicroarrayException("Phenodata columnn titles must not contain white space characters (space, tab and new line)");
            }
        }
    }

    @Override
    public void postProcessOutputMetadata(OperationRecord oper, DataBean metadataOutput) throws MicroarrayException, IOException {
        if (!metadataOutput.queryFeatures("/column/original_name").exists()) {
            HashSet<String> insertedNames = new HashSet<String>();
            TableBeanEditor tableEditor = new TableBeanEditor(metadataOutput);
            EditableTable editableTable = tableEditor.getEditable();
            LinkedList<String> newColumn = new LinkedList<String>();
            newColumn.addAll(Arrays.asList(Strings.repeatToArray("", editableTable.getRowCount())));
            editableTable.addColumn("original_name", 1, newColumn);
            for (int ri = 0; ri < editableTable.getRowCount(); ++ri) {
                String sample = editableTable.getValue("sample", ri);
                boolean correctRowFound = false;
                String originalName = null;
                for (OperationRecord.InputRecord input : oper.getInputRecords()) {
                    String internalName = input.getNameID().getID();
                    DataBean bean = input.getValue();
                    if (!internalName.equals(sample)) continue;
                    DataBean ancestor = bean.getUniqueAncestorRecursively(bean);
                    originalName = !ancestor.equals(bean) ? bean.getName() + " ( " + ancestor.getName() + " )" : bean.getName();
                    correctRowFound = true;
                    break;
                }
                if (!correctRowFound) {
                    originalName = sample;
                }
                if (insertedNames.contains(originalName)) {
                    String separator = "/";
                    int i = 2;
                    while (insertedNames.contains(originalName + "/" + i)) {
                        ++i;
                    }
                    originalName = originalName + "/" + i;
                }
                editableTable.setValue("original_name", ri, originalName);
                insertedNames.add(originalName);
            }
            tableEditor.write();
        }
        if (!metadataOutput.queryFeatures("/column/description").exists()) {
            TableBeanEditor tableEditor = new TableBeanEditor(metadataOutput);
            EditableTable editableTable = tableEditor.getEditable();
            LinkedList<String> newColumn = new LinkedList<String>();
            newColumn.addAll(Arrays.asList(Strings.repeatToArray("", editableTable.getRowCount())));
            editableTable.addColumn("description", newColumn);
            for (int ri = 0; ri < editableTable.getRowCount(); ++ri) {
                String sample = editableTable.getValue("original_name", ri);
                editableTable.setValue("description", ri, sample);
            }
            tableEditor.write();
        }
    }

    @Override
    public String getShortDataName(String categoryName) {
        return BasicModule.shortenDataName(categoryName);
    }

    @Override
    public boolean countOperationResults() {
        return true;
    }

    @Override
    public JPanel getContextLinkPanel(int selectedDataCount) {
        JXHyperlink link;
        final ClientApplication application = Session.getSession().getApplication();
        if (!application.isStandalone()) {
            return null;
        }
        JPanel contentPanel = new JPanel();
        contentPanel.setBackground(Color.WHITE);
        contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        int topMargin = 15;
        int leftMargin = 30;
        c.insets.set(topMargin, leftMargin, 0, 0);
        contentPanel.add((Component)new JLabel(VisualConstants.getIcon("/eclipse/bulb.gif")), c);
        boolean currentSelectionVisualisable = false;
        try {
            Visualisation visualisation = VisualisationMethods.GBROWSER.getVisualiser(null);
            if (visualisation != null) {
                List<DataBean> selection = application.getSelectionManager().getSelectedDataBeans();
                currentSelectionVisualisable = visualisation.canVisualise(selection);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (selectedDataCount > 0 && currentSelectionVisualisable) {
            link = new JXHyperlink((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    application.setVisualisationMethod(VisualisationMethods.GBROWSER, null, application.getSelectionManager().getSelectedDataBeans(), VisualisationFrameManager.FrameType.MAIN);
                }
            });
            link.setText("Open genome browser");
        } else if (selectedDataCount < application.getDataManager().databeans().size()) {
            link = new JXHyperlink((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    application.selectAllItems();
                    boolean canVisualise = false;
                    try {
                        canVisualise = VisualisationMethods.GBROWSER.getVisualiser(null).canVisualise(application.getSelectionManager().getSelectedDataBeans());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (canVisualise) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                application.setVisualisationMethod(VisualisationMethods.GBROWSER, null, application.getSelectionManager().getSelectedDataBeans(), VisualisationFrameManager.FrameType.MAIN);
                            }
                        });
                    } else {
                        application.showDialog("Cannot open genome browser", "Currect dataset selection cannot be visualised in genome browser", "Unselect improper datasets to open genome browser.", DialogInfo.Severity.INFO, true);
                    }
                }
            });
            link.setText("Select all and open genome browser");
        } else {
            return null;
        }
        c.insets.set(topMargin, 5, 0, 0);
        ++c.gridx;
        contentPanel.add((Component)link, c);
        return contentPanel;
    }

    @Override
    public boolean notesVisibleAtStartup() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Chipster";
    }

    @Override
    public String getManualHome() {
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        return configuration.getString("client", "manual-root");
    }

    @Override
    public List<Boolean> flagLinkableColumns(Table columns, DataBean data) {
        LinkedList<Boolean> flags = new LinkedList<Boolean>();
        flags.add(data.hasTypeTag(TypeTags.CHROMOSOME_IN_FIRST_TABLE_COLUMN));
        flags.add(data.hasTypeTag(TypeTags.START_POSITION_IN_SECOND_TABLE_COLUMN) || data.hasTypeTag(TypeTags.CHROMOSOME_IN_SECOND_TABLE_COLUMN));
        flags.add(data.hasTypeTag(TypeTags.END_POSITION_IN_THIRD_TABLE_COLUMN) || data.hasTypeTag(TypeTags.START_POSITION_IN_THIRD_TABLE_COLUMN));
        flags.add(data.hasTypeTag(TypeTags.END_POSITION_IN_FOURTH_TABLE_COLUMN) || data.hasTypeTag(TypeTags.START_POSITION_IN_FOURTH_TABLE_COLUMN));
        flags.add(data.hasTypeTag(TypeTags.END_POSITION_IN_FIFTH_TABLE_COLUMN));
        for (int i = 4; i < columns.getColumnCount(); ++i) {
            flags.add(false);
        }
        return flags;
    }

    @Override
    public IntegratedEntity createLinkableEntity(Table columns, DataBean data) {
        IntegratedEntity entity = new IntegratedEntity();
        String CHR_KEY = "chromosome";
        String START_KEY = "start";
        String END_KEY = "end";
        int chrColumn = -1;
        if (data.hasTypeTag(TypeTags.CHROMOSOME_IN_FIRST_TABLE_COLUMN)) {
            chrColumn = 0;
        }
        if (data.hasTypeTag(TypeTags.CHROMOSOME_IN_SECOND_TABLE_COLUMN)) {
            chrColumn = 1;
        }
        if (chrColumn != -1) {
            entity.put("chromosome", columns.getStringValue(columns.getColumnNames()[chrColumn]));
        }
        int startColumn = -1;
        if (data.hasTypeTag(TypeTags.START_POSITION_IN_SECOND_TABLE_COLUMN)) {
            startColumn = 1;
        }
        if (data.hasTypeTag(TypeTags.START_POSITION_IN_THIRD_TABLE_COLUMN)) {
            startColumn = 2;
        }
        if (data.hasTypeTag(TypeTags.START_POSITION_IN_FOURTH_TABLE_COLUMN)) {
            startColumn = 3;
        }
        if (startColumn != -1) {
            entity.put("start", columns.getStringValue(columns.getColumnNames()[startColumn]));
        }
        int endColumn = -1;
        if (data.hasTypeTag(TypeTags.END_POSITION_IN_THIRD_TABLE_COLUMN)) {
            endColumn = 2;
        }
        if (data.hasTypeTag(TypeTags.END_POSITION_IN_FOURTH_TABLE_COLUMN)) {
            endColumn = 3;
        }
        if (data.hasTypeTag(TypeTags.END_POSITION_IN_FIFTH_TABLE_COLUMN)) {
            endColumn = 4;
        }
        if (endColumn != -1) {
            entity.put("end", columns.getStringValue(columns.getColumnNames()[endColumn]));
        }
        return entity;
    }

    @Override
    public void addTypeTags(DataBean data) throws MicroarrayException, IOException {
        if (data.isContentTypeCompatitible("application/cel")) {
            data.addTypeTag(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES);
        }
        if (data.isContentTypeCompatitible("text/tab", "application/cel", "text/csv")) {
            data.addTypeTag(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES);
        }
        if (data.isContentTypeCompatitible("text/tab")) {
            BufferedReader in;
            block61: {
                in = null;
                try {
                    in = new BufferedReader(new InputStreamReader(Session.getSession().getDataManager().getContentStream(data, DataBean.DataNotAvailableHandling.EXCEPTION_ON_NA)));
                    String headerLine = in.readLine();
                    String contentLine = in.readLine();
                    if (headerLine == null || contentLine == null) break block61;
                    List<String> chrColumns = Arrays.asList("chr", "SEQNAMES", "chromosome");
                    List<String> startColumns = Arrays.asList("start", "START");
                    List<String> endColumns = Arrays.asList("end", "END");
                    String[] split = headerLine.split("\t");
                    int shiftHeader = 0;
                    if (split.length == contentLine.split("\t").length - 1) {
                        shiftHeader = 1;
                    }
                    for (int i = 0; i < split.length; ++i) {
                        String column = split[i];
                        if (chrColumns.contains(column)) {
                            switch (i + shiftHeader) {
                                case 0: {
                                    data.addTypeTag(TypeTags.CHROMOSOME_IN_FIRST_TABLE_COLUMN);
                                    break;
                                }
                                case 1: {
                                    data.addTypeTag(TypeTags.CHROMOSOME_IN_SECOND_TABLE_COLUMN);
                                }
                            }
                        }
                        if (startColumns.contains(column)) {
                            switch (i + shiftHeader) {
                                case 1: {
                                    data.addTypeTag(TypeTags.START_POSITION_IN_SECOND_TABLE_COLUMN);
                                    break;
                                }
                                case 2: {
                                    data.addTypeTag(TypeTags.START_POSITION_IN_THIRD_TABLE_COLUMN);
                                }
                            }
                        }
                        if (endColumns.contains(column)) {
                            switch (i + shiftHeader) {
                                case 2: {
                                    data.addTypeTag(TypeTags.END_POSITION_IN_THIRD_TABLE_COLUMN);
                                    break;
                                }
                                case 3: {
                                    data.addTypeTag(TypeTags.END_POSITION_IN_FOURTH_TABLE_COLUMN);
                                }
                            }
                        }
                        if (!column.contains("loss.freq") && !column.contains("gain.freq") && !column.startsWith("flag.") && !column.startsWith("segmented.") || data.hasTypeTag(TypeTags.CNA)) continue;
                        data.addTypeTag(TypeTags.CNA);
                    }
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeIfPossible(in);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeIfPossible(in);
        }
        if (data.isContentTypeCompatitible("text/gtf")) {
            data.addTypeTag(TypeTags.GTF_FILE);
            data.addTypeTag(BasicModule.TypeTags.TABLE_WITHOUT_COLUMN_NAMES);
            data.addTypeTag(TypeTags.CHROMOSOME_IN_FIRST_TABLE_COLUMN);
            data.addTypeTag(TypeTags.START_POSITION_IN_FOURTH_TABLE_COLUMN);
            data.addTypeTag(TypeTags.END_POSITION_IN_FIFTH_TABLE_COLUMN);
            this.addTypeTagIfHashHeader(data);
        }
        if (data.isContentTypeCompatitible("text/vcf")) {
            data.addTypeTag(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES);
            this.addTypeTagIfDoubleHashHeader(data);
            data.addTypeTag(TypeTags.CHROMOSOME_IN_FIRST_TABLE_COLUMN);
            data.addTypeTag(TypeTags.START_POSITION_IN_SECOND_TABLE_COLUMN);
        }
        if (data.isContentTypeCompatitible("text/bed")) {
            data.addTypeTag(BasicModule.TypeTags.TABLE_WITHOUT_COLUMN_NAMES);
            data.addTypeTag(TypeTags.CHROMOSOME_IN_FIRST_TABLE_COLUMN);
            data.addTypeTag(TypeTags.START_POSITION_IN_SECOND_TABLE_COLUMN);
            data.addTypeTag(TypeTags.END_POSITION_IN_THIRD_TABLE_COLUMN);
            if (this.readFirstLine(data).startsWith("track")) {
                data.addTypeTag(BasicModule.TypeTags.TABLE_WITH_HEADER_ROW);
            }
        }
        if (data.isContentTypeCompatitible("application/bam")) {
            data.addTypeTag(TypeTags.BAM_FILE);
        }
        if (data.isContentTypeCompatitible("chemical/x-fasta")) {
            data.addTypeTag(TypeTags.FASTA_FILE);
        }
        if (data.isContentTypeCompatitible("text/mothur-oligos")) {
            data.addTypeTag(TypeTags.MOTHUR_OLIGOS);
        }
        if (data.isContentTypeCompatitible("text/mothur-names")) {
            data.addTypeTag(TypeTags.MOTHUR_NAMES);
        }
        if (data.isContentTypeCompatitible("text/mothur-groups")) {
            data.addTypeTag(TypeTags.MOTHUR_GROUPS);
        }
        if (data.isContentTypeCompatitible("text/mothur-stability")) {
            data.addTypeTag(TypeTags.MOTHUR_STABILITY);
        }
        if (!(Session.getSession().getPrimaryModule() instanceof MicroarrayModule)) {
            return;
        }
        try (Table chips = data.queryFeatures("/column/chip.*").asTable();){
            String line;
            if (data.isContentTypeCompatitible("application/cel")) {
                data.addTypeTag(TypeTags.RAW_AFFYMETRIX_EXPRESSION_VALUES);
            } else if (data.queryFeatures("/column/sample").exists() && !data.queryFeatures("/phenodata").exists()) {
                data.addTypeTag(TypeTags.RAW_EXPRESSION_VALUES);
            } else if (chips != null && chips.getColumnCount() > 0) {
                data.addTypeTag(TypeTags.NORMALISED_EXPRESSION_VALUES);
            }
            if (data.queryFeatures("/identifier").exists()) {
                data.addTypeTag(TypeTags.GENENAMES);
            }
            if (data.queryFeatures("/phenodata").exists()) {
                data.addTypeTag(TypeTags.PHENODATA);
            }
            if (data.queryFeatures("/column/p.*").exists() && data.queryFeatures("/column/FC*").exists() || data.queryFeatures("/column/pvalue*").exists() && data.queryFeatures("/column/log2FoldChange*").exists() || data.queryFeatures("/column/PValue*").exists() && data.queryFeatures("/column/logFC*").exists()) {
                data.addTypeTag(TypeTags.SIGNIFICANT_EXPRESSION_FOLD_CHANGES);
            }
            if (data.getOperationRecord().getNameID().getID().equals("ordination-pca.R")) {
                data.addTypeTag(TypeTags.EXPRESSION_PRIMARY_COMPONENTS_CHIPWISE);
            }
            if (chips != null && chips.getColumnNames().length > 1 && data.queryFeatures("/column/cluster").exists()) {
                data.addTypeTag(TypeTags.CLUSTERED_EXPRESSION_VALUES);
            }
            if (data.queryFeatures("/clusters/som").exists()) {
                data.addTypeTag(TypeTags.SOM_CLUSTERED_EXPRESSION_VALUES);
            }
            if (data.isContentTypeCompatitible("text/bed") || data.isContentTypeCompatitible("application/octet-stream") && data.getName().contains(".bam-summary") || data.isContentTypeCompatitible("application/octet-stream") && (data.getName().endsWith(".bam") || data.getName().endsWith(".sam")) || data.isContentTypeCompatitible("application/octet-stream") && data.getName().endsWith(".bai")) {
                data.addTypeTag(TypeTags.ORDERED_GENOMIC_ENTITIES);
            } else if (data.isContentTypeCompatitible("text/tab") && (line = this.readFirstLine(data)) != null && line.contains("chr") && line.contains("start") && line.contains("end")) {
                data.addTypeTag(TypeTags.ORDERED_GENOMIC_ENTITIES);
            }
        }
    }

    private String readFirstLine(DataBean data) {
        BufferedReader reader = null;
        try {
            ChecksumInputStream stream = Session.getSession().getDataManager().getContentStream(data, DataBean.DataNotAvailableHandling.NULL_ON_NA);
            if (stream != null) {
                reader = new BufferedReader(new InputStreamReader(stream));
                String string = reader.readLine();
                IOUtils.closeIfPossible(reader);
                return string;
            }
            String string = "";
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeIfPossible(reader);
        }
    }

    @Override
    public Icon getIconFor(DataBean data) {
        if (data.hasTypeTag(TypeTags.PHENODATA)) {
            return VisualConstants.getIcon("/types/phenodata.png");
        }
        return data.getContentType().getIcon();
    }

    private void addTypeTagIfHashHeader(DataBean data) {
        String line = this.readFirstLine(data);
        if (line != null && line.startsWith("#")) {
            data.addTypeTag(TypeTags.TABLE_WITH_HASH_HEADER);
        }
    }

    private void addTypeTagIfDoubleHashHeader(DataBean data) {
        String line = this.readFirstLine(data);
        if (line != null && line.startsWith("##")) {
            data.addTypeTag(TypeTags.TABLE_WITH_DOUBLE_HASH_HEADER);
        }
    }

    @Override
    public void updateUIDefaults(UIDefaults defaults) {
    }

    public static class VisualisationMethods {
        public static VisualisationMethod ARRAY_LAYOUT = new VisualisationMethod("Array layout", ArrayLayout.class, VisualConstants.ARRAY_MENUICON, 100, 9.0E-4);
        public static VisualisationMethod HISTOGRAM = new VisualisationMethod("Histogram", Histogram.class, VisualConstants.HISTOGRAM_MENUICON, 70, 0.024);
        public static VisualisationMethod HEATMAP = new VisualisationMethod("Heatmap", Heatmap.class, VisualConstants.HEATMAP_MENUICON, 100, 9.0E-4);
        public static VisualisationMethod SCATTERPLOT = new VisualisationMethod("Scatterplot", Scatterplot.class, VisualConstants.SCATTER_MENUICON, 79, 0.039);
        public static VisualisationMethod SCATTERPLOT3D = new VisualisationMethod("3D Scatterplot", Scatterplot3D.class, VisualConstants.SCATTER3D_MENUICON, 78, 0.082);
        public static VisualisationMethod SCATTERPLOT3DPCA = new VisualisationMethod("3D Scatterplot for PCA", Scatterplot3DPCA.class, VisualConstants.SCATTER3DPCA_MENUICON, 77, 0.082);
        public static VisualisationMethod VOLCANOPLOT = new VisualisationMethod("Volcano plot", Volcanoplot.class, VisualConstants.VOLCANO_MENUICON, 80, 0.039);
        public static VisualisationMethod SOM = new VisualisationMethod("SOM", SOM.class, VisualConstants.SOM_MENUICON, 59, 0.034);
        public static VisualisationMethod HIERARCHICAL = new VisualisationMethod("Hierarchical clustering", HierarchicalClustering.class, VisualConstants.HC_MENUICON, 60, 0.09);
        public static VisualisationMethod EXPRESSION_PROFILE = new VisualisationMethod("Expression profile", ExpressionProfile.class, VisualConstants.PROFILE_MENUICON, 90, 0.1);
        public static VisualisationMethod CLUSTERED_PROFILES = new VisualisationMethod("Clustered profiles", ClusteredProfiles.class, VisualConstants.PROFILES_MENUICON, 89, 0.087);
        public static VisualisationMethod VENN_DIAGRAM = new VisualisationMethod("Venn-diagram", VennDiagram.class, VisualConstants.VENN_MENUICON, 50, -1.0);
        public static VisualisationMethod GBROWSER = new VisualisationMethod("Genome browser", ChipsterGBrowserVisualisation.class, VisualConstants.GB_MENUICON, 90, -1.0, "genomeBrowser.html");
        public static VisualisationMethod SAMBAM_VIEWER = new VisualisationMethod("BAM viewer", SamBamViewer.class, VisualConstants.TEXT_MENUICON, 100, -1.0);
        public static VisualisationMethod PHENODATA = new VisualisationMethod("Phenodata editor", PhenodataEditor.class, VisualConstants.PHENODATA_MENUICON, 105, 0.0, "visualisation-phenodata.html");
    }

    public static class TypeTags {
        public static final TypeTag PHENODATA = new TypeTag("phenodata", "Chipster compatible phenodata");
        public static final TypeTag RAW_AFFYMETRIX_EXPRESSION_VALUES = new TypeTag("raw-arrymetrix-expression-values", "must be in CEL format (text or binary)");
        public static final TypeTag RAW_EXPRESSION_VALUES = new TypeTag("raw-expression-values", "");
        public static final TypeTag NORMALISED_EXPRESSION_VALUES = new TypeTag("normalised-expression-values", "must have columns following name pattern \"chip.*\"");
        public static final TypeTag GENENAMES = new TypeTag("genenames", "must have column \" \" or \"identifier\"");
        public static final TypeTag SIGNIFICANT_EXPRESSION_FOLD_CHANGES = new TypeTag("significant-expression-fold-changes", "must have columns following name patterns \"FC.*\" and \"p.*\"");
        public static final TypeTag EXPRESSION_PRIMARY_COMPONENTS_GENEWISE = new TypeTag("expression-primary-components-genewise", "");
        public static final TypeTag EXPRESSION_PRIMARY_COMPONENTS_CHIPWISE = new TypeTag("expression-primary-components-chipwise", "");
        public static final TypeTag ORDERED_GENOMIC_ENTITIES = new TypeTag("ordered-genomic-entities", "");
        public static final TypeTag CLUSTERED_EXPRESSION_VALUES = new TypeTag("clustered-expression-values", "must have column \"cluster\"");
        public static final TypeTag SOM_CLUSTERED_EXPRESSION_VALUES = new TypeTag("som-clustered-expression-values", "must have columns \"colours\", \"distance2first\", \"cluster\", \"griddim\"");
        public static final TypeTag BAM_FILE = new TypeTag("bam-file", "");
        public static final TypeTag FASTA_FILE = new TypeTag("fasta-file", "");
        public static final TypeTag GTF_FILE = new TypeTag("gtf-file", "");
        public static final TypeTag TABLE_WITH_HASH_HEADER = new TypeTag("table-with-hash-header", "header rows start with #");
        public static final TypeTag TABLE_WITH_DOUBLE_HASH_HEADER = new TypeTag("table-with-double-hash-header", "header rows start with ##");
        public static final TypeTag CHROMOSOME_IN_FIRST_TABLE_COLUMN = new TypeTag("chromosome-in-first-table-column", "first column of table is chromosome");
        public static final TypeTag CHROMOSOME_IN_SECOND_TABLE_COLUMN = new TypeTag("chromosome-in-second-table-column", "second column of table is chromosome");
        public static final TypeTag START_POSITION_IN_SECOND_TABLE_COLUMN = new TypeTag("start-position-in-second-table-column", "second column of table is start position");
        public static final TypeTag START_POSITION_IN_THIRD_TABLE_COLUMN = new TypeTag("start-position-in-third-table-column", "third column of table is start position");
        public static final TypeTag START_POSITION_IN_FOURTH_TABLE_COLUMN = new TypeTag("start-position-in-fourth-table-column", "fourth column of table is start position");
        public static final TypeTag END_POSITION_IN_THIRD_TABLE_COLUMN = new TypeTag("end-position-in-third-table-column", "third column of table is end position");
        public static final TypeTag END_POSITION_IN_FOURTH_TABLE_COLUMN = new TypeTag("end-position-in-fourth-table-column", "fourth column of table is end position");
        public static final TypeTag END_POSITION_IN_FIFTH_TABLE_COLUMN = new TypeTag("end-position-in-fifth-table-column", "fifth column of table is end position");
        public static final TypeTag CNA = new TypeTag("cna-data", "data file produced by cna tools");
        public static final TypeTag MOTHUR_OLIGOS = new TypeTag("Mothur oligos data", "Mothur oligos data");
        public static final TypeTag MOTHUR_NAMES = new TypeTag("Mothur names data", "Mothur names data");
        public static final TypeTag MOTHUR_GROUPS = new TypeTag("Mothur groups data", "Mothur groups data");
        public static final TypeTag MOTHUR_STABILITY = new TypeTag("Mothur stability data", "Mothur stability data");
    }
}

