/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.MonitoredNode;
import fi.csc.microarray.messaging.Node;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.auth.AuthenticatedTopic;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.util.KeyAndTrustManager;
import fi.csc.microarray.util.UrlTransferUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.net.ssl.SSLHandshakeException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.log4j.Logger;

public class JMSMessagingEndpoint
implements MessagingEndpoint,
MessagingListener {
    private static final Logger logger = Logger.getLogger(JMSMessagingEndpoint.class);
    private static final String RELIABLE_CONNECTION_SPECIFIER = "failover:";
    private final String brokerUrl;
    private final boolean useReliable;
    private final String DEFAULT_REPLY_CHANNEL = Topics.MultiplexName.REPLY_TO.toString();
    private ActiveMQConnection connection;
    private MessagingTopic adminTopic = null;
    private Node master;
    private AuthenticationRequestListener authenticationListener;
    private String sessionID = null;

    public JMSMessagingEndpoint(Node master) throws MicroarrayException {
        this(master, null, false);
    }

    public JMSMessagingEndpoint(Node master, AuthenticationRequestListener authenticationListener, boolean useUnreliableAtStartup) throws MicroarrayException {
        this.master = master;
        this.authenticationListener = authenticationListener;
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        if (configuration.getBoolean("messaging", "disable-proxy")) {
            UrlTransferUtil.disableProxies();
        }
        String protocol = configuration.getString("messaging", "broker-protocol");
        String host = configuration.getString("messaging", "broker-host");
        int port = configuration.getInt("messaging", "broker-port");
        if (protocol.trim().equals("") || host.trim().equals("")) {
            throw new RuntimeException("configuration error: protocol or host empty");
        }
        this.useReliable = configuration.getBoolean("messaging", "use-reliable");
        this.brokerUrl = protocol + "://" + host + ":" + port;
        if ("ssl".equals(configuration.getString("messaging", "broker-protocol"))) {
            try {
                KeyAndTrustManager.initialiseTrustStore();
            }
            catch (Exception e) {
                throw new MicroarrayException("could not access SSL keystore", e);
            }
        }
        String username = JMSMessagingEndpoint.getUsername(configuration);
        String password = JMSMessagingEndpoint.getPassword(configuration);
        try {
            logger.info((Object)("connecting to " + this.brokerUrl));
            String completeBrokerUrl = this.brokerUrl;
            if (useUnreliableAtStartup) {
                logger.debug((Object)("testing connecting to " + completeBrokerUrl));
                ActiveMQConnectionFactory connectionFactory = this.createConnectionFactory(username, password, completeBrokerUrl);
                TopicConnection tempConnection = connectionFactory.createTopicConnection();
                tempConnection.start();
                tempConnection.stop();
                try {
                    tempConnection.close();
                }
                catch (Exception e) {
                    logger.warn((Object)"got exception when closing test connection");
                }
            }
            if (this.useReliable) {
                completeBrokerUrl = RELIABLE_CONNECTION_SPECIFIER + completeBrokerUrl;
            }
            ActiveMQConnectionFactory reliableConnectionFactory = this.createConnectionFactory(username, password, completeBrokerUrl);
            this.connection = (ActiveMQConnection)reliableConnectionFactory.createTopicConnection();
            this.connection.setExceptionListener((ExceptionListener)master);
            this.connection.start();
            logger.debug((Object)("connected to " + completeBrokerUrl));
            this.adminTopic = this.createTopic(Topics.Name.ADMIN_TOPIC, MessagingTopic.AccessMode.READ_WRITE);
            this.adminTopic.setListener(this);
            logger.debug((Object)"endpoint created succesfully");
        }
        catch (JMSException e) {
            if (e.getCause() instanceof SSLHandshakeException) {
                throw new MicroarrayException("server identity cannot be verified or other SSL error when connecting to " + this.brokerUrl, (Exception)((Object)e));
            }
            throw new MicroarrayException("could not connect to message broker at " + this.brokerUrl, (Exception)((Object)e));
        }
    }

    private static String getPassword(Configuration configuration) {
        try {
            String password = configuration.getString("security", "password");
            if (password == null || password.trim().length() == 0) {
                throw new IllegalArgumentException("Password was not available from configuration");
            }
            return password;
        }
        catch (Exception e) {
            throw new RuntimeException("reading authentication information failed: " + e.getMessage());
        }
    }

    private static String getUsername(Configuration configuration) {
        try {
            String username = configuration.getString("security", "username");
            if (username == null || username.trim().length() == 0) {
                throw new IllegalArgumentException("Username was not available from configuration");
            }
            return username;
        }
        catch (Exception e) {
            throw new RuntimeException("reading authentication information failed: " + e.getMessage());
        }
    }

    public static String getClientTruststore() throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, KeyStoreException, IOException {
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        return KeyAndTrustManager.getClientTrustStore(configuration, JMSMessagingEndpoint.getPassword(configuration));
    }

    private ActiveMQConnectionFactory createConnectionFactory(String username, String password, String completeBrokerUrl) {
        ActiveMQSslConnectionFactory reliableConnectionFactory = new ActiveMQSslConnectionFactory();
        reliableConnectionFactory.setUserName(username);
        reliableConnectionFactory.setPassword(password);
        reliableConnectionFactory.setBrokerURL(completeBrokerUrl);
        reliableConnectionFactory.setWatchTopicAdvisories(false);
        return reliableConnectionFactory;
    }

    @Override
    public MessagingTopic createTopic(Topics.Name topicName, MessagingTopic.AccessMode accessMode) throws JMSException {
        Session session = this.connection.createSession(false, 1);
        return new AuthenticatedTopic(session, topicName.toString(), MessagingTopic.Type.NORMAL, accessMode, this.authenticationListener, this);
    }

    @Override
    public void replyToMessage(ChipsterMessage original, ChipsterMessage reply) throws JMSException {
        this.replyToMessage(original, reply, this.DEFAULT_REPLY_CHANNEL);
    }

    @Override
    public void replyToMessage(ChipsterMessage original, ChipsterMessage reply, String replyChannel) throws JMSException {
        reply.setMultiplexChannel(replyChannel);
        Destination replyToDest = original.getReplyTo();
        this.sendMessage(replyToDest, reply);
    }

    @Override
    public void sendMessageToClientReplyChannel(Destination replyToDest, ChipsterMessage message) throws JMSException {
        message.setMultiplexChannel(this.DEFAULT_REPLY_CHANNEL);
        this.sendMessage(replyToDest, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(Destination replyToDest, ChipsterMessage message) throws JMSException {
        try (Session session = this.connection.createSession(false, 1);){
            MapMessage mapMessage = session.createMapMessage();
            message.marshal(mapMessage);
            session.createProducer(replyToDest).send((Message)mapMessage);
        }
    }

    @Override
    public void onChipsterMessage(ChipsterMessage msg) {
        try {
            CommandMessage txtMsg = (CommandMessage)msg;
            logger.debug((Object)("got admin request " + txtMsg.getCommand()));
            if (txtMsg.getCommand().equals("ping")) {
                CommandMessage reply = new CommandMessage("ping-reply");
                reply.addParameter(this.master.getName());
                reply.addParameter(this.master.getHost());
                this.adminTopic.sendMessage(reply);
                logger.debug((Object)("sent ping-reply from " + this.master.getHost() + "/" + this.master.getName()));
            } else if (txtMsg.getCommand().equals("request-load-info") && this.master instanceof MonitoredNode) {
                CommandMessage reply = new CommandMessage("request-load-info-reply");
                MonitoredNode mMaster = (MonitoredNode)this.master;
                reply.addParameter(this.master.getName());
                reply.addParameter(Long.toString(mMaster.countRequestsInProcessing()));
                reply.addParameter(Long.toString(mMaster.getLastProcessingTime()));
                this.adminTopic.sendMessage(reply);
                logger.debug((Object)("sent request-load-info-reply from " + this.master.getHost() + "/" + this.master.getName()));
            }
        }
        catch (JMSException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void close() throws JMSException {
        this.connection.stop();
        this.connection.close();
    }

    @Override
    public AuthenticationRequestListener getAuthenticationListener() {
        return this.authenticationListener;
    }

    @Override
    public void setAuthenticationListener(AuthenticationRequestListener authenticationListener) {
        this.authenticationListener = authenticationListener;
    }

    @Override
    public String getSessionID() {
        return this.sessionID;
    }

    @Override
    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }
}

