/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.jobmanager.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConnectionId;

@Entity
@Table(indexes={@Index(name="created", columnList="created")})
public class Job {
    @Id
    @Column(columnDefinition="uuid", updatable=false)
    private UUID jobId;
    @Lob
    private String jobMessage;
    @Lob
    private String results;
    private String compId;
    @Enumerated(value=EnumType.STRING)
    private JobState state;
    private Date created;
    private Date scheduled;
    private Date finished;
    private Date seen;
    private String replyToConnectionId;
    private int replyToSequenceId;
    private String replyToName;
    private String compHost;

    public Job() {
    }

    Job(JobMessage jobMessage) {
        this.jobId = UUID.fromString(jobMessage.getJobId());
        this.setJobMessage(jobMessage);
        this.setReplyTo((Destination)((ActiveMQTempTopic)jobMessage.getReplyTo()));
        this.created = new Date();
        this.state = JobState.WAITING;
    }

    private void setJobMessage(JobMessage jobMessage) {
        this.jobMessage = this.toJson(jobMessage);
    }

    public String getJobId() {
        return this.jobId.toString();
    }

    public JobMessage getJobMessage() {
        ActiveMQMapMessage mapMessage = this.toMapMessage(this.jobMessage);
        JobMessage jobMessage = new JobMessage();
        try {
            jobMessage.unmarshal((MapMessage)mapMessage);
            return jobMessage;
        }
        catch (JMSException e) {
            throw new IllegalArgumentException("unable to unmarshal chipster message", e);
        }
    }

    public Date getScheduled() {
        return this.scheduled;
    }

    public ResultMessage getResults() {
        ActiveMQMapMessage mapMessage = this.toMapMessage(this.results);
        ResultMessage resultMessage = new ResultMessage();
        try {
            resultMessage.unmarshal((MapMessage)mapMessage);
            return resultMessage;
        }
        catch (JMSException e) {
            throw new IllegalArgumentException("unable to unmarshal chipster message", e);
        }
    }

    public JobState getState() {
        return this.state;
    }

    public String getCompId() {
        return this.compId;
    }

    public Destination getReplyTo() {
        if (this.replyToName != null) {
            return new ActiveMQTopic(this.replyToName);
        }
        return new ActiveMQTempTopic(new ConnectionId(this.replyToConnectionId), (long)this.replyToSequenceId);
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getFinished() {
        return this.finished;
    }

    public void setFinished(Date finished) {
        this.finished = finished;
    }

    public long getSecondsSinceCreated() {
        return (System.currentTimeMillis() - this.created.getTime()) / 1000L;
    }

    void setScheduled(Date scheduled) {
        this.scheduled = scheduled;
    }

    void setResults(ResultMessage results) {
        this.results = this.toJson(results);
    }

    void setState(JobState state) {
        this.state = state;
    }

    void setCompId(String compId) {
        this.compId = compId;
    }

    void setReplyTo(Destination replyTo) {
        if (replyTo instanceof ActiveMQTempTopic) {
            ActiveMQTempTopic tempTopic = (ActiveMQTempTopic)replyTo;
            this.replyToConnectionId = tempTopic.getConnectionId();
            this.replyToSequenceId = tempTopic.getSequenceId();
            this.replyToName = null;
        } else if (replyTo instanceof ActiveMQTopic) {
            ActiveMQTopic topic = (ActiveMQTopic)replyTo;
            try {
                this.replyToConnectionId = null;
                this.replyToSequenceId = 0;
                this.replyToName = topic.getTopicName();
            }
            catch (JMSException e) {
                throw new IllegalArgumentException("unable to get topic name", e);
            }
        } else {
            throw new IllegalArgumentException("unknown destination type " + replyTo.getClass().getName());
        }
    }

    void setSeen(Date seen) {
        this.seen = seen;
    }

    private String toJson(ChipsterMessage chipsterMessage) {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        try {
            chipsterMessage.marshal((MapMessage)msg);
            HashMap msgMap = new HashMap();
            HashMap<String, String> properties = new HashMap<String, String>();
            HashMap<String, String> content = new HashMap<String, String>();
            for (String name : msg.getProperties().keySet()) {
                properties.put(name, msg.getStringProperty(name));
            }
            for (String name : msg.getContentMap().keySet()) {
                content.put(name, msg.getString(name));
            }
            msgMap.put("properties", properties);
            msgMap.put("content", content);
            String json = new GsonBuilder().serializeNulls().create().toJson(msgMap);
            return json;
        }
        catch (IOException | JMSException e) {
            throw new IllegalArgumentException("unable to marshal chipster message", e);
        }
    }

    private ActiveMQMapMessage toMapMessage(String json) {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        LinkedTreeMap msgMap = (LinkedTreeMap)new Gson().fromJson(json, LinkedTreeMap.class);
        LinkedTreeMap properties = (LinkedTreeMap)msgMap.get((Object)"properties");
        LinkedTreeMap content = (LinkedTreeMap)msgMap.get((Object)"content");
        try {
            for (String key : properties.keySet()) {
                msg.setStringProperty(key, (String)properties.get((Object)key));
            }
            for (String key : content.keySet()) {
                msg.setString(key, (String)content.get((Object)key));
            }
            return msg;
        }
        catch (JMSException e) {
            throw new IllegalArgumentException("unable to unmarshal chipster message", e);
        }
    }

    public void setCompHost(String compHost) {
        this.compHost = compHost;
    }

    public String getCompHost() {
        return this.compHost;
    }
}

