/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.jobmanager;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;

public class HibernateUtil {
    private static Logger logger = Logger.getLogger(HibernateUtil.class.getName());
    private SessionFactory sessionFactory;

    public void buildSessionFactory(List<Class<?>> hibernateClasses, fi.csc.microarray.config.Configuration config) {
        try {
            Configuration hibernateConf = new Configuration();
            String dbDriver = config.getString("jobmanager", "hibernate-driver");
            String dbDialect = config.getString("jobmanager", "hibernate-dialect");
            String dbUrl = config.getString("jobmanager", "hibernate-url");
            String dbUsername = config.getString("jobmanager", "hibernate-username");
            String dbPassword = config.getString("jobmanager", "hibernate-password");
            String showSql = config.getBoolean("jobmanager", "hibernate-show-sql") ? "true" : "false";
            String dbSchemaUpdate = config.getString("jobmanager", "hibernate-schema");
            hibernateConf.setProperty("hibernate.connection.driver_class", dbDriver);
            hibernateConf.setProperty("hibernate.connection.url", dbUrl);
            hibernateConf.setProperty("hibernate.connection.username", dbUsername);
            hibernateConf.setProperty("hibernate.connection.password", dbPassword);
            hibernateConf.setProperty("hibernate.dialect", dbDialect);
            hibernateConf.setProperty("hibernate.show_sql", showSql);
            hibernateConf.setProperty("hibernate.current_session_context_class", "thread");
            hibernateConf.setProperty("hibernate.hbm2ddl.auto", dbSchemaUpdate);
            hibernateConf.setProperty("hibernate.c3p0.min_size", "3");
            for (Class<?> c : hibernateClasses) {
                hibernateConf.addAnnotatedClass(c);
            }
            this.sessionFactory = hibernateConf.buildSessionFactory((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)hibernateConf.getProperties()).build());
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "sessionFactory creation failed.", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Session beginTransaction() {
        Session session = this.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        return session;
    }

    public void commit() {
        this.getSessionFactory().getCurrentSession().getTransaction().commit();
    }

    public void rollback() {
        this.getSessionFactory().getCurrentSession().getTransaction().rollback();
    }

    public Session session() {
        return this.getSessionFactory().getCurrentSession();
    }

    public void rollbackIfActive() {
        if (this.session().getTransaction().isActive()) {
            this.session().getTransaction().rollback();
        }
    }
}

