/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.filebroker.DbFile;
import fi.csc.microarray.filebroker.DerbyMetadataServer;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.filebroker.Md5FileUtils;
import fi.csc.microarray.security.CryptoKey;
import fi.csc.microarray.util.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FileServerAdminTools {
    public DerbyMetadataServer metadataServer;
    public File cacheRoot;
    public File storageRoot;
    private boolean calculateChecksums;

    public FileServerAdminTools(DerbyMetadataServer metadataServer, File cacheRoot, File storageRoot, boolean calculateChecksums) {
        this.metadataServer = metadataServer;
        this.cacheRoot = cacheRoot;
        this.storageRoot = storageRoot;
        this.calculateChecksums = calculateChecksums;
    }

    public String getDataBaseStatusReport() throws SQLException {
        List<String>[] stats = this.metadataServer.getStatistics();
        List<String> keys = stats[0];
        List<String> values = stats[1];
        String report = "DATABASE STATUS REPORT\n\n";
        for (int i = 0; i < keys.size() && i < values.size(); ++i) {
            report = report + keys.get(i) + "\t" + values.get(i) + "\n";
        }
        return report;
    }

    public String getStorageStatusReport(boolean calculateChecksums) throws UnsupportedEncodingException, FileNotFoundException, FileBrokerException, IOException, SQLException {
        HashSet<String> dataIds = this.getAllDataIds();
        HashMap<String, String> dataIdErrors = this.getDataIdErrors(dataIds);
        HashMap<String, String> dataIdWarnings = this.getDataIdWarnings(dataIds);
        long errorTotalSize = this.getTotalSize(dataIdErrors.keySet());
        long warningTotalSize = this.getTotalSize(dataIdWarnings.keySet());
        HashSet<String> dataIdOk = new HashSet<String>(dataIds);
        dataIdOk.removeAll(dataIdErrors.keySet());
        dataIdOk.removeAll(dataIdWarnings.keySet());
        long okTotalSize = this.getTotalSize(dataIdOk);
        HashSet<String> otherFiles = this.getOtherFiles();
        long otherFilesTotalSize = this.getTotalSize(otherFiles);
        String report = "STORAGE STATUS REPORT\n";
        report = report + "\n** Summary\n";
        report = report + "ok datasets:      \t" + dataIdOk.size() + "\ttotal size: \t" + okTotalSize / 1024L / 1024L + " MB\n";
        report = report + "warning datasets: \t" + dataIdWarnings.size() + "\ttotal size: \t" + warningTotalSize / 1024L / 1024L + " MB\n";
        report = report + "error datasets:   \t" + dataIdErrors.size() + "\ttotal size: \t" + errorTotalSize / 1024L / 1024L + " MB\n";
        report = report + "unknown files:    \t" + otherFiles.size() + "\ttotal size: \t" + otherFilesTotalSize / 1024L / 1024L + " MB\n";
        if (!dataIdWarnings.isEmpty()) {
            report = report + "\n** Warnings\n";
            for (Map.Entry<String, String> entry : dataIdWarnings.entrySet()) {
                report = report + entry.getValue() + "\t" + entry.getKey() + "\n";
            }
        }
        if (!dataIdErrors.isEmpty()) {
            report = report + "\n** Errors\n";
            for (Map.Entry entry : dataIdErrors.entrySet()) {
                report = report + (String)entry.getValue() + "\t" + (String)entry.getKey() + "\n";
            }
        }
        if (!otherFiles.isEmpty()) {
            report = report + "\n** Unknown files\n";
            for (String string : otherFiles) {
                report = report + string + "\n";
            }
        }
        return report;
    }

    private long getTotalSize(Collection<String> filenames) {
        long totalSize = 0L;
        for (String filename : filenames) {
            File file = this.getFile(filename);
            totalSize += file.length();
        }
        return totalSize;
    }

    private HashMap<String, String> getDataIdWarnings(HashSet<String> dataIds) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        HashMap<String, String> dataIdWarnings = new HashMap<String, String>();
        for (String dataId : dataIds) {
            List<String> warnings = this.getWarnings(dataId);
            if (warnings.isEmpty()) continue;
            dataIdWarnings.put(dataId, Strings.delimit(warnings, ", "));
        }
        return dataIdWarnings;
    }

    private HashMap<String, String> getDataIdErrors(HashSet<String> dataIds) throws UnsupportedEncodingException, FileNotFoundException, IOException, SQLException {
        HashMap<String, String> dataIdErrors = new HashMap<String, String>();
        for (String dataId : dataIds) {
            List<String> errors = this.getErrors(dataId);
            if (errors.isEmpty()) continue;
            dataIdErrors.put(dataId, Strings.delimit(errors, ", "));
        }
        return dataIdErrors;
    }

    private List<String> getWarnings(String dataId) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        String md5;
        ArrayList<String> warnings = new ArrayList<String>();
        File file = this.getFile(dataId);
        if (file.exists() && (md5 = Md5FileUtils.readMd5WithoutParseException(file)) == null) {
            warnings.add("no md5 file");
        }
        return warnings;
    }

    private List<String> getErrors(String dataId) throws UnsupportedEncodingException, FileNotFoundException, IOException, SQLException {
        DbFile dbFile;
        String md5;
        ArrayList<String> errors = new ArrayList<String>();
        File file = this.getFile(dataId);
        if (!file.exists()) {
            errors.add("not on disk");
        }
        if (this.calculateChecksums && (md5 = Md5FileUtils.readMd5WithoutParseException(file)) != null && file.exists() && !md5.equals(Md5FileUtils.calculateMd5(file))) {
            errors.add("checksum error");
        }
        if ((dbFile = this.metadataServer.fetchFile(dataId)) == null) {
            errors.add("not in database");
        } else if (file.exists() && file.length() != dbFile.getSize()) {
            errors.add("different size");
        }
        return errors;
    }

    private File getFile(String dataId) {
        return new File(this.storageRoot, dataId);
    }

    private HashSet<String> getAllDataIds() throws SQLException {
        HashSet<String> dataIds = this.getDataFiles();
        dataIds.addAll(this.getMd5Files());
        for (DbFile file : this.metadataServer.listAllFiles()) {
            dataIds.add(file.getUuid());
        }
        return dataIds;
    }

    private HashSet<String> getMd5Files() {
        HashSet<String> dataIds = new HashSet<String>();
        for (File file : this.storageRoot.listFiles()) {
            if (!this.isMd5File(file)) continue;
            dataIds.add(file.getName().replace(".md5", ""));
        }
        return dataIds;
    }

    private HashSet<String> getDataFiles() {
        HashSet<String> dataIds = new HashSet<String>();
        for (File file : this.storageRoot.listFiles()) {
            if (!this.isDataFile(file)) continue;
            dataIds.add(file.getName());
        }
        return dataIds;
    }

    private HashSet<String> getOtherFiles() {
        HashSet<String> filenames = new HashSet<String>();
        for (File file : this.storageRoot.listFiles()) {
            if (this.isDataFile(file) || this.isMd5File(file)) continue;
            filenames.add(file.getName());
        }
        return filenames;
    }

    private boolean isDataFile(File file) {
        return CryptoKey.validateKeySyntax(file.getName());
    }

    private boolean isMd5File(File file) {
        return file.getName().endsWith(".md5");
    }
}

