/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.filebroker.DbFile;
import fi.csc.microarray.filebroker.DbSession;
import fi.csc.microarray.filebroker.DerbyMetadataServer;
import fi.csc.microarray.filebroker.FileServer;
import fi.csc.microarray.filebroker.ServerSessionImportExportTool;
import fi.csc.microarray.messaging.DirectMessagingEndpoint;
import java.io.File;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class ExampleSessionUpdater {
    private static Logger logger = Logger.getLogger(ExampleSessionUpdater.class);
    private File exampleSessionDir;
    public DerbyMetadataServer metadataServer;
    private ServerSessionImportExportTool importExportTool;
    private FileServer fileServer;

    public ExampleSessionUpdater(FileServer fileServer, DerbyMetadataServer metadataServer, File exampleSessionDir) throws Exception {
        this.fileServer = fileServer;
        this.metadataServer = metadataServer;
        this.exampleSessionDir = exampleSessionDir;
        DirectMessagingEndpoint directEndpoint = new DirectMessagingEndpoint("example_session_owner");
        fileServer.addEndpoint(directEndpoint);
        this.importExportTool = new ServerSessionImportExportTool(directEndpoint);
        if (!this.exampleSessionDir.exists()) {
            logger.info((Object)("example session directory " + this.exampleSessionDir + " doesn't exist"));
            logger.info((Object)"example session import is disabled");
        }
    }

    public void importExampleSessions() throws JMSException, SQLException, Exception {
        if (this.exampleSessionDir.exists()) {
            List<DbSession> dbSessionList = this.metadataServer.listPublicSessions();
            HashMap<String, DbSession> dbSessions = new HashMap<String, DbSession>();
            for (DbSession dbSession : dbSessionList) {
                String basename = dbSession.getBasename();
                if (basename == null) continue;
                dbSessions.put(basename, dbSession);
            }
            logger.info((Object)("found " + dbSessions.size() + " example session on the server"));
            logger.debug((Object)("searching example sessions from " + this.exampleSessionDir));
            HashMap<String, File> zipSessions = new HashMap<String, File>();
            for (File file : this.exampleSessionDir.listFiles()) {
                if (!this.isZipSession(file)) continue;
                String basename = this.importExportTool.filenameToBasename(file.getName());
                zipSessions.put(basename, file);
            }
            logger.info((Object)("found " + zipSessions.size() + " example session zip files"));
            Iterator iterator = dbSessions.keySet().iterator();
            while (iterator.hasNext()) {
                String dbSessionBasename = (String)iterator.next();
                if (zipSessions.containsKey(dbSessionBasename)) continue;
                logger.info((Object)("found a server session  '" + dbSessionBasename + "', but no zip session with that name. Going to remove the server session"));
                this.fileServer.removeSession(((DbSession)dbSessions.get(dbSessionBasename)).getDataId());
                iterator.remove();
            }
            logger.info((Object)(dbSessions.size() + " example sessions on the server left"));
            for (String zipSessionBasename : zipSessions.keySet()) {
                File zipSessionFile = (File)zipSessions.get(zipSessionBasename);
                DbSession dbSession = (DbSession)dbSessions.get(zipSessionBasename);
                boolean store = false;
                if (dbSession == null) {
                    logger.debug((Object)("found a zip session '" + zipSessionBasename + "', but there is no server session with that name"));
                    store = true;
                } else {
                    Timestamp dbSessionCreated = this.getTimestamp(dbSession.getDataId());
                    Timestamp zipSessionModified = this.getTimestamp(zipSessionFile);
                    store = zipSessionModified.after(dbSessionCreated);
                }
                if (store) {
                    logger.info((Object)("storing example session '" + zipSessionBasename + "'"));
                    this.importExportTool.importSession(zipSessionFile);
                    logger.debug((Object)"example session stored");
                    continue;
                }
                logger.debug((Object)("example session '" + zipSessionBasename + "' is up-to-date"));
            }
            logger.info((Object)"example session import done");
        }
    }

    private Timestamp getTimestamp(File file) {
        return new Timestamp(file.lastModified());
    }

    private Timestamp getTimestamp(String dataId) throws SQLException {
        DbFile dbSessionFile = this.metadataServer.fetchFile(dataId);
        return Timestamp.valueOf(dbSessionFile.getCreated());
    }

    private boolean isZipSession(File file) {
        return file.getName().endsWith(".zip");
    }
}

