/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.handlers;

import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.handlers.ContentHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;

public class LocalFileContentHandler
implements ContentHandler {
    @Override
    public InputStream getInputStream(DataManager.ContentLocation location) throws FileNotFoundException {
        this.checkCompatibility(location);
        return new BufferedInputStream(new FileInputStream(this.getFile(location)));
    }

    @Override
    public OutputStream getOutputStream(DataManager.ContentLocation location) throws IOException {
        this.checkCompatibility(location);
        return new BufferedOutputStream(new FileOutputStream(this.getFile(location)));
    }

    @Override
    public Long getContentLength(DataManager.ContentLocation location) {
        this.checkCompatibility(location);
        return this.getFile(location).length();
    }

    @Override
    public void markDeletable(DataManager.ContentLocation location) {
        if (location.getMethod() == DataManager.StorageMethod.LOCAL_TEMP) {
            this.checkCompatibility(location);
            File file = this.getFile(location);
            file.delete();
        }
    }

    @Override
    public void checkCompatibility(DataManager.ContentLocation location) throws IllegalArgumentException {
        URL url = location.getUrl();
        if (url == null) {
            throw new IllegalArgumentException("url is null.");
        }
        if (!"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Protocol of " + url.toString() + " is not \"file\".");
        }
        if (url.getPath() == null || url.getPath().length() == 0) {
            throw new IllegalArgumentException("Illegal path: " + url.toString());
        }
    }

    public File getFile(DataManager.ContentLocation location) {
        File file;
        this.checkCompatibility(location);
        try {
            file = new File(location.getUrl().toURI());
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(location.getUrl() + " does not point to a file.");
        }
        return file;
    }

    @Override
    public boolean isAccessible(DataManager.ContentLocation location) {
        this.checkCompatibility(location);
        return this.getFile(location).exists();
    }
}

