/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import fi.csc.chipster.toolbox.SADLTool;
import fi.csc.microarray.comp.java.JavaCompJobBase;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SADLDescriptionTest {
    public static void main(String[] args) throws Exception {
        SADLDescriptionTest test = new SADLDescriptionTest();
        test.testDescriptions();
        test.testSADLTool();
        System.out.println("SADLDescriptionTest OK");
    }

    @Test
    public void testSADLTool() throws IOException {
        String rScript = "# TOOL \"BLAST\" / blastn.sadl: blastn (Heuristic tool to search hits for a nucleotide sequence from a nucleotode sequence database.)\n# INPUT query: \"Query sequence\" TYPE GENERIC\n# OUTPUT out.txt\n# PARAMETER OPTIONAL query_loc: \"Location on the query sequence\" TYPE STRING (Location of the search region on the query sequence. Format: start-stop, for example: 23-66.  Default: the whole query sequence)\n# PARAMETER OPTIONAL strand: \"Query strand\" TYPE [both: Both, minus: Minus, plus: Plus] DEFAULT both ( Query strand or strands to search against the database.  Default: both strands.)\n\necho('foo');\n";
        SADLTool tool = new SADLTool("#");
        SADLTool.ParsedScript parsedScript = tool.parseScript(new ByteArrayInputStream(rScript.getBytes()));
        String rScript2 = tool.toScriptString(parsedScript);
        Assert.assertEquals((Object)rScript2, (Object)rScript);
    }

    @Test
    public void testDescriptions() throws Exception {
        int j;
        DirectoryLayout.uninitialise();
        DirectoryLayout.initialiseUnitTestLayout();
        class ToolSpec {
            private String module;
            private String resource;
            private String runtime;
            private String runtimeDir;
            private String toolSpecificModule;
            private boolean isHidden;

            public ToolSpec(String module, String resource, String runtime, String runtimeDir, String toolSpecificModule, boolean isHidden) {
                this.module = module;
                this.resource = resource;
                this.runtime = runtime;
                this.runtimeDir = runtimeDir;
                this.toolSpecificModule = toolSpecificModule;
                this.isHidden = isHidden;
            }
        }
        LinkedList<ToolSpec> toolSpecs = new LinkedList<ToolSpec>();
        HashMap<String, String> runtimeDirMap = new HashMap<String, String>();
        Document runtimeDoc = XmlUtil.parseFile(new File("src/main/applications/wrapper/comp/conf/runtimes.xml"));
        NodeList runtimes = runtimeDoc.getDocumentElement().getElementsByTagName("runtime");
        for (int i = 0; i < runtimes.getLength(); ++i) {
            Element runtime = (Element)runtimes.item(i);
            String name = runtime.getElementsByTagName("name").item(0).getTextContent();
            String dir = null;
            NodeList parameters = runtime.getElementsByTagName("parameter");
            for (j = 0; j < parameters.getLength(); ++j) {
                if (!"toolPath".equals(((Element)parameters.item(j)).getElementsByTagName("name").item(0).getFirstChild().getTextContent())) continue;
                dir = ((Element)parameters.item(j)).getElementsByTagName("value").item(0).getFirstChild().getTextContent();
                break;
            }
            runtimeDirMap.put(name, dir);
        }
        for (File file : Files.listFilesRecursively(new File("../chipster-tools/modules/"))) {
            if (!file.getName().endsWith("-module.xml")) continue;
            Document module = XmlUtil.parseFile(file);
            String moduleName = module.getDocumentElement().getAttribute("name");
            NodeList categories = module.getDocumentElement().getElementsByTagName("category");
            for (j = 0; j < categories.getLength(); ++j) {
                Element category = (Element)categories.item(j);
                boolean isHidden = "true".equals(category.getAttribute("hidden"));
                NodeList tools = category.getElementsByTagName("tool");
                for (int i = 0; i < tools.getLength(); ++i) {
                    Element tool = (Element)tools.item(i);
                    String runtimeName = tool.getAttribute("runtime");
                    String moduleOverride = tool.getAttribute("module");
                    String toolSpecificModule = moduleOverride.isEmpty() ? moduleName : moduleOverride;
                    String resource = tool.getElementsByTagName("resource").item(0).getTextContent();
                    toolSpecs.add(new ToolSpec(moduleName, resource.trim(), runtimeName, (String)runtimeDirMap.get(runtimeName), toolSpecificModule, isHidden));
                }
            }
        }
        String missingManuals = "";
        for (ToolSpec toolspec : toolSpecs) {
            try {
                String manualName;
                boolean isFile;
                String sadl = null;
                if ("java".equals(toolspec.runtime)) {
                    System.out.println("validating class " + toolspec.resource + " in " + toolspec.module);
                    JavaCompJobBase jobBase = (JavaCompJobBase)Class.forName(toolspec.resource).newInstance();
                    sadl = jobBase.getSADL();
                    isFile = false;
                    manualName = toolspec.resource.substring(toolspec.resource.lastIndexOf(46) + 1);
                } else {
                    SADLTool.ParsedScript res;
                    isFile = true;
                    manualName = toolspec.resource.substring(0, toolspec.resource.indexOf(46));
                    File file = new File(new File("../chipster-tools/modules"), toolspec.toolSpecificModule + File.separator + toolspec.runtimeDir + File.separator + toolspec.resource);
                    if (file.getName().endsWith(".R") || file.getName().endsWith(".py")) {
                        res = new SADLTool("#").parseScript(new FileInputStream(file));
                        sadl = res.SADL;
                    } else if (file.getName().endsWith(".bsh")) {
                        res = new SADLTool("//").parseScript(new FileInputStream(file));
                        sadl = res.SADL;
                    } else {
                        if (file.getName().endsWith(".acd")) continue;
                        sadl = Files.fileToString(file);
                    }
                    System.out.println("validating file " + file.getCanonicalFile() + " in " + toolspec.module);
                }
                if (sadl != null) {
                    List<SADLDescription> descriptions = new ChipsterSADLParser.Validator().validate(toolspec.resource, sadl);
                    Assert.assertEquals((long)1L, (long)descriptions.size());
                    if (isFile) {
                        Assert.assertEquals((Object)toolspec.resource, (Object)descriptions.get(0).getName().getID());
                    }
                    if (toolspec.isHidden || new File("../chipster-tools/manual/" + manualName + ".html").exists()) continue;
                    missingManuals = missingManuals + "\nManual page missing for " + toolspec.resource;
                    continue;
                }
                throw new RuntimeException("don't know what to do with: " + toolspec);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("when parsing " + toolspec + ": " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")"));
            }
        }
        System.out.println(missingManuals);
    }
}

