/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import fi.csc.microarray.comp.ProcessUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class ResourceMonitor {
    static final Logger logger = Logger.getLogger(ResourceMonitor.class);
    private HashMap<Process, ProcessUtils.ProcessResourceMonitor> monitors = new HashMap();
    private Timer resourceMonitorTimer;
    private ProcessProvider processProvider;

    public ResourceMonitor(ProcessProvider processProvider, int monitoringInterval) {
        if (monitoringInterval >= 0) {
            this.processProvider = processProvider;
            this.resourceMonitorTimer = new Timer(true);
            this.resourceMonitorTimer.schedule((TimerTask)new ResourceMonitorTask(), monitoringInterval, (long)monitoringInterval);
        }
    }

    public String getMaxMemHumanFriendly(Process process) {
        return ProcessUtils.humanFriendly(this.getMaxMem(process));
    }

    public Long getMaxMem(Process process) {
        ProcessUtils.ProcessResourceMonitor monitor = this.monitors.get(process);
        if (monitor == null) {
            return null;
        }
        return monitor.getMaxMem();
    }

    public class ResourceMonitorTask
    extends TimerTask {
        @Override
        public void run() {
            try {
                long t = System.currentTimeMillis();
                Collection<Process> runningProcesses = ResourceMonitor.this.processProvider.getRunningJobProcesses();
                logger.debug((Object)("running processes " + runningProcesses.size()));
                ResourceMonitor.this.monitors.keySet().retainAll(runningProcesses);
                for (Process process : runningProcesses) {
                    if (!ResourceMonitor.this.monitors.containsKey(process)) {
                        ResourceMonitor.this.monitors.put(process, new ProcessUtils.ProcessResourceMonitor(process));
                    }
                    ((ProcessUtils.ProcessResourceMonitor)ResourceMonitor.this.monitors.get(process)).update();
                }
                long dt = System.currentTimeMillis() - t;
                if (dt > 500L) {
                    logger.warn((Object)("process monitoring took " + (System.currentTimeMillis() - t) + "ms"));
                }
            }
            catch (IOException e) {
                logger.error((Object)"failed to monitor process resource usage", (Throwable)e);
            }
        }
    }

    public static interface ProcessProvider {
        public Collection<Process> getRunningJobProcesses();
    }
}

